/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.skill;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.animation.property.Property;
import maninhouse.epicfight.animation.types.EntityState;
import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import maninhouse.epicfight.capabilities.item.CapabilityItem;
import maninhouse.epicfight.client.capabilites.entity.ClientPlayerData;
import maninhouse.epicfight.entity.ai.attribute.ModAttributes;
import maninhouse.epicfight.network.ModNetworkManager;
import maninhouse.epicfight.network.client.CTSExecuteSkill;
import maninhouse.epicfight.skill.Skill;
import maninhouse.epicfight.skill.SkillSlot;
import maninhouse.epicfight.utils.game.IExtendedDamageSource;
import maninhouse.epicfight.utils.math.ValueCorrector;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class SpecialAttackSkill
extends Skill {
    protected List<Map<Property.PhaseProperty<?>, Object>> properties = Lists.newArrayList();

    public SpecialAttackSkill(float restriction, String skillName) {
        this(restriction, 0, 1, Skill.ActivateType.ONE_SHOT, skillName);
    }

    public SpecialAttackSkill(float restriction, int duration, Skill.ActivateType activateType, String skillName) {
        this(restriction, duration, 1, activateType, skillName);
    }

    public SpecialAttackSkill(float restriction, int duration, int maxStack, Skill.ActivateType activateType, String skillName) {
        super(SkillSlot.WEAPON_SPECIAL_ATTACK, restriction, duration, maxStack, true, activateType, Skill.CooldownType.NONE, skillName);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void executeOnClient(ClientPlayerData executer, PacketBuffer args) {
        if (this.canExecute(executer)) {
            ModNetworkManager.sendToServer(new CTSExecuteSkill(this.slot.getIndex(), true, args));
        }
    }

    @Override
    public boolean canExecute(PlayerData<?> executer) {
        CapabilityItem item = executer.getHeldItemCapability(Hand.MAIN_HAND);
        if (item != null) {
            return item.getSpecialAttack(executer) == this && ((PlayerEntity)executer.getOriginalEntity()).func_184187_bx() == null && (!executer.getSkill(this.slot).isActivated() || this.activateType == Skill.ActivateType.TOGGLE);
        }
        return false;
    }

    @Override
    public boolean isExecutableState(PlayerData<?> executer) {
        EntityState playerState = executer.getEntityState();
        return !((PlayerEntity)executer.getOriginalEntity()).func_184613_cA() && executer.currentMotion != LivingMotion.FALL && playerState.canAct();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<ITextComponent> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerData<?> playerCap) {
        ArrayList list = Lists.newArrayList();
        list.add(new TranslationTextComponent("skill.epicfight." + this.registryName.func_110623_a()).func_240699_a_(TextFormatting.WHITE).func_230529_a_((ITextComponent)new StringTextComponent(String.format("[%.0f]", Float.valueOf(this.cooldown))).func_240699_a_(TextFormatting.AQUA)));
        list.add(new TranslationTextComponent("skill.epicfight." + this.registryName.func_110623_a() + "_tooltip").func_240699_a_(TextFormatting.DARK_GRAY));
        return list;
    }

    protected void generateTooltipforPhase(List<ITextComponent> list, ItemStack itemStack, CapabilityItem cap, PlayerData<?> playerCap, Map<Property.PhaseProperty<?>, Object> propertyMap, String title) {
        Multimap attributes = itemStack.func_111283_C(EquipmentSlotType.MAINHAND);
        Multimap<Attribute, AttributeModifier> capAttributes = cap.getAttributeModifiers(EquipmentSlotType.MAINHAND, playerCap);
        double damage = ((PlayerEntity)playerCap.getOriginalEntity()).func_110148_a(Attributes.field_233823_f_).func_111125_b();
        double armorNegation = ((PlayerEntity)playerCap.getOriginalEntity()).func_110148_a((Attribute)ModAttributes.ARMOR_NEGATION.get()).func_111125_b();
        double impact = ((PlayerEntity)playerCap.getOriginalEntity()).func_110148_a((Attribute)ModAttributes.IMPACT.get()).func_111125_b();
        double maxStrikes = ((PlayerEntity)playerCap.getOriginalEntity()).func_110148_a((Attribute)ModAttributes.MAX_STRIKES.get()).func_111125_b();
        ValueCorrector damageCorrector = ValueCorrector.base();
        ValueCorrector armorNegationCorrector = ValueCorrector.base();
        ValueCorrector impactCorrector = ValueCorrector.base();
        ValueCorrector maxStrikesCorrector = ValueCorrector.base();
        for (AttributeModifier modifier : attributes.get((Object)Attributes.field_233823_f_)) {
            damage += modifier.func_111164_d();
        }
        for (AttributeModifier modifier : capAttributes.get((Object)ModAttributes.ARMOR_NEGATION.get())) {
            armorNegation += modifier.func_111164_d();
        }
        for (AttributeModifier modifier : capAttributes.get((Object)ModAttributes.IMPACT.get())) {
            impact += modifier.func_111164_d();
        }
        for (AttributeModifier modifier : capAttributes.get((Object)ModAttributes.MAX_STRIKES.get())) {
            maxStrikes += modifier.func_111164_d();
        }
        this.getProperty(Property.PhaseProperty.DAMAGE, propertyMap).ifPresent(damageCorrector::merge);
        this.getProperty(Property.PhaseProperty.ARMOR_NEGATION, propertyMap).ifPresent(armorNegationCorrector::merge);
        this.getProperty(Property.PhaseProperty.IMPACT, propertyMap).ifPresent(impactCorrector::merge);
        this.getProperty(Property.PhaseProperty.MAX_STRIKES, propertyMap).ifPresent(maxStrikesCorrector::merge);
        damage = damageCorrector.get((float)damage);
        armorNegation = armorNegationCorrector.get((float)armorNegation);
        impact = impactCorrector.get((float)impact);
        maxStrikes = maxStrikesCorrector.get((float)maxStrikes);
        list.add((ITextComponent)new StringTextComponent(title).func_240699_a_(TextFormatting.UNDERLINE).func_240699_a_(TextFormatting.GRAY));
        IFormattableTextComponent damageComponent = new TranslationTextComponent("skill.epicfight.damage", new Object[]{new StringTextComponent(ItemStack.field_111284_a.format(damage)).func_240699_a_(TextFormatting.RED)}).func_240699_a_(TextFormatting.DARK_GRAY);
        this.getProperty(Property.PhaseProperty.EXTRA_DAMAGE, propertyMap).ifPresent(extraDamage -> damageComponent.func_230529_a_((ITextComponent)new TranslationTextComponent(extraDamage.toString(), new Object[]{new StringTextComponent(ItemStack.field_111284_a.format(extraDamage.getArgument() * 100.0f) + "%").func_240699_a_(TextFormatting.RED)})).func_240699_a_(TextFormatting.DARK_GRAY));
        list.add((ITextComponent)damageComponent);
        if (armorNegation != 0.0) {
            list.add((ITextComponent)new TranslationTextComponent(((Attribute)ModAttributes.ARMOR_NEGATION.get()).func_233754_c_(), new Object[]{new StringTextComponent(ItemStack.field_111284_a.format(armorNegation)).func_240699_a_(TextFormatting.GOLD)}).func_240699_a_(TextFormatting.DARK_GRAY));
        }
        if (impact != 0.0) {
            list.add((ITextComponent)new TranslationTextComponent(((Attribute)ModAttributes.IMPACT.get()).func_233754_c_(), new Object[]{new StringTextComponent(ItemStack.field_111284_a.format(impact)).func_240699_a_(TextFormatting.AQUA)}).func_240699_a_(TextFormatting.DARK_GRAY));
        }
        list.add((ITextComponent)new TranslationTextComponent(((Attribute)ModAttributes.MAX_STRIKES.get()).func_233754_c_(), new Object[]{new StringTextComponent(ItemStack.field_111284_a.format(maxStrikes)).func_240699_a_(TextFormatting.WHITE)}).func_240699_a_(TextFormatting.DARK_GRAY));
        Optional<IExtendedDamageSource.StunType> stunOption = this.getProperty(Property.PhaseProperty.STUN_TYPE, propertyMap);
        stunOption.ifPresent(stunType -> list.add((ITextComponent)new StringTextComponent(TextFormatting.DARK_GRAY + "Apply " + stunType.toString())));
        if (!stunOption.isPresent()) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.DARK_GRAY + "Apply " + IExtendedDamageSource.StunType.SHORT.toString()));
        }
    }

    protected <V> Optional<V> getProperty(Property.PhaseProperty<V> propertyType, Map<Property.PhaseProperty<?>, Object> map) {
        return Optional.ofNullable(map.get(propertyType));
    }

    public SpecialAttackSkill newPropertyLine() {
        this.properties.add(Maps.newHashMap());
        return this;
    }

    public <T> SpecialAttackSkill addProperty(Property.PhaseProperty<T> attribute, T object) {
        this.properties.get(this.properties.size() - 1).put(attribute, object);
        return this;
    }

    public abstract SpecialAttackSkill registerPropertiesToAnimation();
}

