/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.utils.math;

import com.mojang.blaze3d.matrix.MatrixStack;
import maninhouse.epicfight.utils.math.Vec3f;
import maninhouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class MathUtils {
    public static VisibleMatrix4f getModelMatrixIntegrated(float prevPosX, float posX, float prevPosY, float posY, float prevPosZ, float posZ, float prevPitch, float pitch, float prevYaw, float yaw, float partialTick, float scaleX, float scaleY, float scaleZ) {
        VisibleMatrix4f modelMatrix = new VisibleMatrix4f().setIdentity();
        Vec3f entityPosition = new Vec3f(-(prevPosX + (posX - prevPosX) * partialTick), prevPosY + (posY - prevPosY) * partialTick, -(prevPosZ + (posZ - prevPosZ) * partialTick));
        VisibleMatrix4f.translate(entityPosition, modelMatrix, modelMatrix);
        float pitchDegree = MathUtils.interpolateRotation(prevPitch, pitch, partialTick);
        float yawDegree = MathUtils.interpolateRotation(prevYaw, yaw, partialTick);
        VisibleMatrix4f.rotate((float)(-Math.toRadians(yawDegree)), new Vec3f(0.0f, 1.0f, 0.0f), modelMatrix, modelMatrix);
        VisibleMatrix4f.rotate((float)(-Math.toRadians(pitchDegree)), new Vec3f(1.0f, 0.0f, 0.0f), modelMatrix, modelMatrix);
        VisibleMatrix4f.scale(new Vec3f(scaleX, scaleY, scaleZ), modelMatrix, modelMatrix);
        return modelMatrix;
    }

    public static Vector3d getVectorForRotation(float pitch, float yaw) {
        float f = pitch * ((float)Math.PI / 180);
        float f1 = -yaw * ((float)Math.PI / 180);
        float f2 = MathHelper.func_76134_b((float)f1);
        float f3 = MathHelper.func_76126_a((float)f1);
        float f4 = MathHelper.func_76134_b((float)f);
        float f5 = MathHelper.func_76126_a((float)f);
        return new Vector3d((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }

    public static float interpolateRotation(float par1, float par2, float par3) {
        float f = 0.0f;
        for (f = par2 - par1; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return par1 + par3 * f;
    }

    public static float getInterpolatedRotation(float par1, float par2, float par3) {
        float f = 0.0f;
        for (f = par2 - par1; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return par3 * f;
    }

    public static void translateStack(MatrixStack mStack, VisibleMatrix4f mat) {
        Vector3f vector = MathUtils.getTranslationFromMatrix(mat);
        mStack.func_227861_a_((double)vector.func_195899_a(), (double)vector.func_195900_b(), (double)vector.func_195902_c());
    }

    public static void rotateStack(MatrixStack mStack, VisibleMatrix4f mat) {
        mStack.func_227863_a_(MathUtils.getQuaternionFromMatrix(mat));
    }

    public static void scaleStack(MatrixStack mStack, VisibleMatrix4f mat) {
        Vector3f vector = MathUtils.getScaleFromMatrix(mat);
        mStack.func_227862_a_(vector.func_195899_a(), vector.func_195900_b(), vector.func_195902_c());
    }

    public static double getAngleBetween(Entity e1, Entity e2) {
        Vector3d a = e1.func_70040_Z();
        Vector3d b = new Vector3d(e2.func_226277_ct_() - e1.func_226277_ct_(), e2.func_226278_cu_() - e1.func_226278_cu_(), e2.func_226281_cx_() - e1.func_226281_cx_()).func_72432_b();
        double cosTheta = a.field_72450_a * b.field_72450_a + a.field_72448_b * b.field_72448_b + a.field_72449_c * b.field_72449_c;
        return Math.acos(cosTheta);
    }

    private static Vector3f getTranslationFromMatrix(VisibleMatrix4f mat) {
        return new Vector3f(mat.m30, mat.m31, mat.m32);
    }

    private static Quaternion getQuaternionFromMatrix(VisibleMatrix4f mat) {
        float z;
        float y;
        float x;
        float w;
        float diagonal = mat.m00 + mat.m11 + mat.m22;
        if (diagonal > 0.0f) {
            float w4 = (float)(Math.sqrt(diagonal + 1.0f) * 2.0);
            w = w4 * 0.25f;
            x = (mat.m21 - mat.m12) / w4;
            y = (mat.m02 - mat.m20) / w4;
            z = (mat.m10 - mat.m01) / w4;
        } else if (mat.m00 > mat.m11 && mat.m00 > mat.m22) {
            float x4 = (float)(Math.sqrt(1.0f + mat.m00 - mat.m11 - mat.m22) * 2.0);
            w = (mat.m21 - mat.m12) / x4;
            x = x4 * 0.25f;
            y = (mat.m01 + mat.m10) / x4;
            z = (mat.m02 + mat.m20) / x4;
        } else if (mat.m11 > mat.m22) {
            float y4 = (float)(Math.sqrt(1.0f + mat.m11 - mat.m00 - mat.m22) * 2.0);
            w = (mat.m02 - mat.m20) / y4;
            x = (mat.m01 + mat.m10) / y4;
            y = y4 * 0.25f;
            z = (mat.m12 + mat.m21) / y4;
        } else {
            float z4 = (float)(Math.sqrt(1.0f + mat.m22 - mat.m00 - mat.m11) * 2.0);
            w = (mat.m10 - mat.m01) / z4;
            x = (mat.m02 + mat.m20) / z4;
            y = (mat.m12 + mat.m21) / z4;
            z = z4 * 0.25f;
        }
        Quaternion quat = new Quaternion(x, y, z, w);
        quat.func_227067_f_();
        return quat;
    }

    private static Vector3f getScaleFromMatrix(VisibleMatrix4f mat) {
        Vec3f a = new Vec3f(mat.m00, mat.m10, mat.m20);
        Vec3f b = new Vec3f(mat.m01, mat.m11, mat.m21);
        Vec3f c = new Vec3f(mat.m02, mat.m12, mat.m22);
        return new Vector3f(a.length(), b.length(), c.length());
    }
}

