/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.world;

import maninhouse.epicfight.capabilities.ModCapabilities;
import maninhouse.epicfight.capabilities.entity.player.ServerPlayerData;
import maninhouse.epicfight.entity.ai.attribute.ModAttributes;
import maninhouse.epicfight.network.ModNetworkManager;
import maninhouse.epicfight.network.server.STCGameruleChange;
import maninhouse.epicfight.utils.math.Formulars;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.world.GameRules;

public class ModGamerules {
    public static GameRules.RuleKey<GameRules.BooleanValue> DO_VANILLA_ATTACK;
    public static GameRules.RuleKey<GameRules.BooleanValue> HAS_FALL_ANIMATION;
    public static GameRules.RuleKey<GameRules.IntegerValue> SPEED_PENALTY_PERCENT;

    public static void registerRules() {
        DO_VANILLA_ATTACK = GameRules.func_234903_a_((String)"doVanillaAttack", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.RuleType)GameRules.BooleanValue.func_223568_b((boolean)true));
        HAS_FALL_ANIMATION = GameRules.func_234903_a_((String)"hasFallAnimation", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.RuleType)GameRules.BooleanValue.func_223567_b((boolean)true, (server, value) -> ModNetworkManager.sendToAll(new STCGameruleChange(STCGameruleChange.Gamerules.HAS_FALL_ANIMATION, value.func_223572_a()))));
        SPEED_PENALTY_PERCENT = GameRules.func_234903_a_((String)"speedPenaltyPercent", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.RuleType)GameRules.IntegerValue.func_223564_a((int)100, (server, value) -> {
            for (ServerPlayerEntity player : server.func_184103_al().func_181057_v()) {
                ServerPlayerData playerdata = (ServerPlayerData)player.getCapability(ModCapabilities.CAPABILITY_ENTITY).orElse(null);
                if (playerdata == null) continue;
                ModifiableAttributeInstance mainhandAttackSpeed = playerdata.getOriginalEntity().func_110148_a(Attributes.field_233825_h_);
                ModifiableAttributeInstance offhandAttackSpeed = playerdata.getOriginalEntity().func_110148_a((Attribute)ModAttributes.OFFHAND_ATTACK_SPEED.get());
                mainhandAttackSpeed.func_188479_b(ServerPlayerData.WEIGHT_PENALTY_MODIFIIER);
                float mainWeaponSpeed = (float)mainhandAttackSpeed.func_111125_b();
                for (AttributeModifier attributeModifier : playerdata.getOriginalEntity().func_184614_ca().func_111283_C(EquipmentSlotType.MAINHAND).get((Object)Attributes.field_233825_h_)) {
                    mainWeaponSpeed += (float)attributeModifier.func_111164_d();
                }
                mainhandAttackSpeed.func_233767_b_(new AttributeModifier(ServerPlayerData.WEIGHT_PENALTY_MODIFIIER, "weight penalty modifier", Formulars.getAttackSpeedPenalty(playerdata.getWeight(), mainWeaponSpeed, playerdata), AttributeModifier.Operation.ADDITION));
                offhandAttackSpeed.func_188479_b(ServerPlayerData.WEIGHT_PENALTY_MODIFIIER);
                float offWeaponSpeed = (float)offhandAttackSpeed.func_111125_b();
                for (AttributeModifier attributeModifier : playerdata.getOriginalEntity().func_184592_cb().func_111283_C(EquipmentSlotType.MAINHAND).get((Object)Attributes.field_233825_h_)) {
                    offWeaponSpeed += (float)attributeModifier.func_111164_d();
                }
                offhandAttackSpeed.func_233767_b_(new AttributeModifier(ServerPlayerData.WEIGHT_PENALTY_MODIFIIER, "weight penalty modifier", Formulars.getAttackSpeedPenalty(playerdata.getWeight(), offWeaponSpeed, playerdata), AttributeModifier.Operation.ADDITION));
            }
            ModNetworkManager.sendToAll(new STCGameruleChange(STCGameruleChange.Gamerules.SPEED_PENALTY_PERCENT, value.func_223560_a()));
        }));
    }
}

