/*
 * Decompiled with CFR 0.152.
 */
package snownee.everpotion;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.CommandSource;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import snownee.everpotion.EverCommand;
import snownee.everpotion.EverCommonConfig;
import snownee.everpotion.cap.EverCapabilities;
import snownee.everpotion.cap.EverCapabilityProvider;
import snownee.everpotion.client.ClientHandler;
import snownee.everpotion.client.gui.PlaceScreen;
import snownee.everpotion.container.PlaceContainer;
import snownee.everpotion.data.EverAnvilRecipeProvider;
import snownee.everpotion.entity.EverArrowEntity;
import snownee.everpotion.handler.EverHandler;
import snownee.everpotion.item.CoreItem;
import snownee.everpotion.item.UnlockSlotItem;
import snownee.everpotion.network.CDrinkPacket;
import snownee.everpotion.network.COpenContainerPacket;
import snownee.everpotion.network.SCancelPacket;
import snownee.everpotion.network.SSyncPotionsPacket;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.network.NetworkChannel;
import snownee.kiwi.network.Packet;
import snownee.kiwi.schedule.Scheduler;
import snownee.kiwi.schedule.Task;
import snownee.kiwi.schedule.impl.SimpleGlobalTask;

@KiwiModule
@KiwiModule.Subscriber
@KiwiModule.Group(value="brewing")
public class CoreModule
extends AbstractModule {
    public static final CoreItem CORE = new CoreItem();
    public static final UnlockSlotItem UNLOCK_SLOT = new UnlockSlotItem();
    public static final EntityType<EverArrowEntity> ARROW = EntityType.Builder.func_220322_a(EverArrowEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).func_233606_a_(4).func_233608_b_(20).func_206830_a("arrow");
    public static final ContainerType<PlaceContainer> MAIN = new ContainerType(PlaceContainer::new);
    public static final ResourceLocation HANDLER_ID = new ResourceLocation("everpotion", "handler");

    public CoreModule() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        if (FMLEnvironment.dist.isClient()) {
            eventBus.addListener(ClientHandler::onItemColorsInit);
        }
        eventBus.addListener(this::gatherData);
    }

    protected void preInit() {
        NetworkChannel.register(CDrinkPacket.class, (Packet.PacketHandler)new CDrinkPacket.Handler());
        NetworkChannel.register(COpenContainerPacket.class, (Packet.PacketHandler)new COpenContainerPacket.Handler());
        NetworkChannel.register(SSyncPotionsPacket.class, (Packet.PacketHandler)new SSyncPotionsPacket.Handler());
        NetworkChannel.register(SCancelPacket.class, (Packet.PacketHandler)new SCancelPacket.Handler());
    }

    protected void init(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(EverHandler.class, (Capability.IStorage)new Capability.IStorage<EverHandler>(){

            public INBT writeNBT(Capability<EverHandler> capability, EverHandler instance, Direction side) {
                return new CompoundNBT();
            }

            public void readNBT(Capability<EverHandler> capability, EverHandler instance, Direction side, INBT nbt) {
            }
        }, EverHandler::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void clientInit(FMLClientSetupEvent event) {
        ClientRegistry.registerKeyBinding((KeyBinding)ClientHandler.kbUse);
        ScreenManager.func_216911_a(MAIN, PlaceScreen::new);
        MinecraftForge.EVENT_BUS.addListener(ClientHandler::renderOverlay);
        MinecraftForge.EVENT_BUS.addListener(ClientHandler::onKeyInput);
        ItemModelsProperties.func_239418_a_((Item)CORE, (ResourceLocation)new ResourceLocation("type"), (stack, world, entity) -> CoreItem.getPotionType(stack).ordinal());
        EntityRendererManager manager = Minecraft.func_71410_x().func_175598_ae();
        manager.field_78729_o.put(ARROW, manager.field_78729_o.get(EntityType.field_200790_d));
    }

    @SubscribeEvent
    protected void onCommandsRegister(RegisterCommandsEvent event) {
        LiteralArgumentBuilder<CommandSource> builder = EverCommand.init((CommandDispatcher<CommandSource>)event.getDispatcher());
        event.getDispatcher().register(builder);
    }

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity && !(event.getObject() instanceof FakePlayer)) {
            event.addCapability(HANDLER_ID, (ICapabilityProvider)new EverCapabilityProvider(new EverHandler((PlayerEntity)event.getObject())));
        }
    }

    @SubscribeEvent
    protected void onPlayerJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (entity instanceof ServerPlayerEntity && !(entity instanceof FakePlayer)) {
            Scheduler.add((Task)new SimpleGlobalTask(LogicalSide.SERVER, TickEvent.Phase.END, t -> {
                if (t >= 5) {
                    CoreModule.sync((ServerPlayerEntity)entity);
                    return true;
                }
                return false;
            }));
        }
    }

    public static void sync(ServerPlayerEntity player) {
        if (player instanceof FakePlayer) {
            return;
        }
        new SSyncPotionsPacket(player).send();
    }

    @SubscribeEvent
    public void tickPlayer(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        event.player.getCapability(EverCapabilities.HANDLER).ifPresent(EverHandler::tick);
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (!(event.getSource() instanceof EntityDamageSource)) {
            return;
        }
        LivingEntity living = event.getEntityLiving();
        living.getCapability(EverCapabilities.HANDLER).ifPresent(handler -> {
            handler.stopDrinking();
            if (living instanceof ServerPlayerEntity) {
                new SCancelPacket().send((ServerPlayerEntity)living);
            }
        });
        Entity source = event.getSource().func_76346_g();
        if (source instanceof ServerPlayerEntity && EverCommonConfig.damageAcceleration > 0.0) {
            source.getCapability(EverCapabilities.HANDLER).ifPresent(handler -> {
                handler.accelerate(0.05f * event.getAmount() * (float)EverCommonConfig.damageAcceleration);
                if (source.field_70170_p.field_73012_v.nextBoolean()) {
                    CoreModule.sync((ServerPlayerEntity)source);
                }
            });
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        EverHandler newHandler = (EverHandler)((Object)event.getPlayer().getCapability(EverCapabilities.HANDLER).orElse(null));
        EverHandler oldHandler = (EverHandler)((Object)event.getOriginal().getCapability(EverCapabilities.HANDLER).orElse(null));
        if (newHandler != null && oldHandler != null) {
            newHandler.copyFrom(oldHandler);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void tempLoot(LivingDeathEvent event) {
        if (EverCommonConfig.mobDropUnlockItem == 0.0 || event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        Entity source = event.getSource().func_76346_g();
        if (source instanceof PlayerEntity && event.getEntity() instanceof MobEntity && (double)event.getEntityLiving().func_70681_au().nextFloat() < EverCommonConfig.mobDropUnlockItem) {
            event.getEntityLiving().func_199703_a((IItemProvider)UNLOCK_SLOT);
        }
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        generator.func_200390_a((IDataProvider)new EverAnvilRecipeProvider(generator));
    }
}

