/*
 * Decompiled with CFR 0.152.
 */
package snownee.everpotion.cap;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import snownee.everpotion.cap.EverCapabilities;
import snownee.everpotion.handler.EverHandler;

public class EverCapabilityProvider
implements ICapabilityProvider,
INBTSerializable<CompoundNBT> {
    private final LazyOptional<EverHandler> handler = LazyOptional.of(() -> handler);

    public EverCapabilityProvider(EverHandler handler) {
        this.handler.addListener($ -> $.ifPresent(EverHandler::invalidate));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return EverCapabilities.HANDLER.orEmpty(cap, this.handler);
    }

    public CompoundNBT serializeNBT() {
        return this.handler.map($ -> $.serializeNBT()).orElseGet(CompoundNBT::new);
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.handler.ifPresent($ -> $.deserializeNBT(nbt));
    }
}

