/*
 * Decompiled with CFR 0.152.
 */
package snownee.everpotion.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.PotionSpriteUploader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.settings.KeyModifier;
import snownee.everpotion.EverCommonConfig;
import snownee.everpotion.PotionType;
import snownee.everpotion.cap.EverCapabilities;
import snownee.everpotion.client.ClientHandler;
import snownee.everpotion.handler.EverHandler;

public class UseScreen
extends Screen {
    private static final ITextComponent TITLE = new TranslationTextComponent("gui.everpotion.use.title");
    private EverHandler handler;
    private final float[] scales = new float[4];
    private final String[] names = new String[4];
    private boolean closing;
    private float openTick;
    private int clickIndex = -1;
    private float drinkTick;
    private KeyBinding[] keyBindsHotbar;

    public UseScreen() {
        super(TITLE);
    }

    protected void func_231160_c_() {
        if (this.field_230706_i_.field_71439_g == null) {
            return;
        }
        this.handler = (EverHandler)((Object)this.field_230706_i_.field_71439_g.getCapability(EverCapabilities.HANDLER).orElse(null));
        this.keyBindsHotbar = this.field_230706_i_.field_71474_y.field_151456_ac;
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float pTicks) {
        if (this.handler == null) {
            return;
        }
        this.openTick += this.closing ? -pTicks * 0.4f : pTicks * 0.2f;
        if (this.closing && this.openTick <= 0.0f) {
            Minecraft.func_71410_x().func_147108_a(null);
            return;
        }
        this.openTick = MathHelper.func_76131_a((float)this.openTick, (float)0.0f, (float)1.0f);
        float xCenter = (float)this.field_230708_k_ / 2.0f;
        float yCenter = (float)this.field_230709_l_ / 2.0f;
        if (EverCommonConfig.maxSlots == 3) {
            yCenter += 20.0f;
        }
        if (!this.closing && (this.drinkTick > 0.0f || this.handler.drinkIndex != -1)) {
            this.drinkTick += pTicks;
            if (this.drinkTick > (float)EverCommonConfig.drinkDelay) {
                this.func_231175_as__();
            }
        }
        float offset = 35.0f + this.openTick * 25.0f;
        if (EverCommonConfig.maxSlots == 1) {
            this.drawButton(matrix, xCenter, yCenter, mouseX, mouseY, 0, pTicks);
        } else if (EverCommonConfig.maxSlots == 2) {
            this.drawButton(matrix, xCenter - offset, yCenter, mouseX, mouseY, 0, pTicks);
            this.drawButton(matrix, xCenter + offset, yCenter, mouseX, mouseY, 1, pTicks);
        } else if (EverCommonConfig.maxSlots == 3) {
            this.drawButton(matrix, xCenter - offset, yCenter, mouseX, mouseY, 0, pTicks);
            this.drawButton(matrix, xCenter, yCenter - offset, mouseX, mouseY, 1, pTicks);
            this.drawButton(matrix, xCenter + offset, yCenter, mouseX, mouseY, 2, pTicks);
        } else if (EverCommonConfig.maxSlots == 4) {
            this.drawButton(matrix, xCenter - offset, yCenter, mouseX, mouseY, 0, pTicks);
            this.drawButton(matrix, xCenter, yCenter - offset, mouseX, mouseY, 1, pTicks);
            this.drawButton(matrix, xCenter + offset, yCenter, mouseX, mouseY, 2, pTicks);
            this.drawButton(matrix, xCenter, yCenter + offset, mouseX, mouseY, 3, pTicks);
        }
        if (this.clickIndex < 0) {
            int range = EverCommonConfig.maxSlots == 1 ? 60 : 120;
            boolean out = Math.abs((float)mouseX - xCenter) + Math.abs((float)mouseY - yCenter) > (float)range;
            this.clickIndex = out ? -2 : -1;
        }
        RenderSystem.disableBlend();
        super.func_230430_a_(matrix, mouseX, mouseY, pTicks);
    }

    private void drawButton(MatrixStack matrix, float xCenter, float yCenter, int mouseX, int mouseY, int index, float pTicks) {
        float hdshadow;
        float b;
        float g;
        float r;
        EverHandler.Cache cache = this.handler.caches[index];
        float a = 0.5f * this.openTick;
        float hd = 40.0f;
        boolean hover = !this.closing && cache != null && this.openTick == 1.0f && Math.abs((float)mouseX - xCenter) + Math.abs((float)mouseY - yCenter) < hd + 10.0f;
        boolean bl = hover = hover && (this.handler.drinkIndex == index || this.handler.drinkIndex == -1);
        if (hover) {
            this.clickIndex = index;
        } else if (this.clickIndex == index) {
            this.clickIndex = -1;
        }
        int n = index;
        this.scales[n] = this.scales[n] + (hover ? pTicks : -pTicks) * 0.5f;
        this.scales[index] = MathHelper.func_76131_a((float)this.scales[index], (float)0.0f, (float)1.0f);
        hd += this.scales[index] * 5.0f;
        if (hover) {
            int color = cache.color;
            r = Math.max(0.1f, (float)(color >> 16 & 0xFF) / 255.0f * 0.2f * this.scales[index]);
            g = Math.max(0.1f, (float)(color >> 8 & 0xFF) / 255.0f * 0.2f * this.scales[index]);
            b = Math.max(0.1f, (float)(color & 0xFF) / 255.0f * 0.2f * this.scales[index]);
        } else {
            r = 0.1f;
            g = 0.1f;
            b = 0.1f;
        }
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableTexture();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_227888_a_(matrix4f, xCenter - hd, yCenter, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(matrix4f, xCenter, yCenter + hd, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(matrix4f, xCenter + hd, yCenter, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(matrix4f, xCenter, yCenter - hd, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
        a = 0.75f * this.openTick;
        if (hover || this.handler.tipIndex == index) {
            int color = cache.color;
            float scale = this.scales[index];
            if (this.handler.tipIndex == index) {
                scale = Math.max(scale, 0.75f);
            }
            r = Math.max(0.1f, (float)(color >> 16 & 0xFF) / 255.0f * scale);
            g = Math.max(0.1f, (float)(color >> 8 & 0xFF) / 255.0f * scale);
            b = Math.max(0.1f, (float)(color & 0xFF) / 255.0f * scale);
        }
        float hdborder = hd + 3.0f;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_227888_a_(matrix4f, xCenter, yCenter - hd, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(matrix4f, xCenter + hd, yCenter, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(matrix4f, xCenter + hdborder, yCenter, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(matrix4f, xCenter, yCenter - hdborder, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_227888_a_(matrix4f, xCenter, yCenter + hdborder, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(matrix4f, xCenter + hdborder, yCenter, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(matrix4f, xCenter + hd, yCenter, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(matrix4f, xCenter, yCenter + hd, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_227888_a_(matrix4f, xCenter, yCenter + hd, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(matrix4f, xCenter - hd, yCenter, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(matrix4f, xCenter - hdborder, yCenter, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(matrix4f, xCenter, yCenter + hdborder, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_227888_a_(matrix4f, xCenter, yCenter - hdborder, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(matrix4f, xCenter - hdborder, yCenter, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(matrix4f, xCenter - hd, yCenter, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(matrix4f, xCenter, yCenter - hd, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
        if (this.handler.drinkIndex == index) {
            float h = hd * 2.0f * this.drinkTick / (float)EverCommonConfig.drinkDelay - hd;
            float ia = 0.2f;
            buffer.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            buffer.func_227888_a_(matrix4f, xCenter - hd + Math.abs(h), yCenter - h, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, ia).func_181675_d();
            if (h > 0.0f) {
                buffer.func_227888_a_(matrix4f, xCenter - hd, yCenter, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, ia).func_181675_d();
            }
            buffer.func_227888_a_(matrix4f, xCenter, yCenter + hd, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, ia).func_181675_d();
            if (h > 0.0f) {
                buffer.func_227888_a_(matrix4f, xCenter + hd, yCenter, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, ia).func_181675_d();
            }
            buffer.func_227888_a_(matrix4f, xCenter + hd - Math.abs(h), yCenter - h, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, ia).func_181675_d();
            tessellator.func_78381_a();
        }
        if (hover) {
            a = 0.3f * this.openTick;
            hdshadow = hdborder + 6.0f;
        } else {
            a = 0.2f * this.openTick;
            hdshadow = hdborder + 5.0f;
        }
        r = 0.1f;
        g = 0.1f;
        b = 0.1f;
        RenderSystem.disableAlphaTest();
        RenderSystem.shadeModel((int)7425);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_227888_a_(matrix4f, xCenter, yCenter - hdborder, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(matrix4f, xCenter + hdborder, yCenter, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(matrix4f, xCenter + hdshadow, yCenter, 0.0f).func_227885_a_(r, g, b, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix4f, xCenter, yCenter - hdshadow, 0.0f).func_227885_a_(r, g, b, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_227888_a_(matrix4f, xCenter, yCenter + hdshadow, 0.0f).func_227885_a_(r, g, b, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix4f, xCenter + hdshadow, yCenter, 0.0f).func_227885_a_(r, g, b, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix4f, xCenter + hdborder, yCenter, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(matrix4f, xCenter, yCenter + hdborder, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_227888_a_(matrix4f, xCenter, yCenter + hdborder, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(matrix4f, xCenter - hdborder, yCenter, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(matrix4f, xCenter - hdshadow, yCenter, 0.0f).func_227885_a_(r, g, b, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix4f, xCenter, yCenter + hdshadow, 0.0f).func_227885_a_(r, g, b, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_227888_a_(matrix4f, xCenter, yCenter - hdshadow, 0.0f).func_227885_a_(r, g, b, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix4f, xCenter - hdshadow, yCenter, 0.0f).func_227885_a_(r, g, b, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix4f, xCenter - hdborder, yCenter, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(matrix4f, xCenter, yCenter - hdborder, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
        this.refreshName(index);
        matrix.func_227860_a_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.openTick);
        int textAlpha = (int)(this.openTick * 255.0f);
        int textColor = textAlpha << 24 | 0xFFFFFF;
        String name = hover && cache.type != PotionType.NORMAL ? I18n.func_135052_a((String)cache.type.getDescKey(), (Object[])new Object[0]) : this.names[index];
        if (cache != null && cache.progress < (float)EverCommonConfig.refillTime) {
            float percent = 100.0f * cache.progress / (float)EverCommonConfig.refillTime;
            name = (int)percent + "%";
        }
        if (cache == null) {
            matrix.func_227861_a_((double)xCenter, (double)(yCenter - 3.0f), 0.0);
            matrix.func_227862_a_(0.75f, 0.75f, 0.75f);
            UseScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)name, (int)0, (int)0, (int)textColor);
        } else if (cache.effect != null) {
            PotionSpriteUploader potionspriteuploader = this.field_230706_i_.func_213248_ap();
            TextureAtlasSprite sprite = potionspriteuploader.func_215288_a(cache.effect.func_188419_a());
            sprite.func_229241_m_().func_229148_d_();
            float yCenter2 = yCenter - 6.0f * (1.0f + 0.125f * this.scales[index]);
            float halfwidth = 12.0f + 1.5f * this.scales[index];
            float left = xCenter - halfwidth;
            float right = xCenter + halfwidth;
            float top = yCenter2 - halfwidth;
            float bottom = yCenter2 + halfwidth;
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_225582_a_((double)left, (double)bottom, 0.0).func_225583_a_(sprite.func_94209_e(), sprite.func_94210_h()).func_181675_d();
            buffer.func_225582_a_((double)right, (double)bottom, 0.0).func_225583_a_(sprite.func_94212_f(), sprite.func_94210_h()).func_181675_d();
            buffer.func_225582_a_((double)right, (double)top, 0.0).func_225583_a_(sprite.func_94212_f(), sprite.func_94206_g()).func_181675_d();
            buffer.func_225582_a_((double)left, (double)top, 0.0).func_225583_a_(sprite.func_94209_e(), sprite.func_94206_g()).func_181675_d();
            tessellator.func_78381_a();
            matrix.func_227861_a_((double)xCenter, (double)(yCenter + 10.0f), 0.0);
            matrix.func_227862_a_(0.75f, 0.75f, 0.75f);
            UseScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)name, (int)0, (int)0, (int)textColor);
        } else {
            matrix.func_227861_a_((double)xCenter, (double)(yCenter - 3.0f), 0.0);
            matrix.func_227862_a_(0.75f, 0.75f, 0.75f);
            UseScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)name, (int)0, (int)0, (int)textColor);
        }
        matrix.func_227865_b_();
    }

    private void refreshName(int i) {
        if (this.names[i] != null) {
            return;
        }
        EverHandler.Cache cache = this.handler.caches[i];
        if (cache == null) {
            this.names[i] = i < this.handler.getSlots() ? "" : TextFormatting.GRAY + I18n.func_135052_a((String)"msg.everpotion.locked", (Object[])new Object[0]);
        } else if (cache.effect == null) {
            this.names[i] = I18n.func_135052_a((String)"effect.none", (Object[])new Object[0]);
        } else {
            this.names[i] = I18n.func_135052_a((String)cache.effect.func_76453_d(), (Object[])new Object[0]);
            if (cache.effect.func_76458_c() > 0) {
                int n = i;
                this.names[n] = this.names[n] + " " + I18n.func_135052_a((String)("potion.potency." + cache.effect.func_76458_c()), (Object[])new Object[0]);
            }
        }
    }

    public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        if (this.clickIndex == -2) {
            this.func_231175_as__();
            return true;
        }
        if (this.closing || this.clickIndex == -1) {
            return false;
        }
        if (!this.handler.canUseSlot(this.clickIndex, true)) {
            return false;
        }
        this.scales[this.clickIndex] = 0.25f;
        this.handler.startDrinking(this.clickIndex);
        if (this.handler.drinkIndex == -1) {
            this.func_231175_as__();
        }
        return true;
    }

    public boolean func_231046_a_(int key, int scanCode, int modifiers) {
        if (this.closing || this.handler.drinkIndex != -1) {
            return false;
        }
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            if (!this.handler.canUseSlot(i, true) || this.keyBindsHotbar[i].getKey().func_197937_c() != key) continue;
            this.clickIndex = i;
            this.scales[i] = 1.0f;
            this.handler.startDrinking(this.clickIndex);
            if (this.handler.drinkIndex == -1) {
                this.func_231175_as__();
            }
            return true;
        }
        if (ClientHandler.kbUse.getKeyModifier().isActive(null) && ClientHandler.kbUse.getKey().func_197937_c() == key) {
            if (ClientHandler.kbUse.getKeyModifier() == KeyModifier.NONE && modifiers != 0) {
                return false;
            }
            this.func_231175_as__();
            return true;
        }
        return super.func_231046_a_(key, scanCode, modifiers);
    }

    public void func_231175_as__() {
        this.closing = true;
    }

    public boolean func_231177_au__() {
        return false;
    }
}

