/*
 * Decompiled with CFR 0.152.
 */
package snownee.everpotion.crafting;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.ITag;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import snownee.everpotion.crafting.AnvilContext;
import snownee.everpotion.crafting.EverAnvilRecipe;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.Kiwi;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.Name;

@KiwiModule(value="crafting")
@KiwiModule.Optional
@KiwiModule.Subscriber
public class CraftingModule
extends AbstractModule {
    @Name(value="anvil")
    public static final IRecipeType<EverAnvilRecipe> RECIPE_TYPE = new IRecipeType<EverAnvilRecipe>(){};
    @Name(value="anvil")
    public static final EverAnvilRecipe.Serializer SERIALIZER = new EverAnvilRecipe.Serializer();
    public static final ITag.INamedTag<Item> INGREDIENT = CraftingModule.itemTag((String)"everpotion", (String)"ingredient");

    @SubscribeEvent
    public void onAnvilCrafting(AnvilUpdateEvent event) {
        RecipeManager manager = CraftingModule.getRecipeManager();
        if (manager == null) {
            return;
        }
        AnvilContext ctx = new AnvilContext(event);
        Optional result = manager.func_215371_a(RECIPE_TYPE, (IInventory)ctx, null);
        result.ifPresent(recipe -> {
            event.setOutput(recipe.getCraftingResult(ctx));
            event.setCost(ctx.cost);
            event.setMaterialCost(ctx.materialCost);
        });
    }

    @Nullable
    public static RecipeManager getRecipeManager() {
        ClientPlayNetHandler connection;
        MinecraftServer server = Kiwi.getServer();
        if (server != null) {
            return server.func_199529_aN();
        }
        if (FMLEnvironment.dist.isClient() && (connection = Minecraft.func_71410_x().func_147114_u()) != null) {
            return connection.func_199526_e();
        }
        return null;
    }
}

