/*
 * Decompiled with CFR 0.152.
 */
package snownee.everpotion.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import snownee.everpotion.CoreModule;
import snownee.everpotion.EverCommonConfig;
import snownee.everpotion.PotionType;
import snownee.everpotion.crafting.AnvilContext;
import snownee.everpotion.crafting.CraftingModule;
import snownee.everpotion.crafting.ProcessingOutput;
import snownee.everpotion.item.CoreItem;
import snownee.kiwi.crafting.Recipe;
import snownee.kiwi.util.Util;

public class EverAnvilRecipe
extends Recipe<AnvilContext> {
    private final Ingredient left;
    private final Ingredient right;
    private final int cost;
    private final int materialCost;
    private final ProcessingOutput output;

    public EverAnvilRecipe(ResourceLocation id, Ingredient left, Ingredient right, int cost, int materialCost, ItemStack output) {
        super(id);
        this.left = left;
        this.right = right;
        this.cost = cost;
        this.materialCost = materialCost;
        this.output = new ProcessingOutput(output, 1.0f);
    }

    public boolean matches(AnvilContext inv, World worldIn) {
        return this.left.test(inv.left) && this.right.test(inv.right);
    }

    public ItemStack getCraftingResult(AnvilContext inv) {
        inv.cost = this.cost;
        inv.materialCost = this.materialCost;
        return this.func_77571_b();
    }

    public Ingredient getLeft() {
        return this.left;
    }

    public Ingredient getRight() {
        return this.right;
    }

    public ItemStack func_77571_b() {
        return this.output.getStack().func_77946_l();
    }

    public IRecipeSerializer<?> func_199559_b() {
        return CraftingModule.SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return CraftingModule.RECIPE_TYPE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<EverAnvilRecipe> {
        public EverAnvilRecipe read(ResourceLocation recipeId, JsonObject json) {
            ItemStack output;
            Ingredient left = CraftingHelper.getIngredient((JsonElement)json.get("left"));
            Ingredient right = CraftingHelper.getIngredient((JsonElement)json.get("right"));
            int cost = JSONUtils.func_151208_a((JsonObject)json, (String)"cost", (int)0);
            int materialCost = JSONUtils.func_151208_a((JsonObject)json, (String)"materialCost", (int)1);
            JsonObject outputObj = JSONUtils.func_152754_s((JsonObject)json, (String)"output");
            if (outputObj.has("effect")) {
                Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)outputObj, (String)"effect")));
                int duration = JSONUtils.func_151208_a((JsonObject)outputObj, (String)"duration", (int)0) * 20;
                int amplifier = JSONUtils.func_151208_a((JsonObject)outputObj, (String)"amplifier", (int)0);
                EffectInstance effectInstance = null;
                if (effect != null) {
                    effectInstance = new EffectInstance(effect, duration, amplifier, EverCommonConfig.ambient, EverCommonConfig.showParticles, EverCommonConfig.showIcon);
                }
                PotionType type = PotionType.parse(JSONUtils.func_151219_a((JsonObject)outputObj, (String)"type", (String)"normal"));
                float charge = JSONUtils.func_151221_a((JsonObject)outputObj, (String)"charge", (float)1.0f);
                output = CoreModule.CORE.make(effectInstance, type, charge);
            } else {
                output = CraftingHelper.getItemStack((JsonObject)outputObj, (boolean)true);
            }
            return new EverAnvilRecipe(recipeId, left, right, cost, materialCost, output);
        }

        public void write(JsonObject json, EverAnvilRecipe recipe) {
            ItemStack output;
            json.add("left", recipe.left.func_200304_c());
            json.add("right", recipe.right.func_200304_c());
            if (recipe.cost != 0) {
                json.addProperty("cost", (Number)recipe.cost);
            }
            if (recipe.materialCost != 1) {
                json.addProperty("materialCost", (Number)recipe.materialCost);
            }
            if ((output = recipe.output.getStack()).func_77973_b() == CoreModule.CORE) {
                JsonObject o = new JsonObject();
                EffectInstance effect = CoreItem.getEffectInstance(output);
                PotionType type = CoreItem.getPotionType(output);
                float charge = CoreItem.getChargeModifier(output);
                if (effect == null) {
                    o.addProperty("effect", "none");
                } else {
                    o.addProperty("effect", Util.trimRL((ResourceLocation)effect.func_188419_a().getRegistryName()));
                    if (effect.func_76458_c() > 0) {
                        o.addProperty("amplifier", (Number)effect.func_76458_c());
                    }
                    if (!effect.func_188419_a().func_76403_b()) {
                        o.addProperty("duration", (Number)(effect.func_76459_b() / 100));
                    }
                }
                o.addProperty("type", type.toString());
                if (charge != 1.0f) {
                    o.addProperty("charge", (Number)Float.valueOf(charge));
                }
                json.add("output", (JsonElement)o);
            } else {
                json.add("output", recipe.output.serialize());
            }
        }

        public EverAnvilRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient left = Ingredient.func_199566_b((PacketBuffer)buffer);
            Ingredient right = Ingredient.func_199566_b((PacketBuffer)buffer);
            int cost = buffer.func_150792_a();
            int materialCost = buffer.func_150792_a();
            ItemStack output = buffer.func_150791_c();
            return new EverAnvilRecipe(recipeId, left, right, cost, materialCost, output);
        }

        public void write(PacketBuffer buffer, EverAnvilRecipe recipe) {
            recipe.left.func_199564_a(buffer);
            recipe.right.func_199564_a(buffer);
            buffer.func_150787_b(recipe.cost);
            buffer.func_150787_b(recipe.materialCost);
            buffer.func_150788_a(recipe.func_77571_b());
        }
    }
}

