/*
 * Decompiled with CFR 0.152.
 */
package snownee.everpotion.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import snownee.everpotion.CoreModule;
import snownee.everpotion.PotionType;
import snownee.everpotion.crafting.CraftingModule;
import snownee.everpotion.crafting.EverAnvilRecipe;
import snownee.kiwi.util.Util;

public class EverAnvilRecipeBuilder
implements IFinishedRecipe {
    private Ingredient left;
    private Ingredient right;
    private int cost;
    private int materialCost = 1;
    private final ItemStack output;
    private ResourceLocation id;
    protected List<ICondition> conditions = new ArrayList<ICondition>();

    public EverAnvilRecipeBuilder(ItemStack output) {
        this.output = output;
    }

    public static EverAnvilRecipeBuilder recipe(ItemStack output) {
        return new EverAnvilRecipeBuilder(output);
    }

    public static EverAnvilRecipeBuilder coreRecipe(@Nullable EffectInstance effect, PotionType type, float charge) {
        String save;
        if (effect == null) {
            save = "water";
        } else {
            save = Util.trimRL((ResourceLocation)effect.func_188419_a().getRegistryName()).replace(':', '/');
            if (type == PotionType.SPLASH) {
                save = save + "_s";
            } else if (type == PotionType.LINGERING) {
                save = save + "_l";
            }
        }
        return EverAnvilRecipeBuilder.recipe(CoreModule.CORE.make(effect, type, charge)).save(new ResourceLocation("everpotion", save));
    }

    public EverAnvilRecipeBuilder save(ResourceLocation save) {
        this.id = save;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumerIn) {
        if (this.id == null) {
            ResourceLocation reg = this.output.func_77973_b().getRegistryName();
            this.id = new ResourceLocation(reg.func_110624_b(), this.getSerializer().getRegistryName().func_110623_a() + "/" + reg.func_110623_a());
        }
        this.validate(this.id);
        consumerIn.accept(this);
    }

    private void validate(ResourceLocation id) {
        if (this.left == null) {
            throw new IllegalStateException("Recipe " + id + " : input can't be null");
        }
    }

    public EverAnvilRecipeBuilder levelCost(int cost) {
        this.cost = cost;
        return this;
    }

    public EverAnvilRecipeBuilder materialCost(int materialCost) {
        this.materialCost = materialCost;
        return this;
    }

    public EverAnvilRecipeBuilder left(Ingredient left) {
        this.left = left;
        return this;
    }

    public EverAnvilRecipeBuilder right(Ingredient right) {
        this.right = right;
        return this;
    }

    public EverAnvilRecipeBuilder whenModLoaded(String modid) {
        return this.withCondition((ICondition)new ModLoadedCondition(modid));
    }

    public EverAnvilRecipeBuilder withCondition(ICondition condition) {
        this.conditions.add(condition);
        return this;
    }

    public void func_218610_a(JsonObject json) {
        EverAnvilRecipe recipe = new EverAnvilRecipe(this.id, this.left, this.right, this.cost, this.materialCost, this.output);
        this.getSerializer().write(json, recipe);
        if (this.conditions.isEmpty()) {
            return;
        }
        JsonArray conds = new JsonArray();
        this.conditions.forEach(c -> conds.add((JsonElement)CraftingHelper.serialize((ICondition)c)));
        json.add("conditions", (JsonElement)conds);
    }

    public EverAnvilRecipe.Serializer getSerializer() {
        return CraftingModule.SERIALIZER;
    }

    public ResourceLocation func_200442_b() {
        return this.id;
    }

    @Nullable
    public JsonObject func_200440_c() {
        return null;
    }

    @Nullable
    public ResourceLocation func_200443_d() {
        return null;
    }
}

