/*
 * Decompiled with CFR 0.152.
 */
package snownee.everpotion.data;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.crafting.NBTIngredient;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import snownee.everpotion.PotionType;
import snownee.everpotion.crafting.CraftingModule;
import snownee.everpotion.data.EverAnvilRecipeBuilder;

public class EverAnvilRecipeProvider
extends RecipeProvider {
    private static final Ingredient RIGHT = Ingredient.func_199805_a(CraftingModule.INGREDIENT);

    public EverAnvilRecipeProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public String func_200397_b() {
        return "EverPotion Recipes";
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        this.register(Potions.field_185230_b, null, PotionType.SPLASH, 2.0f, consumer);
        HashMap effects = Maps.newHashMap();
        for (Potion potion : ForgeRegistries.POTION_TYPES) {
            Pair exist;
            EffectInstance effect;
            if (potion.func_185170_a().size() != 1 || !EverAnvilRecipeProvider.accept(effect = (EffectInstance)potion.func_185170_a().get(0)) || !effect.func_188419_a().getRegistryName().func_110624_b().equals("minecraft") || (exist = (Pair)effects.get(effect.func_188419_a())) != null && ((EffectInstance)exist.getLeft()).func_76459_b() > effect.func_76459_b()) continue;
            effects.put(effect.func_188419_a(), Pair.of((Object)effect, (Object)potion));
        }
        effects.put(Effects.field_76429_m, Pair.of((Object)new EffectInstance(Effects.field_76429_m, 6000), (Object)Potions.field_203186_u));
        for (Pair pair : effects.values()) {
            for (PotionType type : PotionType.values()) {
                this.register((Potion)pair.getRight(), (EffectInstance)pair.getLeft(), type, EverAnvilRecipeProvider.getCharge(((EffectInstance)pair.getLeft()).func_188419_a()), consumer);
            }
        }
    }

    private static boolean accept(EffectInstance effect) {
        int amplifier = effect.func_76458_c();
        Effect potion = effect.func_188419_a();
        if (potion == Effects.field_76430_j || potion == Effects.field_76424_c) {
            return amplifier == 1;
        }
        return amplifier == 0;
    }

    private static float getCharge(Effect effect) {
        if (effect == Effects.field_76432_h) {
            return 0.9f;
        }
        if (effect == Effects.field_76439_r || effect == Effects.field_76441_p) {
            return 0.8f;
        }
        return 1.0f;
    }

    private void register(Potion potion, @Nullable EffectInstance effect, PotionType type, float charge, Consumer<IFinishedRecipe> consumer) {
        AccessIt left = new AccessIt(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)type.potionItem), (Potion)potion));
        EverAnvilRecipeBuilder.coreRecipe(effect, type, charge).left((Ingredient)left).right(RIGHT).levelCost(type.level).build(consumer);
    }

    private static class AccessIt
    extends NBTIngredient {
        private AccessIt(ItemStack stack) {
            super(stack);
        }

        public JsonElement func_200304_c() {
            JsonObject json = (JsonObject)super.func_200304_c();
            if (json.get("count").getAsInt() == 1) {
                json.remove("count");
            }
            return json;
        }
    }
}

