/*
 * Decompiled with CFR 0.152.
 */
package snownee.everpotion.handler;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.CampfireBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;
import snownee.everpotion.CoreModule;
import snownee.everpotion.EverCommonConfig;
import snownee.everpotion.PotionType;
import snownee.everpotion.entity.EverArrowEntity;
import snownee.everpotion.item.CoreItem;
import snownee.everpotion.network.CDrinkPacket;
import snownee.kiwi.util.MathUtil;
import snownee.kiwi.util.NBTHelper;

public class EverHandler
extends ItemStackHandler {
    private PlayerEntity owner;
    private int slots;
    public final Cache[] caches = new Cache[4];
    public int chargeIndex = -1;
    public int drinkIndex = -1;
    public int tipIndex = -1;
    public int drinkTick;
    public float acceleration;

    public EverHandler() {
        this(null);
    }

    public EverHandler(PlayerEntity owner) {
        super(4);
        this.owner = owner;
    }

    public int getSlots() {
        return this.slots;
    }

    protected void onContentsChanged(int slot) {
        ItemStack stack = this.getStackInSlot(slot);
        if (stack.func_77973_b() == CoreModule.CORE) {
            if (this.caches[slot] != null && this.caches[slot].matches(stack)) {
                return;
            }
            this.caches[slot] = new Cache(stack);
        } else {
            this.caches[slot] = null;
        }
        if (this.chargeIndex == -1 || slot == this.chargeIndex) {
            this.updateCharge();
        }
        if (slot == this.tipIndex) {
            this.tipIndex = -1;
        }
    }

    private void updateCharge() {
        for (int i = 0; i < this.slots; ++i) {
            if (this.caches[i] == null || !(this.caches[i].progress < (float)EverCommonConfig.refillTime)) continue;
            this.chargeIndex = i;
            return;
        }
        this.chargeIndex = -1;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = super.serializeNBT();
        tag.func_74768_a("Slots", this.slots);
        for (int i = 0; i < this.caches.length; ++i) {
            if (this.caches[i] == null) continue;
            tag.func_74776_a("Progress" + i, this.caches[i].progress);
        }
        tag.func_74768_a("Tip", this.tipIndex);
        return tag;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        int i;
        NBTHelper data = NBTHelper.of((CompoundNBT)nbt);
        this.slots = data.getInt("Slots", EverCommonConfig.beginnerSlots);
        super.deserializeNBT(nbt);
        for (i = 0; i < this.slots; ++i) {
            this.onContentsChanged(i);
        }
        for (i = 0; i < this.caches.length; ++i) {
            if (this.caches[i] == null) continue;
            this.caches[i].progress = data.getFloat("Progress" + i);
        }
        this.tipIndex = data.getInt("Tip", -1);
    }

    public void setSlots(int slots) {
        this.slots = slots;
        this.drinkIndex = -1;
        this.tipIndex = -1;
        this.updateCharge();
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (stack.func_77973_b() != CoreModule.CORE || slot >= this.slots) {
            return false;
        }
        Effect effect = CoreItem.getEffect(stack);
        for (ItemStack stackIn : this.stacks) {
            if (stackIn.func_190926_b() || stackIn.func_77973_b() != CoreModule.CORE || CoreItem.getEffect(stackIn) != effect) continue;
            return false;
        }
        return true;
    }

    public void copyFrom(EverHandler that) {
        this.slots = that.slots;
        this.stacks = that.stacks;
        for (int i = 0; i < this.caches.length; ++i) {
            this.onContentsChanged(i);
            if (this.caches[i] == null || that.caches[i] == null) continue;
            this.caches[i].progress = that.caches[i].progress;
        }
        this.chargeIndex = that.chargeIndex;
        this.tipIndex = that.tipIndex;
        this.acceleration = that.acceleration;
    }

    public void tick() {
        Cache cache;
        this.acceleration = Math.max(0.0f, this.acceleration - 0.005f);
        if (this.chargeIndex != -1) {
            cache = this.caches[this.chargeIndex];
            if (cache == null) {
                this.updateCharge();
                return;
            }
            cache.progress = MathHelper.func_76131_a((float)(cache.progress + cache.speed * this.acceleration), (float)0.0f, (float)EverCommonConfig.refillTime);
            if (EverCommonConfig.naturallyRefill) {
                cache.progress = MathHelper.func_76131_a((float)(cache.progress + cache.speed), (float)0.0f, (float)EverCommonConfig.refillTime);
            }
            if (cache.progress == (float)EverCommonConfig.refillTime) {
                this.updateCharge();
                if (!this.owner.field_70170_p.field_72995_K) {
                    CoreModule.sync((ServerPlayerEntity)this.owner);
                }
            }
        }
        if (this.drinkIndex != -1) {
            cache = this.caches[this.drinkIndex];
            if (cache == null) {
                return;
            }
            if (cache.type == PotionType.LINGERING) {
                this.drinkTick = 0;
                return;
            }
            if (++this.drinkTick >= EverCommonConfig.drinkDelay) {
                this.use(this.drinkIndex);
                this.stopDrinking();
                if (this.chargeIndex == -1) {
                    this.updateCharge();
                }
            }
        }
    }

    public void startDrinking(int slot) {
        Cache cache = this.caches[slot];
        if (cache.type == PotionType.LINGERING) {
            this.tipIndex = this.tipIndex == slot ? -1 : slot;
        } else {
            this.drinkIndex = slot;
        }
        if (this.owner.field_70170_p.field_72995_K) {
            new CDrinkPacket(slot).send();
        }
    }

    public void stopDrinking() {
        this.drinkIndex = -1;
        this.drinkTick = 0;
    }

    public void invalidate() {
        this.owner = null;
    }

    private void use(int slot) {
        Cache cache = this.caches[slot];
        cache.progress = 0.0f;
        if (this.owner.field_70170_p.field_72995_K) {
            return;
        }
        PotionType type = cache.type;
        if (type == PotionType.NORMAL) {
            this.doEffect(cache.effect, (LivingEntity)this.owner);
        } else if (type == PotionType.SPLASH) {
            AxisAlignedBB axisalignedbb;
            List list;
            if (cache.effect == null) {
                BlockPos pos = this.owner.func_233580_cy_();
                this.extinguishFires(this.owner.field_70170_p, pos, Direction.DOWN);
                this.extinguishFires(this.owner.field_70170_p, pos.func_177984_a(), Direction.DOWN);
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    this.extinguishFires(this.owner.field_70170_p, pos.func_177972_a(direction), direction);
                }
            }
            if (!(list = this.owner.field_70170_p.func_217357_a(LivingEntity.class, axisalignedbb = new AxisAlignedBB(this.owner.func_233580_cy_()).func_72314_b(4.0, 2.0, 4.0))).isEmpty()) {
                for (LivingEntity livingentity : list) {
                    double d0 = this.owner.func_70068_e((Entity)livingentity);
                    if (!(d0 < 16.0)) continue;
                    this.doEffect(cache.effect, livingentity);
                }
            }
            int i = cache.effect != null && cache.effect.func_188419_a().func_76403_b() ? 2007 : 2002;
            this.owner.field_70170_p.func_217379_c(i, this.owner.func_233580_cy_(), cache.color);
        }
    }

    private void doEffect(EffectInstance effect, LivingEntity entity) {
        if (effect == null) {
            entity.func_70066_B();
            if (PotionEntity.field_190546_d.test(entity)) {
                entity.func_70097_a(DamageSource.func_76354_b((Entity)entity, (Entity)this.owner), 1.0f);
            }
        } else if (effect.func_188419_a().func_76403_b()) {
            effect.func_188419_a().func_180793_a((Entity)entity, (Entity)this.owner, entity, effect.func_76458_c(), 1.0);
        } else {
            entity.func_195064_c(new EffectInstance(effect));
        }
    }

    private void extinguishFires(World world, BlockPos pos, Direction p_184542_2_) {
        BlockState blockstate = world.func_180495_p(pos);
        if (blockstate.func_235714_a_((ITag)BlockTags.field_232872_am_)) {
            world.func_217377_a(pos, false);
        } else if (CampfireBlock.func_226915_i_((BlockState)blockstate)) {
            world.func_217378_a((PlayerEntity)null, 1009, pos, 0);
            CampfireBlock.func_235475_c_((IWorld)world, (BlockPos)pos, (BlockState)blockstate);
            world.func_175656_a(pos, (BlockState)blockstate.func_206870_a((Property)CampfireBlock.field_220101_b, (Comparable)Boolean.valueOf(false)));
        }
    }

    public boolean canUseSlot(int slot, boolean selectOnly) {
        if (slot < 0 || slot >= this.slots) {
            return false;
        }
        if (this.owner != null && this.drinkIndex == -1 && this.caches[slot] != null) {
            Cache cache = this.caches[slot];
            if (cache.type == PotionType.LINGERING) {
                return selectOnly || cache.progress >= (float)EverCommonConfig.tipArrowTimeCost;
            }
            return cache.progress >= (float)EverCommonConfig.refillTime;
        }
        return false;
    }

    public AbstractArrowEntity tryTipArrow(World worldIn, ItemStack stack) {
        if (!worldIn.field_72995_K && this.tipIndex != -1 && this.caches[this.tipIndex].progress >= (float)EverCommonConfig.tipArrowTimeCost && this.caches[this.tipIndex].effect != null) {
            EverArrowEntity arrow = new EverArrowEntity(worldIn, (LivingEntity)this.owner);
            arrow.func_184558_a(this.caches[this.tipIndex].effect);
            this.caches[this.tipIndex].progress -= (float)EverCommonConfig.tipArrowTimeCost;
            this.updateCharge();
            CoreModule.sync((ServerPlayerEntity)this.owner);
            return arrow;
        }
        return null;
    }

    public void accelerate(float f) {
        this.acceleration = Math.min(this.acceleration + f, 2.0f);
    }

    public void setAll(int time) {
        this.chargeIndex = -1;
        for (int i = 0; i < this.caches.length; ++i) {
            if (this.caches[i] == null) continue;
            this.caches[i].progress = time;
        }
        CoreModule.sync((ServerPlayerEntity)this.owner);
    }

    public static final class Cache {
        @Nullable
        public final EffectInstance effect;
        public final PotionType type;
        public float progress;
        public final int color;
        public final ItemStack stack;
        public final float speed;

        private Cache(ItemStack stack) {
            this.stack = stack;
            this.effect = CoreItem.getEffectInstance(stack);
            this.type = CoreItem.getPotionType(stack);
            this.speed = CoreItem.getChargeModifier(stack);
            if (this.effect != null) {
                int color = this.effect.func_188419_a().func_76401_j();
                Vector3f hsv = MathUtil.RGBtoHSV((int)color);
                this.color = MathHelper.func_181758_c((float)hsv.func_195899_a(), (float)hsv.func_195900_b(), (float)1.0f);
            } else {
                this.color = 4749311;
            }
        }

        private boolean matches(ItemStack stack) {
            return ItemStack.func_77989_b((ItemStack)this.stack, (ItemStack)stack);
        }
    }
}

