/*
 * Decompiled with CFR 0.152.
 */
package snownee.everpotion.item;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import snownee.everpotion.CoreModule;
import snownee.everpotion.EverCommonConfig;
import snownee.everpotion.PotionType;
import snownee.everpotion.container.PlaceContainer;
import snownee.everpotion.crafting.CraftingModule;
import snownee.kiwi.Kiwi;
import snownee.kiwi.item.ModItem;
import snownee.kiwi.util.NBTHelper;

public class CoreItem
extends ModItem {
    public CoreItem() {
        super(new Item.Properties().func_200917_a(1));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        EffectInstance effectinstance = CoreItem.getEffectInstance(stack);
        if (effectinstance != null) {
            TranslationTextComponent itextcomponent = new TranslationTextComponent(effectinstance.func_76453_d());
            Effect effect = effectinstance.func_188419_a();
            if (effectinstance.func_76458_c() > 0) {
                itextcomponent.func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("potion.potency." + effectinstance.func_76458_c()));
            }
            if (effectinstance.func_76459_b() > 20) {
                itextcomponent.func_240702_b_(" (").func_240702_b_(EffectUtils.func_188410_a((EffectInstance)effectinstance, (float)((float)EverCommonConfig.durationFactor))).func_240702_b_(")");
            }
            tooltip.add((ITextComponent)itextcomponent.func_240699_a_(effect.func_220303_e().func_220306_a()));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("effect.none").func_240699_a_(TextFormatting.GRAY));
        }
        PotionType type = CoreItem.getPotionType(stack);
        if (type != PotionType.NORMAL) {
            tooltip.add((ITextComponent)new TranslationTextComponent(type.getDescKey()).func_240699_a_(TextFormatting.GRAY));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @Nullable
    public static EffectInstance getEffectInstance(ItemStack stack) {
        CompoundNBT tag = stack.func_179543_a("Effect");
        return tag == null ? null : EffectInstance.func_82722_b((CompoundNBT)tag);
    }

    @Nullable
    public static Effect getEffect(ItemStack stack) {
        EffectInstance instance = CoreItem.getEffectInstance(stack);
        return instance == null ? null : instance.func_188419_a();
    }

    public static PotionType getPotionType(ItemStack stack) {
        return PotionType.valueOf(NBTHelper.of((ItemStack)stack).getByte("Type"));
    }

    public static float getChargeModifier(ItemStack stack) {
        return NBTHelper.of((ItemStack)stack).getFloat("Charge", 1.0f);
    }

    public ItemStack make(@Nullable EffectInstance effect, PotionType type, float charge) {
        ItemStack stack = new ItemStack((IItemProvider)this);
        stack.func_196082_o().func_74774_a("Type", (byte)type.ordinal());
        if (effect != null) {
            stack.func_77978_p().func_218657_a("Effect", (INBT)effect.func_82719_a(new CompoundNBT()));
        }
        if (charge != 1.0f) {
            stack.func_77978_p().func_74776_a("Charge", charge);
        }
        return stack;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(group)) {
            return;
        }
        if (!Kiwi.isLoaded((ResourceLocation)new ResourceLocation("everpotion", "crafting"))) {
            return;
        }
        RecipeManager manager = CraftingModule.getRecipeManager();
        if (manager == null) {
            return;
        }
        items.addAll((Collection)manager.func_215366_a(CraftingModule.RECIPE_TYPE).values().stream().map(IRecipe::func_77571_b).filter(s -> s.func_77973_b() == CoreModule.CORE).sorted((a, b) -> {
            String effectB;
            String effectA = Objects.toString(CoreItem.getEffect(a));
            int i = effectA.compareTo(effectB = Objects.toString(CoreItem.getEffect(b)));
            if (i != 0) {
                return i;
            }
            PotionType typeA = CoreItem.getPotionType(a);
            PotionType typeB = CoreItem.getPotionType(b);
            return typeA.compareTo(typeB);
        }).collect(Collectors.toList()));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (!worldIn.field_72995_K) {
            playerIn.func_213829_a((INamedContainerProvider)PlaceContainer.ContainerProvider.INSTANCE);
        }
        return ActionResult.func_226248_a_((Object)playerIn.func_184586_b(handIn));
    }
}

