/*
 * Decompiled with CFR 0.152.
 */
package snownee.everpotion.item;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import snownee.everpotion.CoreModule;
import snownee.everpotion.EverCommonConfig;
import snownee.everpotion.cap.EverCapabilities;
import snownee.everpotion.handler.EverHandler;
import snownee.kiwi.item.ModItem;
import snownee.kiwi.util.NBTHelper;

public class UnlockSlotItem
extends ModItem {
    public UnlockSlotItem() {
        super(new Item.Properties());
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (worldIn.field_72995_K) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        EverHandler handler = (EverHandler)((Object)playerIn.getCapability(EverCapabilities.HANDLER).orElse(null));
        if (handler == null) {
            UnlockSlotItem.sendMsg((ServerPlayerEntity)playerIn, "noHandler");
            return ActionResult.func_226251_d_((Object)stack);
        }
        boolean force = NBTHelper.of((ItemStack)stack).getBoolean("Force");
        int tier = UnlockSlotItem.getTier(stack);
        if (!force) {
            if (handler.getSlots() >= EverCommonConfig.maxSlots) {
                UnlockSlotItem.sendMsg((ServerPlayerEntity)playerIn, "maxLevel");
                return ActionResult.func_226251_d_((Object)stack);
            }
            if (tier > 0) {
                if (handler.getSlots() + 1 < tier) {
                    UnlockSlotItem.sendMsg((ServerPlayerEntity)playerIn, "tooHigh");
                    return ActionResult.func_226251_d_((Object)stack);
                }
                if (handler.getSlots() + 1 > tier) {
                    UnlockSlotItem.sendMsg((ServerPlayerEntity)playerIn, "tooLow");
                    return ActionResult.func_226251_d_((Object)stack);
                }
            } else {
                tier = handler.getSlots() + 1;
            }
        }
        handler.setSlots(tier);
        stack.func_190918_g(1);
        worldIn.func_184133_a(null, playerIn.func_233580_cy_(), SoundEvents.field_187802_ec, SoundCategory.PLAYERS, 1.0f, 1.0f);
        CoreModule.sync((ServerPlayerEntity)playerIn);
        return ActionResult.func_226249_b_((Object)stack);
    }

    private static void sendMsg(ServerPlayerEntity player, String translationKey) {
        player.func_241151_a_((ITextComponent)new TranslationTextComponent("msg.everpotion." + translationKey), ChatType.GAME_INFO, Util.field_240973_b_);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (NBTHelper.of((ItemStack)stack).getBoolean("Force")) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tip.everpotion.force").func_240699_a_(TextFormatting.RED));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public String func_77667_c(ItemStack stack) {
        int tier = UnlockSlotItem.getTier(stack);
        if (tier > 0 && tier <= 4) {
            return this.func_77658_a() + "." + tier;
        }
        return this.func_77658_a();
    }

    public Rarity func_77613_e(ItemStack stack) {
        switch (UnlockSlotItem.getTier(stack)) {
            default: {
                return Rarity.COMMON;
            }
            case 2: {
                return Rarity.UNCOMMON;
            }
            case 3: {
                return Rarity.RARE;
            }
            case 4: 
        }
        return Rarity.EPIC;
    }

    public static int getTier(ItemStack stack) {
        return MathHelper.func_76125_a((int)NBTHelper.of((ItemStack)stack).getInt("Tier"), (int)0, (int)4);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ItemStack stack = new ItemStack((IItemProvider)this);
            NBTHelper data = NBTHelper.of((ItemStack)stack);
            for (int i = 0; i < 2; ++i) {
                items.add((Object)stack.func_77946_l());
                for (int j = 1; j <= 4; ++j) {
                    data.setInt("Tier", j);
                    items.add((Object)stack.func_77946_l());
                }
                stack.func_77978_p().func_150296_c().clear();
                data.setBoolean("Force", true);
            }
        }
    }
}

