/*
 * Decompiled with CFR 0.152.
 */
package snownee.everpotion.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import snownee.everpotion.cap.EverCapabilities;
import snownee.kiwi.network.ClientPacket;
import snownee.kiwi.network.Packet;

public class CDrinkPacket
extends ClientPacket {
    private final int index;

    public CDrinkPacket(int index) {
        this.index = index;
    }

    public static class Handler
    extends Packet.PacketHandler<CDrinkPacket> {
        public CDrinkPacket decode(PacketBuffer buf) {
            return new CDrinkPacket(buf.readByte());
        }

        public void encode(CDrinkPacket pkt, PacketBuffer buf) {
            buf.writeByte(pkt.index);
        }

        public void handle(CDrinkPacket pkt, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
                sender.getCapability(EverCapabilities.HANDLER).ifPresent(hander -> {
                    if (hander.canUseSlot(pkt.index, true)) {
                        hander.startDrinking(pkt.index);
                    }
                });
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

