/*
 * Decompiled with CFR 0.152.
 */
package snownee.everpotion.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import snownee.everpotion.cap.EverCapabilities;
import snownee.everpotion.handler.EverHandler;
import snownee.kiwi.network.Packet;

public class SSyncPotionsPacket
extends Packet {
    private final ServerPlayerEntity player;
    private final EverHandler handler;

    public SSyncPotionsPacket(ServerPlayerEntity player) {
        this.player = player;
        this.handler = (EverHandler)((Object)player.getCapability(EverCapabilities.HANDLER).orElse(null));
    }

    public SSyncPotionsPacket(EverHandler handler) {
        this.player = null;
        this.handler = handler;
    }

    public void send() {
        if (this.handler != null) {
            this.send(this.player);
        }
    }

    public static class Handler
    extends Packet.PacketHandler<SSyncPotionsPacket> {
        public SSyncPotionsPacket decode(PacketBuffer buf) {
            EverHandler handler = new EverHandler();
            int slots = buf.readByte();
            handler.setSlots(slots);
            for (int i = 0; i < slots; ++i) {
                handler.setStackInSlot(i, buf.func_150791_c());
                float progress = buf.readFloat();
                if (handler.caches[i] == null) continue;
                handler.caches[i].progress = progress;
            }
            handler.chargeIndex = buf.readByte();
            handler.tipIndex = buf.readByte();
            handler.acceleration = buf.readFloat();
            return new SSyncPotionsPacket(handler);
        }

        public void encode(SSyncPotionsPacket pkt, PacketBuffer buf) {
            int slots = pkt.handler.getSlots();
            buf.writeByte(slots);
            for (int i = 0; i < slots; ++i) {
                buf.func_150788_a(pkt.handler.getStackInSlot(i));
                buf.writeFloat(((SSyncPotionsPacket)pkt).handler.caches[i] == null ? 0.0f : ((SSyncPotionsPacket)pkt).handler.caches[i].progress);
            }
            buf.writeByte(((SSyncPotionsPacket)pkt).handler.chargeIndex);
            buf.writeByte(((SSyncPotionsPacket)pkt).handler.tipIndex);
            buf.writeFloat(((SSyncPotionsPacket)pkt).handler.acceleration);
        }

        public void handle(SSyncPotionsPacket pkt, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> Minecraft.func_71410_x().field_71439_g.getCapability(EverCapabilities.HANDLER).ifPresent(handler -> handler.copyFrom(pkt.handler)));
            ctx.get().setPacketHandled(true);
        }
    }
}

