/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client;

import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.model.FramedCornerSlopeModel;
import xfacthd.framedblocks.client.model.FramedInnerCornerSlopeModel;
import xfacthd.framedblocks.client.model.FramedInnerPrismCornerModel;
import xfacthd.framedblocks.client.model.FramedInnerThreewayCornerModel;
import xfacthd.framedblocks.client.model.FramedLeverModel;
import xfacthd.framedblocks.client.model.FramedPrismCornerModel;
import xfacthd.framedblocks.client.model.FramedSlopeModel;
import xfacthd.framedblocks.client.model.FramedThreewayCornerModel;
import xfacthd.framedblocks.client.render.FramedSignRenderer;
import xfacthd.framedblocks.client.screen.FramedSignScreen;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.CornerType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.SlopeType;
import xfacthd.framedblocks.common.tileentity.FramedSignTileEntity;
import xfacthd.framedblocks.common.tileentity.FramedTileEntity;

@Mod.EventBusSubscriber(modid="framedblocks", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class FBClient {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        ForgeRegistries.BLOCKS.getValues().stream().filter(block -> block.getRegistryName().func_110624_b().equals("framedblocks")).forEach(block -> RenderTypeLookup.setRenderLayer((Block)block, type -> type == RenderType.func_228639_c_() || type == RenderType.func_228643_e_() || type == RenderType.func_228641_d_()));
        ClientRegistry.bindTileEntityRenderer(FBContent.tileTypeFramedSign, FramedSignRenderer::new);
    }

    @SubscribeEvent
    public static void onBlockColors(ColorHandlerEvent.Block event) {
        Block[] blocks = (Block[])ForgeRegistries.BLOCKS.getValues().stream().filter(block -> block.getRegistryName().func_110624_b().equals("framedblocks")).toArray(Block[]::new);
        event.getBlockColors().func_186722_a((state, world, pos, tintIndex) -> {
            BlockState camoState;
            TileEntity te;
            if (world != null && pos != null && (te = world.func_175625_s(pos)) instanceof FramedTileEntity && !(camoState = ((FramedTileEntity)te).getCamoState()).func_196958_f()) {
                return event.getBlockColors().func_228054_a_(camoState, world, pos, tintIndex);
            }
            return -1;
        }, blocks);
    }

    @SubscribeEvent
    public static void onModelsLoaded(ModelBakeEvent event) {
        Map registry = event.getModelRegistry();
        FBClient.replaceModelsSimple(FBContent.blockFramedCube, registry);
        FBClient.replaceModelsAdvanced(FBContent.blockFramedSlope, registry, (state, baseModel) -> {
            Direction dir = (Direction)state.func_177229_b((IProperty)PropertyHolder.FACING_HOR);
            SlopeType type = (SlopeType)((Object)((Object)state.func_177229_b(PropertyHolder.SLOPE_TYPE)));
            return new FramedSlopeModel((IBakedModel)baseModel, dir, type);
        }, baseModel -> new FramedSlopeModel((IBakedModel)baseModel, Direction.SOUTH, SlopeType.BOTTOM));
        FBClient.replaceModelsAdvanced(FBContent.blockFramedCornerSlope, registry, (state, baseModel) -> {
            Direction dir = (Direction)state.func_177229_b((IProperty)PropertyHolder.FACING_HOR);
            CornerType type = (CornerType)((Object)((Object)state.func_177229_b(PropertyHolder.CORNER_TYPE)));
            return new FramedCornerSlopeModel((IBakedModel)baseModel, dir, type);
        }, baseModel -> new FramedCornerSlopeModel((IBakedModel)baseModel, Direction.SOUTH, CornerType.BOTTOM));
        FBClient.replaceModelsAdvanced(FBContent.blockFramedInnerCornerSlope, registry, (state, baseModel) -> {
            Direction dir = (Direction)state.func_177229_b((IProperty)PropertyHolder.FACING_HOR);
            CornerType type = (CornerType)((Object)((Object)state.func_177229_b(PropertyHolder.CORNER_TYPE)));
            return new FramedInnerCornerSlopeModel((IBakedModel)baseModel, dir, type);
        }, baseModel -> new FramedInnerCornerSlopeModel((IBakedModel)baseModel, Direction.SOUTH, CornerType.BOTTOM));
        FBClient.replaceModelsAdvanced(FBContent.blockFramedPrismCorner, registry, (state, baseModel) -> {
            Direction dir = (Direction)state.func_177229_b((IProperty)PropertyHolder.FACING_HOR);
            boolean top = (Boolean)state.func_177229_b((IProperty)PropertyHolder.TOP);
            return new FramedPrismCornerModel((IBakedModel)baseModel, dir, top);
        }, baseModel -> new FramedPrismCornerModel((IBakedModel)baseModel, Direction.SOUTH, false));
        FBClient.replaceModelsAdvanced(FBContent.blockFramedInnerPrismCorner, registry, (state, baseModel) -> {
            Direction dir = (Direction)state.func_177229_b((IProperty)PropertyHolder.FACING_HOR);
            boolean top = (Boolean)state.func_177229_b((IProperty)PropertyHolder.TOP);
            return new FramedInnerPrismCornerModel((IBakedModel)baseModel, dir, top);
        }, baseModel -> new FramedInnerPrismCornerModel((IBakedModel)baseModel, Direction.SOUTH, false));
        FBClient.replaceModelsAdvanced(FBContent.blockFramedThreewayCorner, registry, (state, baseModel) -> {
            Direction dir = (Direction)state.func_177229_b((IProperty)PropertyHolder.FACING_HOR);
            boolean top = (Boolean)state.func_177229_b((IProperty)PropertyHolder.TOP);
            return new FramedThreewayCornerModel((IBakedModel)baseModel, dir, top);
        }, baseModel -> new FramedThreewayCornerModel((IBakedModel)baseModel, Direction.SOUTH, false));
        FBClient.replaceModelsAdvanced(FBContent.blockFramedInnerThreewayCorner, registry, (state, baseModel) -> {
            Direction dir = (Direction)state.func_177229_b((IProperty)PropertyHolder.FACING_HOR);
            boolean top = (Boolean)state.func_177229_b((IProperty)PropertyHolder.TOP);
            return new FramedInnerThreewayCornerModel((IBakedModel)baseModel, dir, top);
        }, baseModel -> new FramedInnerThreewayCornerModel((IBakedModel)baseModel, Direction.SOUTH, false));
        FBClient.replaceModelsSimple(FBContent.blockFramedSlab, registry);
        FBClient.replaceModelsSimple(FBContent.blockFramedPanel, registry);
        FBClient.replaceModelsSimple(FBContent.blockFramedCornerPillar, registry);
        FBClient.replaceModelsSimple(FBContent.blockFramedStairs, registry);
        FBClient.replaceModelsSimple(FBContent.blockFramedWall, registry);
        FBClient.replaceModelsSimple(FBContent.blockFramedFence, registry);
        FBClient.replaceModelsSimple(FBContent.blockFramedGate, registry);
        FBClient.replaceModelsSimple(FBContent.blockFramedDoor, registry);
        FBClient.replaceModelsSimple(FBContent.blockFramedTrapDoor, registry);
        FBClient.replaceModelsSimple(FBContent.blockFramedPressurePlate, registry);
        FBClient.replaceModelsSimple(FBContent.blockFramedLadder, registry);
        FBClient.replaceModelsSimple(FBContent.blockFramedButton, registry);
        FBClient.replaceModelsSimple(FBContent.blockFramedLever, registry, FramedLeverModel::new);
        FBClient.replaceModelsSimple(FBContent.blockFramedSign, registry);
        FBClient.replaceModelsSimple(FBContent.blockFramedWallSign, registry);
    }

    private static void replaceModelsSimple(Block block, Map<ResourceLocation, IBakedModel> models) {
        FBClient.replaceModelsSimple(block, models, FramedBlockModel::new);
    }

    private static void replaceModelsSimple(Block block, Map<ResourceLocation, IBakedModel> models, BiFunction<BlockType, IBakedModel, IBakedModel> blockModelGen) {
        BlockType type = ((IFramedBlock)block).getBlockType();
        for (BlockState state : block.func_176194_O().func_177619_a()) {
            ModelResourceLocation location = BlockModelShapes.func_209554_c((BlockState)state);
            IBakedModel baseModel = models.get(location);
            IBakedModel replacement = blockModelGen.apply(type, baseModel);
            models.put((ResourceLocation)location, replacement);
        }
    }

    private static void replaceModelsAdvanced(Block block, Map<ResourceLocation, IBakedModel> models, BiFunction<BlockState, IBakedModel, IBakedModel> blockModelGen, Function<IBakedModel, IBakedModel> itemModelGen) {
        for (BlockState state : block.func_176194_O().func_177619_a()) {
            ModelResourceLocation location = BlockModelShapes.func_209554_c((BlockState)state);
            IBakedModel baseModel = models.get(location);
            IBakedModel replacement = blockModelGen.apply(state, baseModel);
            models.put((ResourceLocation)location, replacement);
        }
        ModelResourceLocation location = new ModelResourceLocation(block.getRegistryName(), "inventory");
        IBakedModel baseModel = models.get(location);
        IBakedModel replacement = itemModelGen.apply(baseModel);
        models.put((ResourceLocation)location, replacement);
    }

    public static void openSignScreen(BlockPos pos) {
        TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(pos);
        if (te instanceof FramedSignTileEntity) {
            Minecraft.func_71410_x().func_147108_a((Screen)new FramedSignScreen((FramedSignTileEntity)te));
        }
    }
}

