/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Table;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.client.model.BakedModelProxy;
import xfacthd.framedblocks.client.util.FramedBlockData;
import xfacthd.framedblocks.client.util.ModelUtils;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedBlockModel
extends BakedModelProxy {
    private final Table<BlockState, RenderType, List<BakedQuad>> quadCacheTable = HashBasedTable.create();
    private final Map<BlockState, IBakedModel> modelCache = new HashMap<BlockState, IBakedModel>();
    private final HashMap<BlockState, TextureAtlasSprite> particleCache = new HashMap();
    private final BlockType type;
    private ImmutableList<BakedQuad> baseQuads = null;
    private static Field ctmParent = null;

    public FramedBlockModel(BlockType type, IBakedModel baseModel) {
        super(baseModel);
        this.type = type;
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, Random rand, IModelData extraData) {
        BlockState camoState;
        if (this.baseQuads == null) {
            this.baseQuads = this.prepareBaseQuads(state, rand);
        }
        RenderType layer = MinecraftForgeClient.getRenderLayer();
        if (extraData instanceof FramedBlockData && (camoState = (BlockState)extraData.getData(FramedBlockData.CAMO)) != null && !camoState.func_196958_f()) {
            if (RenderTypeLookup.canRenderInLayer((BlockState)camoState, (RenderType)layer)) {
                return this.getCamoQuads(state, camoState, side, rand, extraData, layer);
            }
            return Collections.emptyList();
        }
        return layer == RenderType.func_228641_d_() ? this.baseQuads : Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<BakedQuad> getCamoQuads(BlockState state, BlockState camoState, Direction side, Random rand, IModelData extraData, RenderType layer) {
        if (side == null) {
            Table<BlockState, RenderType, List<BakedQuad>> table = this.quadCacheTable;
            synchronized (table) {
                if (!this.quadCacheTable.contains((Object)camoState, (Object)layer)) {
                    this.quadCacheTable.put((Object)camoState, (Object)layer, this.makeQuads(state, camoState, rand));
                }
                return (List)this.quadCacheTable.get((Object)camoState, (Object)layer);
            }
        }
        if (this.type.getCtmPredicate().test(state, side)) {
            Map<BlockState, IBakedModel> map = this.modelCache;
            synchronized (map) {
                if (!this.modelCache.containsKey(camoState)) {
                    this.modelCache.put(camoState, FramedBlockModel.getCamoModel(camoState, false));
                }
                IBakedModel model = this.modelCache.get(camoState);
                IModelData data = FramedBlockModel.getCamoData(model, camoState, extraData);
                return model.getQuads(camoState, side, rand, data);
            }
        }
        return Collections.emptyList();
    }

    private static IModelData getCamoData(IBakedModel model, BlockState state, IModelData data) {
        World world = (World)data.getData(FramedBlockData.WORLD);
        BlockPos pos = (BlockPos)data.getData(FramedBlockData.POS);
        if (world == null || pos == null || pos.equals((Object)BlockPos.field_177992_a)) {
            return data;
        }
        return model.getModelData((ILightReader)world, pos, state, data);
    }

    private List<BakedQuad> makeQuads(BlockState state, BlockState camoState, Random rand) {
        IBakedModel camoModel = FramedBlockModel.getCamoModel(camoState, true);
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (BakedQuad quad : this.baseQuads) {
            if (this.type.getCtmPredicate().test(state, quad.func_178210_d())) continue;
            List<BakedQuad> camoQuads = FramedBlockModel.getSideQuads(camoModel, camoState, quad.func_178210_d(), rand);
            for (BakedQuad camoQuad : camoQuads) {
                listBuilder.add((Object)this.buildQuad(quad, camoQuad));
            }
        }
        return listBuilder.build();
    }

    protected BakedQuad buildQuad(BakedQuad baseQuad, BakedQuad camoQuad) {
        BakedQuad quadCopy = new BakedQuad(Arrays.copyOf(baseQuad.func_178209_a(), baseQuad.func_178209_a().length), camoQuad.func_178211_c(), baseQuad.func_178210_d(), camoQuad.func_187508_a(), baseQuad.shouldApplyDiffuseLighting());
        ModelUtils.modifyQuad(quadCopy, (pos, color, uv, light, normal) -> this.setTextureUV(uv, baseQuad.func_187508_a(), camoQuad.func_187508_a()));
        return quadCopy;
    }

    private void setTextureUV(float[][] uv, TextureAtlasSprite baseSprite, TextureAtlasSprite camoSprite) {
        for (int vert = 0; vert < 4; ++vert) {
            uv[vert][0] = camoSprite.func_94214_a((double)FramedBlockModel.uninterpolateU(baseSprite, uv[vert][0]));
            uv[vert][1] = camoSprite.func_94207_b((double)FramedBlockModel.uninterpolateV(baseSprite, uv[vert][1]));
        }
    }

    private static float uninterpolateU(TextureAtlasSprite sprite, float u) {
        float h = sprite.func_94212_f() - sprite.func_94209_e();
        return (u - sprite.func_94209_e()) / h * 16.0f;
    }

    private static float uninterpolateV(TextureAtlasSprite sprite, float v) {
        float w = sprite.func_94210_h() - sprite.func_94206_g();
        return (v - sprite.func_94206_g()) / w * 16.0f;
    }

    protected ImmutableList<BakedQuad> prepareBaseQuads(BlockState state, Random rand) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(FramedBlockModel.getAllQuads(this.baseModel, state, rand));
        return builder.build();
    }

    @Override
    public List<BakedQuad> func_200117_a(BlockState state, Direction side, Random rand) {
        if (this.baseQuads == null) {
            this.baseQuads = this.prepareBaseQuads(state, rand);
        }
        return this.baseQuads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextureAtlasSprite getParticleTexture(IModelData data) {
        BlockState camoState;
        if (data instanceof FramedBlockData && (camoState = (BlockState)data.getData(FramedBlockData.CAMO)) != null && !camoState.func_196958_f()) {
            HashMap<BlockState, TextureAtlasSprite> hashMap = this.particleCache;
            synchronized (hashMap) {
                return this.particleCache.computeIfAbsent(camoState, state -> FramedBlockModel.getCamoModel(camoState, false).func_177554_e());
            }
        }
        return this.baseModel.func_177554_e();
    }

    protected static IBakedModel getCamoModel(BlockState camoState, boolean needCtmParent) {
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(camoState);
        if (needCtmParent && model.getClass().getName().equals("team.chisel.ctm.client.model.ModelBakedCTM")) {
            try {
                if (ctmParent == null) {
                    ctmParent = model.getClass().getSuperclass().getDeclaredField("parent");
                    ctmParent.setAccessible(true);
                }
                model = (IBakedModel)ctmParent.get(model);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                FramedBlocks.LOGGER.error("Failed to retrieve parent model from CTM model!", (Throwable)e);
            }
        }
        return model;
    }

    protected static List<BakedQuad> getSideQuads(IBakedModel model, BlockState state, Direction side, Random rand) {
        return FramedBlockModel.getSideQuads(model, state, side, rand, (IModelData)EmptyModelData.INSTANCE);
    }

    protected static List<BakedQuad> getSideQuads(IBakedModel model, BlockState state, Direction side, Random rand, IModelData data) {
        return model.getQuads(state, side, rand, data);
    }

    protected static List<BakedQuad> getAllQuads(IBakedModel model, BlockState state, Random rand) {
        return FramedBlockModel.getAllQuads(model, state, rand, (IModelData)EmptyModelData.INSTANCE);
    }

    public static List<BakedQuad> getAllQuads(IBakedModel model, BlockState state, Random rand, IModelData modelData) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(model.getQuads(state, null, rand, modelData));
        for (Direction dir : Direction.values()) {
            quads.addAll(model.getQuads(state, dir, rand, modelData));
        }
        return quads;
    }
}

