/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.Direction;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.model.FramedSlopeModel;
import xfacthd.framedblocks.client.util.ModelUtils;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.CornerType;
import xfacthd.framedblocks.common.data.SlopeType;

public class FramedCornerSlopeModel
extends FramedBlockModel {
    private final Direction dir;
    private final CornerType type;

    public FramedCornerSlopeModel(IBakedModel baseModel, Direction dir, CornerType type) {
        super(BlockType.FRAMED_CORNER_SLOPE, baseModel);
        this.dir = dir;
        this.type = type;
    }

    @Override
    protected ImmutableList<BakedQuad> prepareBaseQuads(BlockState state, Random rand) {
        ImmutableList.Builder builder = ImmutableList.builder();
        List<BakedQuad> quads = FramedCornerSlopeModel.getAllQuads(this.baseModel, state, new Random());
        ArrayList<BakedQuad> modifiedQuads = new ArrayList<BakedQuad>();
        ListIterator<BakedQuad> quadIterator = quads.listIterator();
        while (quadIterator.hasNext()) {
            BakedQuad finalQuad;
            BakedQuad quad = (BakedQuad)quadIterator.next();
            if (this.type == CornerType.BOTTOM && quad.func_178210_d() == Direction.UP) {
                quad = new BakedQuad(quad.func_178209_a(), quad.func_178211_c(), this.dir.func_176734_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting());
            } else if (this.type == CornerType.TOP && quad.func_178210_d() == Direction.DOWN) {
                Direction face = ModelUtils.findHorizontalFacing(quad);
                quad = new BakedQuad(quad.func_178209_a(), quad.func_178211_c(), face, quad.func_187508_a(), quad.shouldApplyDiffuseLighting());
            }
            if (this.type.isHorizontal()) {
                Direction altDir;
                Direction direction = altDir = this.type.isRight() ? this.dir.func_176735_f() : this.dir.func_176746_e();
                if (!ModelUtils.isFacingTowards(quad, this.dir.func_176734_d()) && !ModelUtils.isFacingTowards(quad, altDir)) {
                    if (!this.type.isTop() && quad.func_178210_d() == Direction.DOWN || this.type.isTop() && quad.func_178210_d() == Direction.UP) {
                        quadIterator.remove();
                        modifiedQuads.add(ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> FramedCornerSlopeModel.createTopBottomTriangle(pos, uv, light, this.dir, this.type)));
                        continue;
                    }
                    if (quad.func_178210_d() != altDir.func_176734_d()) continue;
                    quadIterator.remove();
                    modifiedQuads.add(ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> FramedCornerSlopeModel.createSideTriangle(pos, uv, light, this.type)));
                    continue;
                }
                quadIterator.remove();
                finalQuad = quad;
                modifiedQuads.add(ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> FramedCornerSlopeModel.createSlopeTriangle(finalQuad, pos, uv, light, this.dir, this.type)));
                continue;
            }
            if (quad.func_178210_d() == this.dir.func_176734_d() || quad.func_178210_d() == this.dir.func_176746_e()) {
                quadIterator.remove();
                BakedQuad finalQuad2 = quad;
                modifiedQuads.add(ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> FramedCornerSlopeModel.createSlopeTriangle(finalQuad2, pos, uv, light, this.dir, this.type)));
                continue;
            }
            if (quad.func_178210_d() != this.dir && quad.func_178210_d() != this.dir.func_176735_f()) continue;
            quadIterator.remove();
            Direction fakeDir = quad.func_178210_d() == this.dir ? this.dir.func_176735_f() : this.dir;
            finalQuad = quad;
            modifiedQuads.add(ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> {
                SlopeType fakeType = this.type == CornerType.TOP ? SlopeType.TOP : SlopeType.BOTTOM;
                FramedSlopeModel.createSideTriangle(finalQuad, pos, uv, light, fakeDir, fakeType);
            }));
        }
        builder.addAll(quads);
        builder.addAll(modifiedQuads);
        return builder.build();
    }

    public static void createSlopeTriangle(BakedQuad quad, float[][] pos, float[][] uv, float[][] light, Direction dir, CornerType type) {
        if (type.isHorizontal()) {
            if (ModelUtils.isFacingTowards(quad, Direction.UP) || ModelUtils.isFacingTowards(quad, Direction.DOWN)) {
                int toIdx;
                int fromIdx;
                int posIdx;
                int count = (dir.func_176736_b() + 2) % 4;
                ModelUtils.rotateElement(uv, !type.isTop(), count);
                int n = posIdx = dir.func_176740_k() == Direction.Axis.Z ? 2 : 0;
                if (type.isRight() == type.isTop()) {
                    fromIdx = 2;
                    toIdx = 3;
                } else {
                    fromIdx = 3;
                    toIdx = 2;
                }
                pos[fromIdx][1] = pos[toIdx][1];
                pos[fromIdx][posIdx] = pos[toIdx][posIdx];
                uv[fromIdx][1] = uv[toIdx][1];
                light[fromIdx][1] = light[toIdx][1];
            } else {
                if (type.isTop() != type.isRight()) {
                    ModelUtils.rotateElement(uv, true, 1);
                }
                int fromIdx = type.isRight() == type.isTop() ? 1 : 3;
                int toIdx = 2;
                pos[fromIdx][1] = pos[toIdx][1];
                uv[fromIdx][1] = uv[toIdx][1];
                light[fromIdx][1] = light[toIdx][1];
            }
        } else if (quad.func_178210_d() == dir.func_176734_d()) {
            int posIdx;
            int n = posIdx = dir.func_176740_k() == Direction.Axis.Z ? 2 : 0;
            if (type == CornerType.TOP) {
                pos[2][1] = pos[3][1];
                pos[2][posIdx] = pos[3][posIdx];
                uv[2][1] = uv[3][1];
                light[2][1] = light[3][1];
            } else if (type == CornerType.BOTTOM) {
                pos[3][1] = pos[2][1];
                pos[3][posIdx] = pos[2][posIdx];
                uv[3][1] = uv[2][1];
                light[3][1] = light[2][1];
            }
        } else {
            int posIdx;
            int n = posIdx = dir.func_176740_k() == Direction.Axis.Z ? 0 : 2;
            if (type == CornerType.TOP) {
                pos[1][1] = pos[0][1];
                pos[1][posIdx] = pos[0][posIdx];
                uv[1][1] = uv[0][1];
                light[1][1] = light[0][1];
            } else if (type == CornerType.BOTTOM) {
                int count = (dir.func_176736_b() + 2) % 4;
                ModelUtils.rotateElement(uv, true, count);
                pos[3][1] = pos[0][1];
                pos[3][posIdx] = pos[0][posIdx];
                uv[3][1] = uv[0][1];
                light[3][1] = light[0][1];
            }
        }
    }

    public static void createTopBottomTriangle(float[][] pos, float[][] uv, float[][] light, Direction dir, CornerType type) {
        int toIdx;
        int fromIdx;
        int uvIdx;
        int posIdx = dir.func_176740_k() == Direction.Axis.X ? 2 : 0;
        int n = uvIdx = dir.func_176740_k() == Direction.Axis.X ? 1 : 0;
        if (type.isRight() == type.isTop()) {
            fromIdx = 1;
            toIdx = 2;
        } else {
            fromIdx = 0;
            toIdx = 3;
        }
        pos[fromIdx][posIdx] = pos[toIdx][posIdx];
        uv[fromIdx][uvIdx] = uv[toIdx][uvIdx];
        light[fromIdx][uvIdx] = light[toIdx][uvIdx];
    }

    public static void createSideTriangle(float[][] pos, float[][] uv, float[][] light, CornerType type) {
        int toIdx;
        int fromIdx;
        int posIdx = 1;
        int uvIdx = 1;
        if (type.isRight() == type.isTop()) {
            fromIdx = 2;
            toIdx = 1;
        } else {
            fromIdx = 3;
            toIdx = 0;
        }
        pos[fromIdx][posIdx] = pos[toIdx][posIdx];
        uv[fromIdx][uvIdx] = uv[toIdx][uvIdx];
        light[fromIdx][uvIdx] = light[toIdx][uvIdx];
    }
}

