/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.Direction;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.model.FramedCornerSlopeModel;
import xfacthd.framedblocks.client.model.FramedSlopeModel;
import xfacthd.framedblocks.client.util.ModelUtils;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.CornerType;
import xfacthd.framedblocks.common.data.SlopeType;

public class FramedInnerCornerSlopeModel
extends FramedBlockModel {
    private final Direction dir;
    private final CornerType type;

    public FramedInnerCornerSlopeModel(IBakedModel baseModel, Direction dir, CornerType type) {
        super(BlockType.FRAMED_INNER_CORNER_SLOPE, baseModel);
        this.dir = dir;
        this.type = type;
    }

    @Override
    protected ImmutableList<BakedQuad> prepareBaseQuads(BlockState state, Random rand) {
        ImmutableList.Builder builder = ImmutableList.builder();
        List<BakedQuad> quads = FramedInnerCornerSlopeModel.getAllQuads(this.baseModel, state, new Random());
        ArrayList<BakedQuad> modifiedQuads = new ArrayList<BakedQuad>();
        ListIterator<BakedQuad> quadIterator = quads.listIterator();
        while (quadIterator.hasNext()) {
            BakedQuad finalQuad;
            BakedQuad quad = (BakedQuad)quadIterator.next();
            if (!(this.type.isHorizontal() || quad.func_178210_d() != this.dir.func_176734_d() && quad.func_178210_d() != this.dir.func_176735_f())) {
                quadIterator.remove();
                finalQuad = quad;
                modifiedQuads.add(ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> {
                    Direction fakeDir = finalQuad.func_178210_d() == this.dir.func_176734_d() ? this.dir.func_176746_e() : this.dir;
                    SlopeType fakeType = this.type == CornerType.TOP ? SlopeType.TOP : SlopeType.BOTTOM;
                    FramedSlopeModel.createSideTriangle(finalQuad, pos, uv, light, fakeDir, fakeType);
                }));
                continue;
            }
            if (this.type == CornerType.BOTTOM && quad.func_178210_d() == Direction.UP || this.type == CornerType.TOP && quad.func_178210_d() == Direction.DOWN) {
                quad = new BakedQuad(quad.func_178209_a(), quad.func_178211_c(), ModelUtils.findHorizontalFacing(quad), quad.func_187508_a(), quad.shouldApplyDiffuseLighting());
                quadIterator.remove();
                finalQuad = quad;
                modifiedQuads.add(ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> FramedInnerCornerSlopeModel.createSlopeTriangle(finalQuad, pos, uv, light, this.dir, this.type)));
                continue;
            }
            if (!this.type.isHorizontal()) continue;
            if (!ModelUtils.isFacingTowards(quad, this.dir.func_176734_d())) {
                finalQuad = quad;
                if (this.type.isTop() && quad.func_178210_d() == Direction.DOWN || !this.type.isTop() && quad.func_178210_d() == Direction.UP) {
                    quadIterator.remove();
                    modifiedQuads.add(ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> {
                        Direction fakeDir = this.type.isRight() ? this.dir.func_176746_e() : this.dir;
                        FramedSlopeModel.createTopBottomTriangle(finalQuad, pos, uv, light, fakeDir);
                    }));
                    continue;
                }
                if ((!this.type.isRight() || quad.func_178210_d() != this.dir.func_176735_f()) && (this.type.isRight() || quad.func_178210_d() != this.dir.func_176746_e())) continue;
                quadIterator.remove();
                modifiedQuads.add(ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> FramedInnerCornerSlopeModel.createSideTriangle(finalQuad, pos, uv, light, this.dir, this.type)));
                continue;
            }
            quadIterator.remove();
            Direction quadFace = quad.func_178210_d();
            if (ModelUtils.isFacingTowards(quad, Direction.UP) || ModelUtils.isFacingTowards(quad, Direction.DOWN) && this.dir == Direction.NORTH && !this.type.isRight()) {
                quadFace = this.dir.func_176734_d();
            }
            BakedQuad finalQuad2 = quad = new BakedQuad(quad.func_178209_a(), quad.func_178211_c(), quadFace, quad.func_187508_a(), quad.shouldApplyDiffuseLighting());
            modifiedQuads.add(ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> FramedInnerCornerSlopeModel.createSlopeTriangle(finalQuad2, pos, uv, light, this.dir, this.type)));
        }
        builder.addAll(quads);
        builder.addAll(modifiedQuads);
        return builder.build();
    }

    private static void createSlopeTriangle(BakedQuad quad, float[][] pos, float[][] uv, float[][] light, Direction dir, CornerType type) {
        if (type == CornerType.TOP && quad.func_178210_d() == dir.func_176735_f()) {
            if (dir.func_176740_k() == Direction.Axis.Z) {
                pos[0][1] = pos[1][1];
                pos[0][0] = pos[1][0];
            } else {
                pos[0][1] = pos[1][1];
                pos[0][2] = pos[1][2];
            }
            uv[0][1] = uv[1][1];
            light[0][1] = light[1][1];
        } else if (!type.isHorizontal()) {
            CornerType fakeType = type == CornerType.TOP ? CornerType.BOTTOM : CornerType.TOP;
            FramedCornerSlopeModel.createSlopeTriangle(quad, pos, uv, light, dir, fakeType);
        } else if (ModelUtils.isFacingTowards(quad, Direction.UP) || ModelUtils.isFacingTowards(quad, Direction.DOWN)) {
            int coord2;
            if (dir.func_176740_k() == Direction.Axis.X) {
                boolean cw = dir.func_176743_c() == Direction.AxisDirection.NEGATIVE == type.isTop();
                ModelUtils.rotateElement(uv, cw, 1);
            } else if (dir == Direction.SOUTH) {
                ModelUtils.rotateElement(uv, true, 2);
            }
            int n = coord2 = dir.func_176740_k() == Direction.Axis.X ? 0 : 2;
            if (type == CornerType.HORIZONTAL_TOP_LEFT || type == CornerType.HORIZONTAL_BOTTOM_RIGHT) {
                pos[3][1] = pos[2][1];
                pos[3][coord2] = pos[2][coord2];
                uv[3][1] = uv[2][1];
                light[3][1] = light[2][1];
            } else if (type == CornerType.HORIZONTAL_TOP_RIGHT || type == CornerType.HORIZONTAL_BOTTOM_LEFT) {
                pos[2][1] = pos[3][1];
                pos[2][coord2] = pos[3][coord2];
                uv[2][1] = uv[3][1];
                light[2][1] = light[3][1];
            }
        } else {
            int coord2;
            int n = coord2 = dir.func_176740_k() == Direction.Axis.X ? 0 : 2;
            if (type == CornerType.HORIZONTAL_TOP_LEFT || type == CornerType.HORIZONTAL_BOTTOM_RIGHT) {
                pos[0][1] = pos[3][1];
                pos[0][coord2] = pos[3][coord2];
                uv[0][1] = uv[3][1];
                light[0][1] = light[3][1];
            } else if (type == CornerType.HORIZONTAL_TOP_RIGHT || type == CornerType.HORIZONTAL_BOTTOM_LEFT) {
                pos[1][1] = pos[2][1];
                pos[1][coord2] = pos[2][coord2];
                uv[1][1] = uv[2][1];
                light[1][1] = light[2][1];
            }
        }
    }

    private static void createSideTriangle(BakedQuad quad, float[][] pos, float[][] uv, float[][] light, Direction dir, CornerType type) {
        if (type.isTop() == (quad.func_178210_d() == dir.func_176746_e())) {
            pos[2][1] = pos[1][1];
            uv[2][1] = uv[1][1];
            light[2][1] = light[1][1];
        } else {
            pos[3][1] = pos[0][1];
            uv[3][1] = uv[0][1];
            light[3][1] = light[0][1];
        }
    }
}

