/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.Direction;
import net.minecraftforge.client.ForgeHooksClient;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.model.FramedSlopeModel;
import xfacthd.framedblocks.client.util.ModelUtils;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.SlopeType;

public class FramedInnerPrismCornerModel
extends FramedBlockModel {
    private final Direction dir;
    private final boolean top;

    public FramedInnerPrismCornerModel(IBakedModel baseModel, Direction dir, boolean top) {
        super(BlockType.FRAMED_INNER_PRISM_CORNER, baseModel);
        this.dir = dir;
        this.top = top;
    }

    @Override
    protected ImmutableList<BakedQuad> prepareBaseQuads(BlockState state, Random rand) {
        ImmutableList.Builder builder = ImmutableList.builder();
        List<BakedQuad> quads = FramedInnerPrismCornerModel.getAllQuads(this.baseModel, state, new Random());
        for (BakedQuad quad : quads) {
            quad = ModelUtils.duplicateQuad(quad);
            if (this.top && quad.func_178210_d() == Direction.DOWN || !this.top && quad.func_178210_d() == Direction.UP) {
                BakedQuad finalQuad = quad;
                builder.add((Object)ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> FramedSlopeModel.createTopBottomTriangle(finalQuad, pos, uv, light, this.dir)));
                continue;
            }
            if (ModelUtils.isFacingTowards(quad, this.dir.func_176734_d()) && ModelUtils.isFacingTowards(quad, this.dir.func_176746_e())) {
                builder.add((Object)ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> FramedInnerPrismCornerModel.createSlopeTriangle(pos, uv, light, this.dir, this.top)));
                ForgeHooksClient.fillNormal((int[])quad.func_178209_a(), (Direction)this.dir.func_176746_e());
                continue;
            }
            if (quad.func_178210_d() == this.dir.func_176734_d() || quad.func_178210_d() == this.dir.func_176746_e()) {
                Direction fakeDir = quad.func_178210_d() == this.dir.func_176734_d() ? this.dir.func_176735_f() : this.dir;
                BakedQuad finalQuad = quad;
                builder.add((Object)ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> FramedSlopeModel.createSideTriangle(finalQuad, pos, uv, light, fakeDir, this.top ? SlopeType.TOP : SlopeType.BOTTOM)));
                continue;
            }
            builder.add((Object)quad);
        }
        return builder.build();
    }

    public static void createSlopeTriangle(float[][] pos, float[][] uv, float[][] light, Direction dir, boolean top) {
        if (top) {
            float mid;
            switch (dir) {
                case NORTH: {
                    pos[0][0] = 1.0f;
                    pos[0][2] = 1.0f;
                    pos[3][0] = 1.0f;
                    pos[3][2] = 1.0f;
                    break;
                }
                case EAST: {
                    pos[0][0] = 0.0f;
                    pos[0][2] = 1.0f;
                    pos[3][0] = 0.0f;
                    pos[3][2] = 1.0f;
                    break;
                }
                case SOUTH: {
                    pos[0][0] = 0.0f;
                    pos[0][2] = 0.0f;
                    pos[3][0] = 0.0f;
                    pos[3][2] = 0.0f;
                    break;
                }
                case WEST: {
                    pos[0][0] = 1.0f;
                    pos[0][2] = 0.0f;
                    pos[3][0] = 1.0f;
                    pos[3][2] = 0.0f;
                }
            }
            float min = uv[0][0];
            float max = uv[3][0];
            uv[0][0] = mid = min + (max - min) / 2.0f;
            uv[3][0] = mid;
            min = light[0][0];
            max = light[3][0];
            light[0][0] = mid = min + (max - min) / 2.0f;
            light[3][0] = mid;
        } else {
            float mid;
            switch (dir) {
                case NORTH: {
                    pos[1][0] = 1.0f;
                    pos[1][2] = 1.0f;
                    pos[2][0] = 1.0f;
                    pos[2][2] = 1.0f;
                    break;
                }
                case EAST: {
                    pos[1][0] = 0.0f;
                    pos[1][2] = 1.0f;
                    pos[2][0] = 0.0f;
                    pos[2][2] = 1.0f;
                    break;
                }
                case SOUTH: {
                    pos[1][0] = 0.0f;
                    pos[1][2] = 0.0f;
                    pos[2][0] = 0.0f;
                    pos[2][2] = 0.0f;
                    break;
                }
                case WEST: {
                    pos[1][0] = 1.0f;
                    pos[1][2] = 0.0f;
                    pos[2][0] = 1.0f;
                    pos[2][2] = 0.0f;
                }
            }
            float min = uv[1][0];
            float max = uv[2][0];
            uv[1][0] = mid = min + (max - min) / 2.0f;
            uv[2][0] = mid;
            min = light[1][0];
            max = light[2][0];
            light[1][0] = mid = min + (max - min) / 2.0f;
            light[2][0] = mid;
        }
    }
}

