/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.Direction;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.model.FramedSlopeModel;
import xfacthd.framedblocks.client.model.FramedThreewayCornerModel;
import xfacthd.framedblocks.client.util.ModelUtils;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.SlopeType;

public class FramedInnerThreewayCornerModel
extends FramedBlockModel {
    private final Direction dir;
    private final boolean top;

    public FramedInnerThreewayCornerModel(IBakedModel baseModel, Direction dir, boolean top) {
        super(BlockType.FRAMED_INNER_THREEWAY_CORNER, baseModel);
        this.dir = dir;
        this.top = top;
    }

    @Override
    protected ImmutableList<BakedQuad> prepareBaseQuads(BlockState state, Random rand) {
        ImmutableList.Builder builder = ImmutableList.builder();
        List<BakedQuad> quads = FramedInnerThreewayCornerModel.getAllQuads(this.baseModel, state, new Random());
        ArrayList<BakedQuad> modifiedQuads = new ArrayList<BakedQuad>();
        ListIterator<BakedQuad> quadIterator = quads.listIterator();
        while (quadIterator.hasNext()) {
            BakedQuad finalQuad;
            BakedQuad quad = (BakedQuad)quadIterator.next();
            if (ModelUtils.isFacingTowards(quad, this.dir.func_176734_d()) && ModelUtils.isFacingTowards(quad, this.dir.func_176735_f())) {
                quadIterator.remove();
                finalQuad = quad;
                modifiedQuads.add(ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> FramedThreewayCornerModel.createVerticalSlopeTriangle(finalQuad, pos, uv, !this.top)));
                continue;
            }
            if (FramedInnerThreewayCornerModel.isHorSlopeQuad(quad, this.dir, this.top)) {
                quadIterator.remove();
                Direction quadFace = ModelUtils.isFacingTowards(quad, this.dir.func_176734_d()) ? this.dir.func_176734_d() : this.dir.func_176735_f();
                BakedQuad finalQuad2 = quad = new BakedQuad(quad.func_178209_a(), quad.func_178211_c(), quadFace, quad.func_187508_a(), quad.shouldApplyDiffuseLighting());
                modifiedQuads.add(ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> FramedInnerThreewayCornerModel.createSlopeTriangle(finalQuad2, pos, uv, this.dir)));
                continue;
            }
            if (this.top && quad.func_178210_d() == Direction.DOWN || !this.top && quad.func_178210_d() == Direction.UP) {
                quadIterator.remove();
                finalQuad = quad;
                modifiedQuads.add(ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> FramedSlopeModel.createTopBottomTriangle(finalQuad, pos, uv, light, this.dir.func_176746_e())));
                continue;
            }
            if (quad.func_178210_d() != this.dir.func_176734_d() && quad.func_178210_d() != this.dir.func_176735_f()) continue;
            quadIterator.remove();
            finalQuad = quad;
            modifiedQuads.add(ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> {
                Direction fakeDir = finalQuad.func_178210_d() == this.dir.func_176734_d() ? this.dir.func_176746_e() : this.dir;
                SlopeType fakeType = this.top ? SlopeType.TOP : SlopeType.BOTTOM;
                FramedSlopeModel.createSideTriangle(finalQuad, pos, uv, light, fakeDir, fakeType);
            }));
        }
        builder.addAll(quads);
        builder.addAll(modifiedQuads);
        return builder.build();
    }

    private static boolean isHorSlopeQuad(BakedQuad quad, Direction dir, boolean top) {
        if (top && !ModelUtils.isFacingTowards(quad, Direction.DOWN)) {
            return false;
        }
        if (!top && !ModelUtils.isFacingTowards(quad, Direction.UP)) {
            return false;
        }
        return ModelUtils.isFacingTowards(quad, dir.func_176734_d()) || ModelUtils.isFacingTowards(quad, dir.func_176735_f());
    }

    private static void createSlopeTriangle(BakedQuad quad, float[][] pos, float[][] uv, Direction dir) {
        boolean xDir = dir.func_176740_k() == Direction.Axis.X;
        boolean xFace = ModelUtils.isFacingTowards(quad, Direction.EAST) || ModelUtils.isFacingTowards(quad, Direction.WEST);
        int coord1 = xFace == xDir ? 2 : 0;
        boolean topCWFace = ModelUtils.isFacingTowards(quad, dir.func_176735_f());
        int coord2 = topCWFace ? 1 : 3;
        pos[coord1][0] = 0.5f;
        pos[coord2][0] = 0.5f;
        pos[coord1][1] = 0.5f;
        pos[coord2][1] = 0.5f;
        pos[coord1][2] = 0.5f;
        pos[coord2][2] = 0.5f;
        uv[coord1][0] = quad.func_187508_a().func_94214_a(8.0);
        uv[coord2][0] = quad.func_187508_a().func_94214_a(8.0);
        uv[coord1][1] = quad.func_187508_a().func_94207_b(8.0);
        uv[coord2][1] = quad.func_187508_a().func_94207_b(8.0);
    }
}

