/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.Direction;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.util.ModelUtils;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.SlopeType;

public class FramedSlopeModel
extends FramedBlockModel {
    private final Direction dir;
    private final SlopeType type;

    public FramedSlopeModel(IBakedModel baseModel, Direction dir, SlopeType type) {
        super(BlockType.FRAMED_SLOPE, baseModel);
        this.dir = dir;
        this.type = type;
    }

    @Override
    protected ImmutableList<BakedQuad> prepareBaseQuads(BlockState state, Random rand) {
        ImmutableList.Builder builder = ImmutableList.builder();
        List<BakedQuad> quads = FramedSlopeModel.getAllQuads(this.baseModel, state, new Random());
        ArrayList<BakedQuad> modifiedQuads = new ArrayList<BakedQuad>();
        ListIterator<BakedQuad> quadIterator = quads.listIterator();
        while (quadIterator.hasNext()) {
            BakedQuad quad = (BakedQuad)quadIterator.next();
            if (this.type == SlopeType.HORIZONTAL) {
                if (quad.func_178210_d() != Direction.UP && quad.func_178210_d() != Direction.DOWN) continue;
                quadIterator.remove();
                modifiedQuads.add(ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> FramedSlopeModel.createTopBottomTriangle(quad, pos, uv, light, this.dir)));
                continue;
            }
            if (quad.func_178210_d() == this.dir.func_176746_e() || quad.func_178210_d() == this.dir.func_176735_f()) {
                quadIterator.remove();
                modifiedQuads.add(ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> FramedSlopeModel.createSideTriangle(quad, pos, uv, light, this.dir, this.type)));
                continue;
            }
            if ((this.type != SlopeType.TOP || quad.func_178210_d() != Direction.DOWN) && (this.type != SlopeType.BOTTOM || quad.func_178210_d() != Direction.UP)) continue;
            quadIterator.remove();
            modifiedQuads.add(new BakedQuad(quad.func_178209_a(), quad.func_178211_c(), this.dir.func_176734_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting()));
        }
        builder.addAll(quads);
        builder.addAll(modifiedQuads);
        return builder.build();
    }

    public static void createSideTriangle(BakedQuad quad, float[][] pos, float[][] uv, float[][] light, Direction dir, SlopeType type) {
        if (quad.func_178210_d() == dir.func_176746_e()) {
            if (type == SlopeType.TOP) {
                pos[1][1] = pos[0][1];
                uv[1][1] = uv[0][1];
                light[1][1] = light[0][1];
            } else if (type == SlopeType.BOTTOM) {
                pos[0][1] = pos[1][1];
                uv[0][1] = uv[1][1];
                light[0][1] = light[1][1];
            }
        } else if (quad.func_178210_d() == dir.func_176735_f()) {
            if (type == SlopeType.TOP) {
                pos[2][1] = pos[3][1];
                uv[2][1] = uv[3][1];
                light[2][1] = light[3][1];
            } else if (type == SlopeType.BOTTOM) {
                pos[3][1] = pos[2][1];
                uv[3][1] = uv[2][1];
                light[3][1] = light[2][1];
            }
        }
    }

    public static void createTopBottomTriangle(BakedQuad quad, float[][] pos, float[][] uv, float[][] light, Direction dir) {
        if (quad.func_178210_d() == Direction.UP) {
            int posIdx = dir.func_176740_k() == Direction.Axis.X ? 2 : 0;
            int uvIdx = dir.func_176740_k() == Direction.Axis.X ? 0 : 0;
            int fromIdx = dir.func_176740_k() == Direction.Axis.X ? (dir.func_176736_b() + 2) % 4 : dir.func_176736_b();
            int toIdx = dir.func_176740_k() == Direction.Axis.X ? (dir.func_176736_b() + 1) % 4 : (dir.func_176736_b() + 2) % 4;
            pos[fromIdx][posIdx] = pos[toIdx][posIdx];
            uv[fromIdx][uvIdx] = uv[toIdx][uvIdx];
            light[fromIdx][uvIdx] = light[toIdx][uvIdx];
        } else {
            int posIdx = dir.func_176740_k() == Direction.Axis.X ? 2 : 0;
            int uvIdx = dir.func_176740_k() == Direction.Axis.X ? 1 : 0;
            int fromIdx = (dir.func_176736_b() + 1) % 4;
            int toIdx = (dir.func_176736_b() + 2) % 4;
            pos[fromIdx][posIdx] = pos[toIdx][posIdx];
            uv[fromIdx][uvIdx] = uv[toIdx][uvIdx];
            light[fromIdx][uvIdx] = light[toIdx][uvIdx];
        }
    }
}

