/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.Direction;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.model.FramedSlopeModel;
import xfacthd.framedblocks.client.util.ModelUtils;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.SlopeType;

public class FramedThreewayCornerModel
extends FramedBlockModel {
    private final Direction dir;
    private final boolean top;

    public FramedThreewayCornerModel(IBakedModel baseModel, Direction dir, boolean top) {
        super(BlockType.FRAMED_THREEWAY_CORNER, baseModel);
        this.dir = dir;
        this.top = top;
    }

    @Override
    protected ImmutableList<BakedQuad> prepareBaseQuads(BlockState state, Random rand) {
        ImmutableList.Builder builder = ImmutableList.builder();
        List<BakedQuad> quads = FramedThreewayCornerModel.getAllQuads(this.baseModel, state, new Random());
        for (BakedQuad quad : quads) {
            BakedQuad finalQuad;
            if (ModelUtils.isFacingTowards(quad, this.dir.func_176734_d()) && ModelUtils.isFacingTowards(quad, this.dir.func_176746_e())) {
                finalQuad = quad;
                builder.add((Object)ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> FramedThreewayCornerModel.createVerticalSlopeTriangle(finalQuad, pos, uv, this.top)));
                continue;
            }
            if (this.top && ModelUtils.isFacingTowards(quad, Direction.DOWN) || !this.top && ModelUtils.isFacingTowards(quad, Direction.UP)) {
                Direction quadFace = ModelUtils.isFacingTowards(quad, this.dir.func_176734_d()) ? this.dir.func_176734_d() : this.dir.func_176746_e();
                BakedQuad finalQuad2 = quad = new BakedQuad(quad.func_178209_a(), quad.func_178211_c(), quadFace, quad.func_187508_a(), quad.shouldApplyDiffuseLighting());
                builder.add((Object)ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> FramedThreewayCornerModel.createSlopeTriangle(finalQuad2, pos, uv, this.dir, this.top)));
                continue;
            }
            if (quad.func_178210_d() == this.dir || quad.func_178210_d() == this.dir.func_176735_f()) {
                finalQuad = quad;
                builder.add((Object)ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> {
                    Direction fakeDir = finalQuad.func_178210_d() == this.dir.func_176735_f() ? this.dir : this.dir.func_176735_f();
                    SlopeType fakeType = this.top ? SlopeType.TOP : SlopeType.BOTTOM;
                    FramedSlopeModel.createSideTriangle(finalQuad, pos, uv, light, fakeDir, fakeType);
                }));
                continue;
            }
            if (!this.top && quad.func_178210_d() == Direction.DOWN) {
                finalQuad = quad;
                builder.add((Object)ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> FramedSlopeModel.createTopBottomTriangle(finalQuad, pos, uv, light, this.dir)));
                continue;
            }
            if (!this.top || quad.func_178210_d() != Direction.UP) continue;
            finalQuad = quad;
            builder.add((Object)ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> FramedSlopeModel.createTopBottomTriangle(finalQuad, pos, uv, light, Direction.SOUTH)));
        }
        return builder.build();
    }

    public static void createVerticalSlopeTriangle(BakedQuad quad, float[][] pos, float[][] uv, boolean top) {
        if (top) {
            pos[1][0] = 0.5f;
            pos[2][0] = 0.5f;
            pos[1][1] = 0.5f;
            pos[2][1] = 0.5f;
            pos[1][2] = 0.5f;
            pos[2][2] = 0.5f;
            uv[1][0] = quad.func_187508_a().func_94214_a(8.0);
            uv[2][0] = quad.func_187508_a().func_94214_a(8.0);
            uv[1][1] = quad.func_187508_a().func_94207_b(8.0);
            uv[2][1] = quad.func_187508_a().func_94207_b(8.0);
        } else {
            pos[0][0] = 0.5f;
            pos[3][0] = 0.5f;
            pos[0][1] = 0.5f;
            pos[3][1] = 0.5f;
            pos[0][2] = 0.5f;
            pos[3][2] = 0.5f;
            uv[0][0] = quad.func_187508_a().func_94214_a(8.0);
            uv[3][0] = quad.func_187508_a().func_94214_a(8.0);
            uv[0][1] = quad.func_187508_a().func_94207_b(8.0);
            uv[3][1] = quad.func_187508_a().func_94207_b(8.0);
        }
    }

    private static void createSlopeTriangle(BakedQuad quad, float[][] pos, float[][] uv, Direction dir, boolean top) {
        int coord2;
        boolean xDir = dir.func_176740_k() == Direction.Axis.X;
        boolean xFace = ModelUtils.isFacingTowards(quad, Direction.EAST) || ModelUtils.isFacingTowards(quad, Direction.WEST);
        int coord1 = xFace == xDir ? 2 : 0;
        boolean topCWFace = top && ModelUtils.isFacingTowards(quad, dir.func_176746_e());
        int n = coord2 = topCWFace ? 1 : 3;
        if (!top && xDir && !xFace) {
            ModelUtils.rotateElement(uv, ModelUtils.isFacingTowards(quad, Direction.SOUTH), 1);
        } else if (!top && dir == Direction.SOUTH && ModelUtils.isFacingTowards(quad, Direction.WEST)) {
            ModelUtils.rotateElement(uv, true, 2);
        }
        pos[coord1][0] = 0.5f;
        pos[coord2][0] = 0.5f;
        pos[coord1][1] = 0.5f;
        pos[coord2][1] = 0.5f;
        pos[coord1][2] = 0.5f;
        pos[coord2][2] = 0.5f;
        uv[coord1][0] = quad.func_187508_a().func_94214_a(8.0);
        uv[coord2][0] = quad.func_187508_a().func_94214_a(8.0);
        uv[coord1][1] = quad.func_187508_a().func_94207_b(8.0);
        uv[coord2][1] = quad.func_187508_a().func_94207_b(8.0);
    }
}

