/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.screen;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.RenderComponentsUtil;
import net.minecraft.client.gui.fonts.TextInputUtil;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.net.SignUpdatePacket;
import xfacthd.framedblocks.common.tileentity.FramedSignTileEntity;

@Mod.EventBusSubscriber(modid="framedblocks", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class FramedSignScreen
extends Screen {
    private static final Table<BlockState, Direction, TextureAtlasSprite> SPRITE_CACHE = HashBasedTable.create();
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("framedblocks", "block/framed_block");
    private final FramedSignTileEntity sign;
    private int blinkCounter = 0;
    private int currLine = 0;
    private TextInputUtil inputUtil;

    public FramedSignScreen(FramedSignTileEntity sign) {
        super((ITextComponent)new TranslationTextComponent("sign.edit", new Object[0]));
        this.sign = sign;
    }

    protected void init() {
        this.minecraft.field_195559_v.func_197967_a(true);
        this.addButton((Widget)new Button(this.width / 2 - 100, this.height / 4 + 120, 200, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), btn -> this.onClose()));
        this.inputUtil = new TextInputUtil(this.minecraft, () -> this.sign.getLine(this.currLine).getString(), newLine -> this.sign.setLine(this.currLine, (ITextComponent)new StringTextComponent(newLine)), 90);
    }

    public void removed() {
        this.minecraft.field_195559_v.func_197967_a(false);
        FramedBlocks.CHANNEL.sendToServer((Object)new SignUpdatePacket(this.sign.func_174877_v(), new String[]{this.sign.getLine(0).getString(), this.sign.getLine(1).getString(), this.sign.getLine(2).getString(), this.sign.getLine(3).getString()}));
    }

    public void tick() {
        ++this.blinkCounter;
        if (!this.sign.func_200662_C().func_223045_a(this.sign.func_195044_w().func_177230_c())) {
            this.onClose();
        }
    }

    public boolean charTyped(char character, int modifiers) {
        this.inputUtil.func_216894_a(character);
        return true;
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (key == 265) {
            this.currLine = this.currLine - 1 & 3;
            this.inputUtil.func_216899_b();
            return true;
        }
        if (key == 264 || key == 257 || key == 335) {
            this.currLine = this.currLine + 1 & 3;
            this.inputUtil.func_216899_b();
            return true;
        }
        return this.inputUtil.func_216897_a(key) || super.keyPressed(key, scanCode, modifiers);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        RenderHelper.func_227783_c_();
        this.renderBackground();
        this.drawCenteredString(this.font, this.title.func_150254_d(), this.width / 2, 40, TextFormatting.WHITE.func_211163_e());
        this.minecraft.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        TextureAtlasSprite sprite = this.getFrontSprite();
        int w = 128;
        int h = 64;
        int x = this.width / 2 - w / 2;
        int y = this.height / 2 - h / 2 - 20;
        FramedSignScreen.innerBlit((int)x, (int)(x + w), (int)y, (int)(y + h), (int)this.getBlitOffset(), (float)sprite.func_94209_e(), (float)sprite.func_94212_f(), (float)sprite.func_94207_b(4.0), (float)sprite.func_94207_b(12.0));
        String[] lines = new String[4];
        for (int line = 0; line < lines.length; ++line) {
            lines[line] = this.sign.getRenderedLine(line, component -> {
                List parts = RenderComponentsUtil.func_178908_a((ITextComponent)component, (int)90, (FontRenderer)this.minecraft.field_71466_p, (boolean)false, (boolean)true);
                return parts.isEmpty() ? "" : ((ITextComponent)parts.get(0)).func_150254_d();
            });
        }
        MatrixStack stack = new MatrixStack();
        stack.func_227861_a_((double)this.width / 2.0, (double)this.height / 2.0 - 20.0, (double)this.getBlitOffset());
        stack.func_227862_a_(1.2f, 1.2f, 1.0f);
        Matrix4f matrix = stack.func_227866_c_().func_227870_a_();
        IRenderTypeBuffer.Impl buffer = this.minecraft.func_228019_au_().func_228487_b_();
        this.drawLines(matrix, buffer, lines);
        this.drawCursor(matrix, buffer, lines);
        RenderHelper.func_227784_d_();
        super.render(mouseX, mouseY, partialTicks);
    }

    private void drawLines(Matrix4f matrix, IRenderTypeBuffer.Impl buffer, String[] lines) {
        int color = this.sign.getTextColor().func_218388_g();
        for (int line = 0; line < lines.length; ++line) {
            String text = lines[line];
            if (text == null) continue;
            float textX = (float)(-this.font.func_78256_a(text)) / 2.0f;
            this.font.func_228079_a_(text, textX, (float)(line * 10 - 20), color, false, matrix, (IRenderTypeBuffer)buffer, false, 0, 0xF000F0);
        }
        buffer.func_228461_a_();
    }

    private void drawCursor(Matrix4f matrix, IRenderTypeBuffer.Impl buffer, String[] lines) {
        int color = this.sign.getTextColor().func_218388_g();
        boolean blink = this.blinkCounter / 6 % 2 == 0;
        int dir = this.font.func_78260_a() ? -1 : 1;
        int y = this.currLine * 10 - 20;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line == null || i != this.currLine || this.inputUtil.func_216896_c() < 0) continue;
            int hw = this.font.func_78256_a(line) / 2;
            int selectionEnd = this.font.func_78256_a(line.substring(0, Math.max(Math.min(this.inputUtil.func_216896_c(), line.length()), 0)));
            int cursorX = (selectionEnd - hw) * dir;
            if (blink) {
                if (this.inputUtil.func_216896_c() < line.length()) {
                    FramedSignScreen.fill((Matrix4f)matrix, (int)cursorX, (int)(y - 1), (int)(cursorX + 1), (int)(y + 9), (int)(0xFF000000 | color));
                } else {
                    this.font.func_228079_a_("_", (float)cursorX, (float)y, color, false, matrix, (IRenderTypeBuffer)buffer, false, 0, 0xF000F0);
                    buffer.func_228461_a_();
                }
            }
            if (this.inputUtil.func_216898_d() == this.inputUtil.func_216896_c()) continue;
            int x1 = (this.font.func_78256_a(line.substring(0, this.inputUtil.func_216898_d())) - hw) * dir;
            int x2 = (this.font.func_78256_a(line.substring(0, this.inputUtil.func_216896_c())) - hw) * dir;
            int xStart = Math.min(x1, x2);
            int xEnd = Math.max(x1, x2);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder tessBuffer = tessellator.func_178180_c();
            RenderSystem.disableTexture();
            RenderSystem.enableColorLogicOp();
            RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
            tessBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            tessBuffer.func_227888_a_(matrix, (float)xStart, (float)y + 9.0f, 0.0f).func_225586_a_(0, 0, 255, 255).func_181675_d();
            tessBuffer.func_227888_a_(matrix, (float)xEnd, (float)y + 9.0f, 0.0f).func_225586_a_(0, 0, 255, 255).func_181675_d();
            tessBuffer.func_227888_a_(matrix, (float)xEnd, (float)y - 1.0f, 0.0f).func_225586_a_(0, 0, 255, 255).func_181675_d();
            tessBuffer.func_227888_a_(matrix, (float)xStart, (float)y - 1.0f, 0.0f).func_225586_a_(0, 0, 255, 255).func_181675_d();
            tessBuffer.func_178977_d();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)tessBuffer);
            RenderSystem.disableColorLogicOp();
            RenderSystem.enableTexture();
        }
    }

    private TextureAtlasSprite getFrontSprite() {
        Direction front;
        BlockState state = this.sign.func_195044_w();
        if (state.func_177230_c() == FBContent.blockFramedWallSign) {
            front = (Direction)state.func_177229_b((IProperty)PropertyHolder.FACING_HOR);
        } else {
            int rot = (Integer)state.func_177229_b((IProperty)BlockStateProperties.field_208138_am);
            double angle = (double)rot * 360.0 / 16.0;
            front = Direction.func_176733_a((double)angle);
        }
        BlockState camoState = this.sign.getCamoState();
        if (camoState == Blocks.field_150350_a.func_176223_P()) {
            camoState = FBContent.blockFramedCube.func_176223_P();
        }
        if (!SPRITE_CACHE.contains((Object)camoState, (Object)front)) {
            IBakedModel model = this.minecraft.func_175602_ab().func_184389_a(camoState);
            List quads = model.getQuads(camoState, front, this.minecraft.field_71441_e.func_201674_k(), (IModelData)EmptyModelData.INSTANCE);
            TextureAtlasSprite sprite = !quads.isEmpty() ? ((BakedQuad)quads.get(0)).func_187508_a() : (TextureAtlasSprite)this.minecraft.func_228015_a_(AtlasTexture.field_110575_b).apply(DEFAULT_TEXTURE);
            SPRITE_CACHE.put((Object)camoState, (Object)front, (Object)sprite);
        }
        return (TextureAtlasSprite)SPRITE_CACHE.get((Object)camoState, (Object)front);
    }

    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        SPRITE_CACHE.clear();
    }
}

