/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.CornerType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.SlopeType;

@Mod.EventBusSubscriber(modid="framedblocks", value={Dist.CLIENT})
public class ClientEventHandler {
    @SubscribeEvent
    public static void onRenderBlockHighlight(DrawHighlightEvent.HighlightBlock event) {
        BlockRayTraceResult result = event.getTarget();
        BlockState state = Minecraft.func_71410_x().field_71441_e.func_180495_p(result.func_216350_a());
        if (!(state.func_177230_c() instanceof FramedBlock)) {
            return;
        }
        BlockType type = ((FramedBlock)state.func_177230_c()).getBlockType();
        if (type.hasSpecialHitbox()) {
            MatrixStack mstack = event.getMatrix();
            Vec3d offset = new Vec3d((Vec3i)result.func_216350_a()).func_178788_d(event.getInfo().func_216785_c());
            IVertexBuilder builder = event.getBuffers().getBuffer(RenderType.func_228659_m_());
            Direction dir = (Direction)state.func_177229_b((IProperty)PropertyHolder.FACING_HOR);
            mstack.func_227860_a_();
            mstack.func_227861_a_(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
            mstack.func_227861_a_(0.5, 0.5, 0.5);
            mstack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-dir.func_185119_l()));
            mstack.func_227861_a_(-0.5, -0.5, -0.5);
            switch (type) {
                case FRAMED_SLOPE: {
                    ClientEventHandler.drawSlopeBox(state, mstack, builder);
                    break;
                }
                case FRAMED_CORNER_SLOPE: {
                    ClientEventHandler.drawCornerSlopeBox(state, mstack, builder);
                    break;
                }
                case FRAMED_INNER_CORNER_SLOPE: {
                    ClientEventHandler.drawInnerCornerSlopeBox(state, mstack, builder);
                    break;
                }
                case FRAMED_PRISM_CORNER: {
                    ClientEventHandler.drawPrismCornerBox(state, mstack, builder);
                    break;
                }
                case FRAMED_INNER_PRISM_CORNER: {
                    ClientEventHandler.drawInnerPrismCornerBox(state, mstack, builder);
                    break;
                }
                case FRAMED_THREEWAY_CORNER: {
                    ClientEventHandler.drawThreewayCornerBox(state, mstack, builder);
                    break;
                }
                case FRAMED_INNER_THREEWAY_CORNER: {
                    ClientEventHandler.drawInnerThreewayCornerBox(state, mstack, builder);
                }
            }
            mstack.func_227865_b_();
            event.setCanceled(true);
        }
    }

    private static void drawSlopeBox(BlockState state, MatrixStack mstack, IVertexBuilder builder) {
        SlopeType type = (SlopeType)((Object)state.func_177229_b(PropertyHolder.SLOPE_TYPE));
        if (type != SlopeType.HORIZONTAL) {
            if (type == SlopeType.TOP) {
                mstack.func_227861_a_(0.5, 0.5, 0.5);
                mstack.func_227862_a_(1.0f, -1.0f, 1.0f);
                mstack.func_227861_a_(-0.5, -0.5, -0.5);
            }
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        } else {
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 1.0, 0.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0);
        }
    }

    private static void drawCornerSlopeBox(BlockState state, MatrixStack mstack, IVertexBuilder builder) {
        CornerType type = (CornerType)((Object)state.func_177229_b(PropertyHolder.CORNER_TYPE));
        if (!type.isHorizontal()) {
            if (type.isTop()) {
                mstack.func_227861_a_(0.5, 0.5, 0.5);
                mstack.func_227862_a_(1.0f, -1.0f, 1.0f);
                mstack.func_227861_a_(-0.5, -0.5, -0.5);
            }
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0);
        } else {
            mstack.func_227861_a_(0.5, 0.5, 0.5);
            if (!type.isRight()) {
                mstack.func_227862_a_(-1.0f, 1.0f, 1.0f);
            }
            if (type.isTop()) {
                mstack.func_227862_a_(1.0f, -1.0f, 1.0f);
            }
            mstack.func_227861_a_(-0.5, -0.5, -0.5);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0);
        }
    }

    private static void drawInnerCornerSlopeBox(BlockState state, MatrixStack mstack, IVertexBuilder builder) {
        CornerType type = (CornerType)((Object)state.func_177229_b(PropertyHolder.CORNER_TYPE));
        if (!type.isHorizontal()) {
            mstack.func_227861_a_(0.5, 0.5, 0.5);
            if (type.isTop()) {
                mstack.func_227862_a_(1.0f, -1.0f, 1.0f);
            }
            mstack.func_227861_a_(-0.5, -0.5, -0.5);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0);
        } else {
            mstack.func_227861_a_(0.5, 0.5, 0.5);
            if (!type.isRight()) {
                mstack.func_227862_a_(-1.0f, 1.0f, 1.0f);
            }
            if (type.isTop()) {
                mstack.func_227862_a_(1.0f, -1.0f, 1.0f);
            }
            mstack.func_227861_a_(-0.5, -0.5, -0.5);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
    }

    private static void drawPrismCornerBox(BlockState state, MatrixStack mstack, IVertexBuilder builder) {
        boolean top = (Boolean)state.func_177229_b((IProperty)PropertyHolder.TOP);
        mstack.func_227861_a_(0.5, 0.5, 0.5);
        if (top) {
            mstack.func_227862_a_(1.0f, -1.0f, 1.0f);
        }
        mstack.func_227861_a_(-0.5, -0.5, -0.5);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0);
    }

    private static void drawInnerPrismCornerBox(BlockState state, MatrixStack mstack, IVertexBuilder builder) {
        boolean top = (Boolean)state.func_177229_b((IProperty)PropertyHolder.TOP);
        mstack.func_227861_a_(0.5, 0.5, 0.5);
        if (top) {
            mstack.func_227862_a_(1.0f, -1.0f, 1.0f);
        }
        mstack.func_227861_a_(-0.5, -0.5, -0.5);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 1.0, 0.0, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0);
    }

    private static void drawThreewayCornerBox(BlockState state, MatrixStack mstack, IVertexBuilder builder) {
        boolean top = (Boolean)state.func_177229_b((IProperty)PropertyHolder.TOP);
        mstack.func_227861_a_(0.5, 0.5, 0.5);
        if (top) {
            mstack.func_227862_a_(1.0f, -1.0f, 1.0f);
        }
        mstack.func_227861_a_(-0.5, -0.5, -0.5);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 0.5, 0.5, 0.5);
        ClientEventHandler.drawLine(builder, mstack, 0.5, 0.5, 0.5, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.5, 0.5, 0.5);
    }

    private static void drawInnerThreewayCornerBox(BlockState state, MatrixStack mstack, IVertexBuilder builder) {
        boolean top = (Boolean)state.func_177229_b((IProperty)PropertyHolder.TOP);
        mstack.func_227861_a_(0.5, 0.5, 0.5);
        if (top) {
            mstack.func_227862_a_(1.0f, -1.0f, 1.0f);
        }
        mstack.func_227861_a_(-0.5, -0.5, -0.5);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 0.5, 0.5, 0.5);
        ClientEventHandler.drawLine(builder, mstack, 0.5, 0.5, 0.5, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 0.0, 0.5, 0.5, 0.5);
    }

    private static void drawLine(IVertexBuilder builder, MatrixStack mstack, double x1, double y1, double z1, double x2, double y2, double z2) {
        builder.func_227888_a_(mstack.func_227866_c_().func_227870_a_(), (float)x1, (float)y1, (float)z1).func_227885_a_(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
        builder.func_227888_a_(mstack.func_227866_c_().func_227870_a_(), (float)x2, (float)y2, (float)z2).func_227885_a_(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
    }
}

