/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.util;

import java.util.Arrays;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class ModelUtils {
    public static BakedQuad modifyQuad(BakedQuad quad, VertexDataConsumer consumer) {
        int vert;
        int elemPos = ModelUtils.findElement(VertexFormatElement.Usage.POSITION, 0);
        int elemColor = ModelUtils.findElement(VertexFormatElement.Usage.COLOR, 0);
        int elemUV = ModelUtils.findElement(VertexFormatElement.Usage.UV, 0);
        int elemLight = ModelUtils.findElement(VertexFormatElement.Usage.UV, 2);
        int elemNormal = ModelUtils.findElement(VertexFormatElement.Usage.NORMAL, 0);
        int[] vertexData = quad.func_178209_a();
        float[][] pos = new float[4][3];
        float[][] color = new float[4][4];
        float[][] uv = new float[4][2];
        float[][] light = new float[4][2];
        float[][] normal = new float[4][3];
        for (vert = 0; vert < 4; ++vert) {
            LightUtil.unpack((int[])vertexData, (float[])pos[vert], (VertexFormat)DefaultVertexFormats.field_176600_a, (int)vert, (int)elemPos);
            LightUtil.unpack((int[])vertexData, (float[])color[vert], (VertexFormat)DefaultVertexFormats.field_176600_a, (int)vert, (int)elemColor);
            LightUtil.unpack((int[])vertexData, (float[])uv[vert], (VertexFormat)DefaultVertexFormats.field_176600_a, (int)vert, (int)elemUV);
            LightUtil.unpack((int[])vertexData, (float[])light[vert], (VertexFormat)DefaultVertexFormats.field_176600_a, (int)vert, (int)elemLight);
            LightUtil.unpack((int[])vertexData, (float[])normal[vert], (VertexFormat)DefaultVertexFormats.field_176600_a, (int)vert, (int)elemNormal);
        }
        consumer.accept(pos, color, uv, light, normal);
        for (vert = 0; vert < 4; ++vert) {
            LightUtil.pack((float[])pos[vert], (int[])vertexData, (VertexFormat)DefaultVertexFormats.field_176600_a, (int)vert, (int)elemPos);
            LightUtil.pack((float[])color[vert], (int[])vertexData, (VertexFormat)DefaultVertexFormats.field_176600_a, (int)vert, (int)elemColor);
            LightUtil.pack((float[])uv[vert], (int[])vertexData, (VertexFormat)DefaultVertexFormats.field_176600_a, (int)vert, (int)elemUV);
            LightUtil.pack((float[])light[vert], (int[])vertexData, (VertexFormat)DefaultVertexFormats.field_176600_a, (int)vert, (int)elemLight);
            LightUtil.pack((float[])normal[vert], (int[])vertexData, (VertexFormat)DefaultVertexFormats.field_176600_a, (int)vert, (int)elemNormal);
        }
        return quad;
    }

    public static float[][] unpackElement(BakedQuad quad, VertexFormatElement.Usage usage, int index) {
        int elemPos = ModelUtils.findElement(usage, index);
        float[][] data = new float[4][4];
        for (int vert = 0; vert < 4; ++vert) {
            LightUtil.unpack((int[])quad.func_178209_a(), (float[])data[vert], (VertexFormat)DefaultVertexFormats.field_176600_a, (int)vert, (int)elemPos);
        }
        return data;
    }

    public static int findElement(VertexFormatElement.Usage usage, int index) {
        int idx = 0;
        for (VertexFormatElement element : DefaultVertexFormats.field_176600_a.func_227894_c_()) {
            if (element.func_177375_c() == usage && element.func_177369_e() == index) {
                return idx;
            }
            ++idx;
        }
        throw new IllegalArgumentException("Format doesn't have a " + usage.func_177384_a() + " element");
    }

    public static BakedQuad duplicateQuad(BakedQuad quad) {
        int[] vertexData = quad.func_178209_a();
        vertexData = Arrays.copyOf(vertexData, vertexData.length);
        return new BakedQuad(vertexData, quad.func_178211_c(), quad.func_178210_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting());
    }

    public static Direction findHorizontalFacing(BakedQuad quad) {
        int[] vertexData = quad.func_178209_a();
        float[][] normal = new float[4][3];
        int elem = ModelUtils.findElement(VertexFormatElement.Usage.NORMAL, 0);
        for (int vert = 0; vert < 4; ++vert) {
            LightUtil.unpack((int[])vertexData, (float[])normal[vert], (VertexFormat)DefaultVertexFormats.field_176600_a, (int)vert, (int)elem);
        }
        float nX = normal[0][0];
        float nZ = normal[0][2];
        if (nX < 0.0f) {
            return Direction.WEST;
        }
        if (nX > 0.0f) {
            return Direction.EAST;
        }
        if (nZ < 0.0f) {
            return Direction.NORTH;
        }
        if (nZ > 0.0f) {
            return Direction.SOUTH;
        }
        return Direction.DOWN;
    }

    public static boolean isFacingTowards(BakedQuad quad, Direction dir) {
        int[] vertexData = quad.func_178209_a();
        float[][] normal = new float[4][3];
        int elem = ModelUtils.findElement(VertexFormatElement.Usage.NORMAL, 0);
        for (int vert = 0; vert < 4; ++vert) {
            LightUtil.unpack((int[])vertexData, (float[])normal[vert], (VertexFormat)DefaultVertexFormats.field_176600_a, (int)vert, (int)elem);
        }
        float nX = normal[0][0];
        float nY = normal[0][1];
        float nZ = normal[0][2];
        switch (dir) {
            case DOWN: {
                return nY < 0.0f;
            }
            case UP: {
                return nY > 0.0f;
            }
            case NORTH: {
                return nZ < 0.0f;
            }
            case SOUTH: {
                return nZ > 0.0f;
            }
            case WEST: {
                return nX < 0.0f;
            }
            case EAST: {
                return nX > 0.0f;
            }
        }
        return false;
    }

    public static void rotateElement(float[][] elem, boolean right, int count) {
        for (int i = 0; i < count; ++i) {
            float[] temp;
            if (right) {
                temp = elem[0];
                elem[0] = elem[1];
                elem[1] = elem[2];
                elem[2] = elem[3];
                elem[3] = temp;
                continue;
            }
            temp = elem[3];
            elem[3] = elem[2];
            elem[2] = elem[1];
            elem[1] = elem[0];
            elem[0] = temp;
        }
    }

    public static interface VertexDataConsumer {
        public void accept(float[][] var1, float[][] var2, float[][] var3, float[][] var4, float[][] var5);
    }
}

