/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.function.BiPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IWorldReader;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.SlopeType;
import xfacthd.framedblocks.common.util.Utils;

public class FramedSlopeBlock
extends FramedBlock {
    public static final BiPredicate<BlockState, Direction> CTM_PREDICATE = (state, dir) -> {
        SlopeType type = (SlopeType)((Object)((Object)state.func_177229_b(PropertyHolder.SLOPE_TYPE)));
        if (dir == Direction.UP && type == SlopeType.TOP) {
            return true;
        }
        if (dir == Direction.DOWN && type == SlopeType.BOTTOM) {
            return true;
        }
        if (type == SlopeType.HORIZONTAL) {
            Direction facing = (Direction)state.func_177229_b((IProperty)PropertyHolder.FACING_HOR);
            return dir == facing || dir == facing.func_176735_f();
        }
        return state.func_177229_b((IProperty)PropertyHolder.FACING_HOR) == dir;
    };

    public FramedSlopeBlock() {
        super("framed_slope", BlockType.FRAMED_SLOPE);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{PropertyHolder.FACING_HOR, PropertyHolder.SLOPE_TYPE, BlockStateProperties.field_208198_y});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = this.func_176223_P();
        Direction facing = context.func_195992_f();
        state = (BlockState)state.func_206870_a((IProperty)PropertyHolder.FACING_HOR, (Comparable)facing);
        Direction side = context.func_196000_l();
        if (side == Direction.DOWN) {
            state = (BlockState)state.func_206870_a(PropertyHolder.SLOPE_TYPE, (Comparable)((Object)SlopeType.TOP));
        } else if (side == Direction.UP) {
            state = (BlockState)state.func_206870_a(PropertyHolder.SLOPE_TYPE, (Comparable)((Object)SlopeType.BOTTOM));
        } else {
            state = (BlockState)state.func_206870_a(PropertyHolder.SLOPE_TYPE, (Comparable)((Object)SlopeType.HORIZONTAL));
            boolean xAxis = context.func_196000_l().func_176740_k() == Direction.Axis.X;
            boolean positive = context.func_196000_l().func_176735_f().func_176743_c() == Direction.AxisDirection.POSITIVE;
            double xz = xAxis ? context.func_221532_j().field_72449_c : context.func_221532_j().field_72450_a;
            xz -= Math.floor(xz);
            state = xz > 0.5 == positive ? (BlockState)state.func_206870_a((IProperty)PropertyHolder.FACING_HOR, (Comparable)side.func_176734_d().func_176746_e()) : (BlockState)state.func_206870_a((IProperty)PropertyHolder.FACING_HOR, (Comparable)side.func_176734_d());
        }
        return this.withWater(state, (IWorldReader)context.func_195991_k(), context.func_195995_a());
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape shapeBottom = VoxelShapes.func_216384_a((VoxelShape)FramedSlopeBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopeBlock.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)12.0), FramedSlopeBlock.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)8.0), FramedSlopeBlock.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0)}).func_197753_c();
        VoxelShape shapeTop = VoxelShapes.func_216384_a((VoxelShape)FramedSlopeBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)4.0), (VoxelShape[])new VoxelShape[]{FramedSlopeBlock.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0), FramedSlopeBlock.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)12.0), FramedSlopeBlock.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)}).func_197753_c();
        VoxelShape shapeHorizontal = VoxelShapes.func_216384_a((VoxelShape)FramedSlopeBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopeBlock.func_208617_a((double)4.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)12.0), FramedSlopeBlock.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)8.0), FramedSlopeBlock.func_208617_a((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0)}).func_197753_c();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            SlopeType type = (SlopeType)((Object)state.func_177229_b(PropertyHolder.SLOPE_TYPE));
            Direction dir = (Direction)state.func_177229_b((IProperty)PropertyHolder.FACING_HOR);
            if (type == SlopeType.BOTTOM) {
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shapeBottom));
                continue;
            }
            if (type == SlopeType.TOP) {
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shapeTop));
                continue;
            }
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shapeHorizontal));
        }
        return builder.build();
    }
}

