/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.function.BiPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IWorldReader;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.util.Utils;

public class FramedThreewayCornerBlock
extends FramedBlock {
    public static final BiPredicate<BlockState, Direction> CTM_PREDICATE = (state, dir) -> {
        boolean top = (Boolean)state.func_177229_b((IProperty)PropertyHolder.TOP);
        if (top && dir == Direction.UP) {
            return true;
        }
        if (!top && dir == Direction.DOWN) {
            return true;
        }
        Direction facing = (Direction)state.func_177229_b((IProperty)PropertyHolder.FACING_HOR);
        if (facing == dir) {
            return true;
        }
        BlockType type = ((FramedBlock)state.func_177230_c()).getBlockType();
        if (type == BlockType.FRAMED_INNER_PRISM_CORNER) {
            return facing.func_176735_f() == dir;
        }
        return facing.func_176746_e() == dir;
    };

    public FramedThreewayCornerBlock(String name, BlockType type) {
        super(name, type);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{PropertyHolder.FACING_HOR, PropertyHolder.TOP, BlockStateProperties.field_208198_y});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = this.func_176223_P();
        Direction facing = context.func_195992_f();
        state = (BlockState)state.func_206870_a((IProperty)PropertyHolder.FACING_HOR, (Comparable)facing);
        state = this.withWater(state, (IWorldReader)context.func_195991_k(), context.func_195995_a());
        return this.withTop(state, context.func_196000_l(), context.func_221532_j());
    }

    public static ImmutableMap<BlockState, VoxelShape> generatePrismShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.func_177229_b((IProperty)PropertyHolder.FACING_HOR);
            if (((Boolean)state.func_177229_b((IProperty)PropertyHolder.TOP)).booleanValue()) {
                VoxelShape shapeTop = VoxelShapes.func_216384_a((VoxelShape)FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0), FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)4.0, (double)8.0, (double)8.0), FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)4.0, (double)4.0), FramedThreewayCornerBlock.func_208617_a((double)4.0, (double)12.0, (double)0.0, (double)8.0, (double)16.0, (double)12.0), FramedThreewayCornerBlock.func_208617_a((double)4.0, (double)8.0, (double)0.0, (double)8.0, (double)12.0, (double)8.0), FramedThreewayCornerBlock.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)8.0, (double)8.0, (double)4.0), FramedThreewayCornerBlock.func_208617_a((double)8.0, (double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)8.0), FramedThreewayCornerBlock.func_208617_a((double)8.0, (double)8.0, (double)0.0, (double)12.0, (double)12.0, (double)4.0), FramedThreewayCornerBlock.func_208617_a((double)12.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0)}).func_197753_c();
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shapeTop));
                continue;
            }
            VoxelShape shapeBottom = VoxelShapes.func_216384_a((VoxelShape)FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)4.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)4.0, (double)8.0, (double)12.0), FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0), FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0), FramedThreewayCornerBlock.func_208617_a((double)4.0, (double)0.0, (double)0.0, (double)8.0, (double)4.0, (double)12.0), FramedThreewayCornerBlock.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0), FramedThreewayCornerBlock.func_208617_a((double)4.0, (double)8.0, (double)0.0, (double)8.0, (double)12.0, (double)4.0), FramedThreewayCornerBlock.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)8.0), FramedThreewayCornerBlock.func_208617_a((double)8.0, (double)4.0, (double)0.0, (double)12.0, (double)8.0, (double)4.0), FramedThreewayCornerBlock.func_208617_a((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)4.0)}).func_197753_c();
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shapeBottom));
        }
        return builder.build();
    }

    public static ImmutableMap<BlockState, VoxelShape> generateInnerPrismShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.func_177229_b((IProperty)PropertyHolder.FACING_HOR);
            if (((Boolean)state.func_177229_b((IProperty)PropertyHolder.TOP)).booleanValue()) {
                VoxelShape shapeTop = VoxelShapes.func_216384_a((VoxelShape)FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)8.0, (double)12.0, (double)12.0, (double)12.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)12.0), FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0), FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)4.0), FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)0.0, (double)4.0, (double)4.0, (double)4.0, (double)16.0), FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)4.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0), FramedThreewayCornerBlock.func_208617_a((double)8.0, (double)4.0, (double)8.0, (double)12.0, (double)8.0, (double)12.0), FramedThreewayCornerBlock.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)8.0, (double)4.0, (double)8.0), FramedThreewayCornerBlock.func_208617_a((double)4.0, (double)0.0, (double)8.0, (double)8.0, (double)4.0, (double)12.0), FramedThreewayCornerBlock.func_208617_a((double)8.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)8.0)}).func_197753_c();
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shapeTop));
                continue;
            }
            VoxelShape shapeBottom = VoxelShapes.func_216384_a((VoxelShape)FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)8.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)12.0), FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)8.0), FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)12.0, (double)4.0, (double)4.0, (double)16.0, (double)16.0), FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)12.0, (double)16.0), FramedThreewayCornerBlock.func_208617_a((double)8.0, (double)8.0, (double)8.0, (double)12.0, (double)12.0, (double)12.0), FramedThreewayCornerBlock.func_208617_a((double)4.0, (double)12.0, (double)4.0, (double)8.0, (double)16.0, (double)8.0), FramedThreewayCornerBlock.func_208617_a((double)4.0, (double)12.0, (double)8.0, (double)8.0, (double)16.0, (double)12.0), FramedThreewayCornerBlock.func_208617_a((double)8.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)8.0)}).func_197753_c();
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shapeBottom));
        }
        return builder.build();
    }

    public static ImmutableMap<BlockState, VoxelShape> generateThreewayShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.func_177229_b((IProperty)PropertyHolder.FACING_HOR);
            if (((Boolean)state.func_177229_b((IProperty)PropertyHolder.TOP)).booleanValue()) {
                VoxelShape shapeTop = VoxelShapes.func_216384_a((VoxelShape)FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0), FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0), FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)4.0, (double)4.0), FramedThreewayCornerBlock.func_208617_a((double)4.0, (double)12.0, (double)0.0, (double)8.0, (double)16.0, (double)12.0), FramedThreewayCornerBlock.func_208617_a((double)4.0, (double)8.0, (double)0.0, (double)8.0, (double)12.0, (double)12.0), FramedThreewayCornerBlock.func_208617_a((double)8.0, (double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)8.0), FramedThreewayCornerBlock.func_208617_a((double)8.0, (double)8.0, (double)0.0, (double)12.0, (double)12.0, (double)8.0), FramedThreewayCornerBlock.func_208617_a((double)12.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0)}).func_197753_c();
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shapeTop));
                continue;
            }
            VoxelShape shapeBottom = VoxelShapes.func_216384_a((VoxelShape)FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)4.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)4.0, (double)8.0, (double)12.0), FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)12.0, (double)8.0), FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0), FramedThreewayCornerBlock.func_208617_a((double)4.0, (double)0.0, (double)0.0, (double)8.0, (double)4.0, (double)12.0), FramedThreewayCornerBlock.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)8.0, (double)8.0, (double)12.0), FramedThreewayCornerBlock.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)8.0), FramedThreewayCornerBlock.func_208617_a((double)8.0, (double)4.0, (double)0.0, (double)12.0, (double)8.0, (double)8.0), FramedThreewayCornerBlock.func_208617_a((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)4.0)}).func_197753_c();
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shapeBottom));
        }
        return builder.build();
    }

    public static ImmutableMap<BlockState, VoxelShape> generateInnerThreewayShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.func_177229_b((IProperty)PropertyHolder.FACING_HOR);
            if (((Boolean)state.func_177229_b((IProperty)PropertyHolder.TOP)).booleanValue()) {
                VoxelShape shapeTop = VoxelShapes.func_216384_a((VoxelShape)FramedThreewayCornerBlock.func_208617_a((double)4.0, (double)8.0, (double)12.0, (double)16.0, (double)12.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)12.0), FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0), FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)4.0), FramedThreewayCornerBlock.func_208617_a((double)12.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0, (double)16.0), FramedThreewayCornerBlock.func_208617_a((double)8.0, (double)4.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0), FramedThreewayCornerBlock.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)8.0, (double)4.0, (double)8.0), FramedThreewayCornerBlock.func_208617_a((double)8.0, (double)0.0, (double)8.0, (double)12.0, (double)4.0, (double)12.0), FramedThreewayCornerBlock.func_208617_a((double)8.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)8.0)}).func_197753_c();
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shapeTop));
                continue;
            }
            VoxelShape shapeBottom = VoxelShapes.func_216384_a((VoxelShape)FramedThreewayCornerBlock.func_208617_a((double)4.0, (double)4.0, (double)12.0, (double)16.0, (double)8.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)12.0), FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)8.0), FramedThreewayCornerBlock.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), FramedThreewayCornerBlock.func_208617_a((double)12.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0, (double)16.0), FramedThreewayCornerBlock.func_208617_a((double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)12.0, (double)16.0), FramedThreewayCornerBlock.func_208617_a((double)4.0, (double)12.0, (double)4.0, (double)8.0, (double)16.0, (double)8.0), FramedThreewayCornerBlock.func_208617_a((double)8.0, (double)12.0, (double)8.0, (double)12.0, (double)16.0, (double)12.0), FramedThreewayCornerBlock.func_208617_a((double)8.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)8.0)}).func_197753_c();
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shapeBottom));
        }
        return builder.build();
    }
}

