/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.common.ToolType;
import team.chisel.ctm.api.IFacade;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.tileentity.FramedTileEntity;

public interface IFramedBlock
extends IFacade {
    public BlockType getBlockType();

    public static Block.Properties createProperties() {
        return Block.Properties.func_200945_a((Material)Material.field_151575_d).func_226896_b_().harvestTool(ToolType.AXE).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a);
    }

    default public BlockItem createItemBlock() {
        Block block = (Block)this;
        BlockItem item = new BlockItem(block, new Item.Properties().func_200916_a(FramedBlocks.FRAMED_GROUP));
        item.setRegistryName(block.getRegistryName());
        return item;
    }

    default public ActionResultType handleBlockActivated(World world, BlockPos pos, PlayerEntity player, Hand hand) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof FramedTileEntity) {
            return ((FramedTileEntity)te).handleInteraction(player, hand);
        }
        return ActionResultType.FAIL;
    }

    default public int getLight(IBlockReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof FramedTileEntity) {
            return ((FramedTileEntity)te).getLightValue();
        }
        return 0;
    }

    default public SoundType getSound(BlockState state, IWorldReader world, BlockPos pos) {
        BlockState camoState;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof FramedTileEntity && !(camoState = ((FramedTileEntity)te).getCamoState()).func_196958_f()) {
            return camoState.func_215695_r();
        }
        return ((Block)this).func_220072_p(state);
    }

    default public List<ItemStack> getDrops(List<ItemStack> drops, LootContext.Builder builder) {
        ItemStack camo;
        TileEntity te = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (te instanceof FramedTileEntity && !(camo = ((FramedTileEntity)te).getCamoStack()).func_190926_b()) {
            drops.add(camo);
        }
        return drops;
    }

    default public BiPredicate<BlockState, Direction> getCtmPredicate() {
        return this.getBlockType().getCtmPredicate();
    }

    @Override
    @Nonnull
    @Deprecated
    default public BlockState getFacade(@Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nullable Direction side) {
        return Blocks.field_150350_a.func_176223_P();
    }

    @Override
    @Nonnull
    default public BlockState getFacade(@Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nullable Direction side, @Nonnull BlockPos connection) {
        TileEntity te;
        BlockState state = world.func_180495_p(pos);
        if (this.getCtmPredicate().test(state, side) && (te = world.func_175625_s(pos)) instanceof FramedTileEntity) {
            return ((FramedTileEntity)te).getCamoState();
        }
        return Blocks.field_150350_a.func_176223_P();
    }
}

