/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.datagen.providers;

import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.block.LeverBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.state.properties.Half;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.CornerType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.SlopeType;

public class FramedBlockStateProvider
extends BlockStateProvider {
    private final ResourceLocation TEXTURE = this.modLoc("block/framed_block");

    public FramedBlockStateProvider(DataGenerator gen, ExistingFileHelper fileHelper) {
        super(gen, "framedblocks", fileHelper);
    }

    protected void registerStatesAndModels() {
        this.registerFramedCube();
        this.registerFramedSlope();
        this.registerFramedCornerSlope();
        this.registerFramedInnerCornerSlope();
        this.registerFramedPrismCorner();
        this.registerFramedInnerPrismCorner();
        this.registerFramedThreewayCorner();
        this.registerFramedInnerThreewayCorner();
        this.registerFramedSlab();
        this.registerFramedCornerPillar();
        this.registerFramedPanel();
        this.registerFramedStairs();
        this.registerFramedWall();
        this.registerFramedFence();
        this.registerFramedGate();
        this.registerFramedDoor();
        this.registerFramedTrapDoor();
        this.registerFramedPressurePlate();
        this.registerFramedLadder();
        this.registerFramedButton();
        this.registerFramedLever();
        this.registerFramedSign();
        this.registerFramedWallSign();
        this.registerFramedCollapsibleBlock();
    }

    private void registerFramedCube() {
        ModelBuilder cube = this.models().cubeAll("framed_cube", this.TEXTURE);
        this.simpleBlock(FBContent.blockFramedCube, (ModelFile)cube);
        this.simpleBlockItem(FBContent.blockFramedCube, (ModelFile)cube);
    }

    private void registerFramedSlope() {
        ModelFile.ExistingModelFile slopeBottom = this.models().getExistingFile(this.modLoc("block/framed_slope_bottom"));
        ModelFile.ExistingModelFile slopeHorizontal = this.models().getExistingFile(this.modLoc("block/framed_slope_horizontal"));
        ModelFile.ExistingModelFile slopeTop = this.models().getExistingFile(this.modLoc("block/framed_slope_top"));
        this.getVariantBuilder(FBContent.blockFramedSlope).forAllStatesExcept(arg_0 -> FramedBlockStateProvider.lambda$registerFramedSlope$0((ModelFile)slopeTop, (ModelFile)slopeBottom, (ModelFile)slopeHorizontal, arg_0), new IProperty[]{BlockStateProperties.field_208198_y});
        this.simpleBlockItem(FBContent.blockFramedSlope, (ModelFile)slopeBottom);
    }

    private void registerFramedCornerSlope() {
        ModelFile.ExistingModelFile cornerBottom = this.models().getExistingFile(this.modLoc("block/framed_corner_slope_bottom"));
        ModelFile.ExistingModelFile cornerTop = this.models().getExistingFile(this.modLoc("block/framed_corner_slope_top"));
        this.getVariantBuilder(FBContent.blockFramedCornerSlope).forAllStatesExcept(arg_0 -> FramedBlockStateProvider.lambda$registerFramedCornerSlope$1((ModelFile)cornerBottom, (ModelFile)cornerTop, arg_0), new IProperty[]{BlockStateProperties.field_208198_y});
        this.simpleBlockItem(FBContent.blockFramedCornerSlope, (ModelFile)cornerBottom);
    }

    private void registerFramedInnerCornerSlope() {
        ModelFile.ExistingModelFile innerCornerBottom = this.models().getExistingFile(this.modLoc("block/framed_inner_corner_slope_bottom"));
        ModelFile.ExistingModelFile innerCornerTop = this.models().getExistingFile(this.modLoc("block/framed_inner_corner_slope_top"));
        this.getVariantBuilder(FBContent.blockFramedInnerCornerSlope).forAllStatesExcept(arg_0 -> FramedBlockStateProvider.lambda$registerFramedInnerCornerSlope$2((ModelFile)innerCornerBottom, (ModelFile)innerCornerTop, arg_0), new IProperty[]{BlockStateProperties.field_208198_y});
        this.simpleBlockItem(FBContent.blockFramedInnerCornerSlope, (ModelFile)innerCornerBottom);
    }

    private void registerFramedPrismCorner() {
        ModelFile.ExistingModelFile prismBottom = this.models().getExistingFile(this.modLoc("block/framed_prism_corner_bottom"));
        ModelFile.ExistingModelFile prismTop = this.models().getExistingFile(this.modLoc("block/framed_prism_corner_top"));
        this.getVariantBuilder(FBContent.blockFramedPrismCorner).forAllStatesExcept(arg_0 -> FramedBlockStateProvider.lambda$registerFramedPrismCorner$3((ModelFile)prismTop, (ModelFile)prismBottom, arg_0), new IProperty[]{BlockStateProperties.field_208198_y});
        this.simpleBlockItem(FBContent.blockFramedPrismCorner, (ModelFile)prismBottom);
    }

    private void registerFramedInnerPrismCorner() {
        ModelFile.ExistingModelFile innerPrism = this.models().getExistingFile(this.modLoc("block/framed_inner_prism_corner"));
        this.getVariantBuilder(FBContent.blockFramedInnerPrismCorner).forAllStatesExcept(arg_0 -> FramedBlockStateProvider.lambda$registerFramedInnerPrismCorner$4((ModelFile)innerPrism, arg_0), new IProperty[]{PropertyHolder.TOP, BlockStateProperties.field_208198_y});
        this.simpleBlockItem(FBContent.blockFramedInnerPrismCorner, (ModelFile)innerPrism);
    }

    private void registerFramedThreewayCorner() {
        ModelFile.ExistingModelFile cornerBottom = this.models().getExistingFile(this.modLoc("block/framed_threeway_corner_bottom"));
        ModelFile.ExistingModelFile cornerTop = this.models().getExistingFile(this.modLoc("block/framed_threeway_corner_top"));
        this.getVariantBuilder(FBContent.blockFramedThreewayCorner).forAllStatesExcept(arg_0 -> FramedBlockStateProvider.lambda$registerFramedThreewayCorner$5((ModelFile)cornerTop, (ModelFile)cornerBottom, arg_0), new IProperty[]{BlockStateProperties.field_208198_y});
        this.simpleBlockItem(FBContent.blockFramedThreewayCorner, (ModelFile)cornerBottom);
    }

    private void registerFramedInnerThreewayCorner() {
        ModelFile.ExistingModelFile innerCornerBottom = this.models().getExistingFile(this.modLoc("block/framed_inner_threeway_corner_bottom"));
        ModelFile.ExistingModelFile innerCornerTop = this.models().getExistingFile(this.modLoc("block/framed_inner_threeway_corner_top"));
        this.getVariantBuilder(FBContent.blockFramedInnerThreewayCorner).forAllStatesExcept(arg_0 -> FramedBlockStateProvider.lambda$registerFramedInnerThreewayCorner$6((ModelFile)innerCornerTop, (ModelFile)innerCornerBottom, arg_0), new IProperty[]{BlockStateProperties.field_208198_y});
        this.simpleBlockItem(FBContent.blockFramedInnerThreewayCorner, (ModelFile)innerCornerBottom);
    }

    private void registerFramedSlab() {
        ModelBuilder bottomSlab = this.models().slab("framed_slab_bottom", this.TEXTURE, this.TEXTURE, this.TEXTURE);
        ModelBuilder topSlab = this.models().slabTop("framed_slab_top", this.TEXTURE, this.TEXTURE, this.TEXTURE);
        this.getVariantBuilder(FBContent.blockFramedSlab).forAllStatesExcept(arg_0 -> FramedBlockStateProvider.lambda$registerFramedSlab$7((ModelFile)topSlab, (ModelFile)bottomSlab, arg_0), new IProperty[]{BlockStateProperties.field_208198_y});
        this.simpleBlockItem(FBContent.blockFramedSlab, (ModelFile)bottomSlab);
    }

    private void registerFramedPanel() {
        ModelFile.ExistingModelFile panel = this.models().getExistingFile(this.modLoc("framed_panel"));
        this.getVariantBuilder(FBContent.blockFramedPanel).forAllStatesExcept(arg_0 -> FramedBlockStateProvider.lambda$registerFramedPanel$8((ModelFile)panel, arg_0), new IProperty[]{BlockStateProperties.field_208198_y});
        this.simpleBlockItem(FBContent.blockFramedPanel, (ModelFile)panel);
    }

    private void registerFramedCornerPillar() {
        ModelFile.ExistingModelFile pillar = this.models().getExistingFile(this.modLoc("framed_corner_pillar"));
        this.getVariantBuilder(FBContent.blockFramedCornerPillar).forAllStatesExcept(arg_0 -> FramedBlockStateProvider.lambda$registerFramedCornerPillar$9((ModelFile)pillar, arg_0), new IProperty[]{BlockStateProperties.field_208198_y});
        this.simpleBlockItem(FBContent.blockFramedCornerPillar, (ModelFile)pillar);
    }

    private void registerFramedStairs() {
        this.stairsBlock((StairsBlock)FBContent.blockFramedStairs, this.TEXTURE);
        ModelFile stairs = (ModelFile)this.models().generatedModels.get(this.modLoc("block/framed_stairs"));
        this.simpleBlockItem(FBContent.blockFramedStairs, stairs);
    }

    private void registerFramedWall() {
        this.wallBlock((WallBlock)FBContent.blockFramedWall, this.TEXTURE);
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder("framed_wall")).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/wall_inventory")))).texture("wall", this.TEXTURE);
    }

    private void registerFramedFence() {
        this.fenceBlock((FenceBlock)FBContent.blockFramedFence, this.TEXTURE);
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder("framed_fence")).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/fence_inventory")))).texture("texture", this.TEXTURE);
    }

    private void registerFramedGate() {
        this.fenceGateBlock((FenceGateBlock)FBContent.blockFramedGate, this.TEXTURE);
        ModelFile gate = (ModelFile)this.models().generatedModels.get(this.modLoc("block/framed_gate"));
        this.simpleBlockItem(FBContent.blockFramedGate, gate);
    }

    private void registerFramedDoor() {
        ModelFile.ExistingModelFile door = this.models().getExistingFile(this.modLoc("block/framed_door"));
        this.getVariantBuilder(FBContent.blockFramedDoor).forAllStatesExcept(arg_0 -> FramedBlockStateProvider.lambda$registerFramedDoor$10((ModelFile)door, arg_0), new IProperty[]{DoorBlock.field_176522_N});
        this.itemModels().singleTexture("framed_door", this.mcLoc("item/generated"), "layer0", this.modLoc("item/framed_door"));
    }

    private void registerFramedTrapDoor() {
        ModelFile.ExistingModelFile bottom = this.models().getExistingFile(this.modLoc("framed_trapdoor_bottom"));
        ModelFile.ExistingModelFile top = this.models().getExistingFile(this.modLoc("framed_trapdoor_top"));
        ModelFile.ExistingModelFile open = this.models().getExistingFile(this.modLoc("framed_trapdoor_open"));
        this.getVariantBuilder(FBContent.blockFramedTrapDoor).forAllStatesExcept(arg_0 -> FramedBlockStateProvider.lambda$registerFramedTrapDoor$11((ModelFile)open, (ModelFile)top, (ModelFile)bottom, arg_0), new IProperty[]{TrapDoorBlock.field_196381_c, TrapDoorBlock.field_204614_t});
        this.simpleBlockItem(FBContent.blockFramedTrapDoor, (ModelFile)bottom);
    }

    private void registerFramedPressurePlate() {
        ModelBuilder plate = ((BlockModelBuilder)this.models().withExistingParent("framed_pressure_plate", this.mcLoc("block/pressure_plate_up"))).texture("texture", this.TEXTURE);
        ModelBuilder plateDown = ((BlockModelBuilder)this.models().withExistingParent("framed_pressure_plate_down", this.mcLoc("block/pressure_plate_down"))).texture("texture", this.TEXTURE);
        this.getVariantBuilder(FBContent.blockFramedPressurePlate).forAllStates(arg_0 -> FramedBlockStateProvider.lambda$registerFramedPressurePlate$12((ModelFile)plateDown, (ModelFile)plate, arg_0));
        this.simpleBlockItem(FBContent.blockFramedPressurePlate, (ModelFile)plate);
    }

    private void registerFramedLadder() {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("framed_ladder", this.mcLoc("block/cube"))).texture("0", this.TEXTURE)).texture("particle", this.TEXTURE)).element().from(0.0f, 0.0f, 14.0f).to(2.0f, 16.0f, 16.0f).allFaces((dir, face) -> {
            face.texture("0");
            switch (dir) {
                case NORTH: 
                case WEST: {
                    face.uvs(14.0f, 0.0f, 16.0f, 16.0f);
                    break;
                }
                case EAST: 
                case SOUTH: {
                    face.uvs(0.0f, 0.0f, 2.0f, 16.0f);
                    break;
                }
                case UP: {
                    face.uvs(14.0f, 0.0f, 16.0f, 2.0f);
                    break;
                }
                case DOWN: {
                    face.uvs(14.0f, 14.0f, 16.0f, 16.0f);
                }
            }
        }).end()).element().from(14.0f, 0.0f, 14.0f).to(16.0f, 16.0f, 16.0f).allFaces((dir, face) -> {
            face.texture("0");
            switch (dir) {
                case NORTH: 
                case EAST: {
                    face.uvs(0.0f, 0.0f, 2.0f, 16.0f);
                    break;
                }
                case SOUTH: 
                case WEST: {
                    face.uvs(14.0f, 0.0f, 16.0f, 16.0f);
                    break;
                }
                case UP: {
                    face.uvs(0.0f, 0.0f, 2.0f, 2.0f);
                    break;
                }
                case DOWN: {
                    face.uvs(0.0f, 14.0f, 2.0f, 16.0f);
                }
            }
        }).end()).element().from(2.0f, 1.5f, 14.5f).to(14.0f, 2.5f, 15.5f).face(Direction.NORTH).texture("0").uvs(2.0f, 13.5f, 14.0f, 14.5f).end().face(Direction.SOUTH).texture("0").uvs(2.0f, 13.5f, 14.0f, 14.5f).end().face(Direction.UP).texture("0").uvs(2.0f, 0.5f, 14.0f, 1.5f).end().face(Direction.DOWN).texture("0").uvs(2.0f, 14.5f, 14.0f, 15.5f).end().end()).element().from(2.0f, 5.5f, 14.5f).to(14.0f, 6.5f, 15.5f).face(Direction.NORTH).texture("0").uvs(2.0f, 9.5f, 14.0f, 10.5f).end().face(Direction.SOUTH).texture("0").uvs(2.0f, 9.5f, 14.0f, 10.5f).end().face(Direction.UP).texture("0").uvs(2.0f, 0.5f, 14.0f, 1.5f).end().face(Direction.DOWN).texture("0").uvs(2.0f, 14.5f, 14.0f, 15.5f).end().end()).element().from(2.0f, 9.5f, 14.5f).to(14.0f, 10.5f, 15.5f).face(Direction.NORTH).texture("0").uvs(2.0f, 5.5f, 14.0f, 6.5f).end().face(Direction.SOUTH).texture("0").uvs(2.0f, 5.5f, 14.0f, 6.5f).end().face(Direction.UP).texture("0").uvs(2.0f, 0.5f, 14.0f, 1.5f).end().face(Direction.DOWN).texture("0").uvs(2.0f, 14.5f, 14.0f, 15.5f).end().end()).element().from(2.0f, 13.5f, 14.5f).to(14.0f, 14.5f, 15.5f).face(Direction.NORTH).texture("0").uvs(2.0f, 1.5f, 14.0f, 2.5f).end().face(Direction.SOUTH).texture("0").uvs(2.0f, 1.5f, 14.0f, 2.5f).end().face(Direction.UP).texture("0").uvs(2.0f, 0.5f, 14.0f, 1.5f).end().face(Direction.DOWN).texture("0").uvs(2.0f, 14.5f, 14.0f, 15.5f).end().end();
        this.getVariantBuilder(FBContent.blockFramedLadder).forAllStatesExcept(arg_0 -> FramedBlockStateProvider.lambda$registerFramedLadder$15((ModelFile)model, arg_0), new IProperty[]{BlockStateProperties.field_208198_y});
        this.simpleBlockItem(FBContent.blockFramedLadder, (ModelFile)model);
    }

    private void registerFramedButton() {
        ModelBuilder button = ((BlockModelBuilder)this.models().withExistingParent("framed_button", this.mcLoc("block/button"))).texture("texture", this.TEXTURE);
        ModelBuilder buttonPressed = ((BlockModelBuilder)this.models().withExistingParent("framed_button_pressed", this.mcLoc("block/button_pressed"))).texture("texture", this.TEXTURE);
        this.getVariantBuilder(FBContent.blockFramedButton).forAllStates(arg_0 -> FramedBlockStateProvider.lambda$registerFramedButton$16((ModelFile)buttonPressed, (ModelFile)button, arg_0));
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder("framed_button")).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/button_inventory")))).texture("texture", this.TEXTURE);
    }

    private void registerFramedLever() {
        ModelBuilder lever = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("framed_lever", this.mcLoc("block/lever"))).texture("base", this.TEXTURE)).texture("particle", this.TEXTURE);
        ModelBuilder leverOn = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("framed_lever_on", this.mcLoc("block/lever_on"))).texture("base", this.TEXTURE)).texture("particle", this.TEXTURE);
        this.getVariantBuilder(FBContent.blockFramedLever).forAllStates(arg_0 -> FramedBlockStateProvider.lambda$registerFramedLever$17((ModelFile)leverOn, (ModelFile)lever, arg_0));
        this.itemModels().singleTexture("framed_lever", this.mcLoc("item/generated"), "layer0", this.modLoc("item/framed_lever"));
    }

    private void registerFramedSign() {
        ModelFile[] signs = new ModelFile[]{this.models().getExistingFile(this.modLoc("framed_sign")), this.models().getExistingFile(this.modLoc("framed_sign_225")), this.models().getExistingFile(this.modLoc("framed_sign_45")), this.models().getExistingFile(this.modLoc("framed_sign_675"))};
        this.getVariantBuilder(FBContent.blockFramedSign).forAllStatesExcept(state -> {
            int rot = (15 - (Integer)state.func_177229_b((IProperty)BlockStateProperties.field_208138_am) + 1) % 16;
            ModelFile model = signs[rot % 4];
            int rotY = rot / 4 * 90;
            return ConfiguredModel.builder().modelFile(model).rotationY(rotY).build();
        }, new IProperty[]{BlockStateProperties.field_208198_y});
        this.itemModels().singleTexture("framed_sign", this.mcLoc("item/generated"), "layer0", this.modLoc("item/framed_sign"));
    }

    private void registerFramedWallSign() {
        ModelFile.ExistingModelFile sign = this.models().getExistingFile(this.modLoc("framed_wall_sign"));
        this.getVariantBuilder(FBContent.blockFramedWallSign).forAllStatesExcept(arg_0 -> FramedBlockStateProvider.lambda$registerFramedWallSign$19((ModelFile)sign, arg_0), new IProperty[]{BlockStateProperties.field_208198_y});
    }

    private void registerFramedCollapsibleBlock() {
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramedWallSign$19(ModelFile sign, BlockState state) {
        Direction dir = (Direction)state.func_177229_b((IProperty)PropertyHolder.FACING_HOR);
        int rotY = ((int)dir.func_185119_l() + 180) % 360;
        return ConfiguredModel.builder().modelFile(sign).rotationY(rotY).uvLock(true).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramedLever$17(ModelFile leverOn, ModelFile lever, BlockState state) {
        Direction facing = (Direction)state.func_177229_b((IProperty)HorizontalBlock.field_185512_D);
        AttachFace face = (AttachFace)state.func_177229_b((IProperty)HorizontalFaceBlock.field_196366_M);
        boolean powered = (Boolean)state.func_177229_b((IProperty)LeverBlock.field_176359_b);
        int rotY = (int)(facing.func_185119_l() + 180.0f) % 360;
        int rotX = face.ordinal() * 90;
        ModelFile model = powered ? leverOn : lever;
        return ConfiguredModel.builder().modelFile(model).rotationX(rotX).rotationY(rotY).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramedButton$16(ModelFile buttonPressed, ModelFile button, BlockState state) {
        Direction facing = (Direction)state.func_177229_b((IProperty)HorizontalBlock.field_185512_D);
        AttachFace face = (AttachFace)state.func_177229_b((IProperty)HorizontalFaceBlock.field_196366_M);
        boolean powered = (Boolean)state.func_177229_b((IProperty)LeverBlock.field_176359_b);
        int rotY = (int)(facing.func_185119_l() + 180.0f) % 360;
        int rotX = face.ordinal() * 90;
        ModelFile model = powered ? buttonPressed : button;
        return ConfiguredModel.builder().modelFile(model).rotationX(rotX).rotationY(rotY).uvLock(true).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramedLadder$15(ModelFile model, BlockState state) {
        Direction dir = (Direction)state.func_177229_b((IProperty)PropertyHolder.FACING_HOR);
        return ConfiguredModel.builder().modelFile(model).rotationY((int)dir.func_185119_l()).uvLock(true).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramedPressurePlate$12(ModelFile plateDown, ModelFile plate, BlockState state) {
        return ConfiguredModel.builder().modelFile((Boolean)state.func_177229_b((IProperty)PressurePlateBlock.field_176580_a) != false ? plateDown : plate).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramedTrapDoor$11(ModelFile open, ModelFile top, ModelFile bottom, BlockState state) {
        boolean isTop;
        int yRot = (int)((Direction)state.func_177229_b((IProperty)TrapDoorBlock.field_185512_D)).func_185119_l() + 180;
        boolean isOpen = (Boolean)state.func_177229_b((IProperty)TrapDoorBlock.field_176283_b);
        boolean bl = isTop = state.func_177229_b((IProperty)TrapDoorBlock.field_176285_M) == Half.TOP;
        ModelFile model = isOpen ? open : (isTop ? top : bottom);
        return ConfiguredModel.builder().modelFile(model).rotationY(yRot).uvLock(true).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramedDoor$10(ModelFile door, BlockState state) {
        boolean hingeRight = state.func_177229_b((IProperty)DoorBlock.field_176521_M) == DoorHingeSide.RIGHT;
        boolean open = (Boolean)state.func_177229_b((IProperty)DoorBlock.field_176519_b);
        int yRot = (int)((Direction)state.func_177229_b((IProperty)DoorBlock.field_176520_a)).func_185119_l() + 180;
        if (open) {
            yRot += 90;
        }
        if (hingeRight && open) {
            yRot += 180;
        }
        return ConfiguredModel.builder().modelFile(door).rotationY(yRot %= 360).uvLock(true).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramedCornerPillar$9(ModelFile pillar, BlockState state) {
        int rotY = (int)(((Direction)state.func_177229_b((IProperty)PropertyHolder.FACING_HOR)).func_185119_l() + 180.0f) % 360;
        return ConfiguredModel.builder().modelFile(pillar).rotationY(rotY).uvLock(true).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramedPanel$8(ModelFile panel, BlockState state) {
        int rotY = (int)(((Direction)state.func_177229_b((IProperty)PropertyHolder.FACING_HOR)).func_185119_l() + 180.0f) % 360;
        return ConfiguredModel.builder().modelFile(panel).rotationY(rotY).uvLock(true).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramedSlab$7(ModelFile topSlab, ModelFile bottomSlab, BlockState state) {
        return ConfiguredModel.builder().modelFile((Boolean)state.func_177229_b((IProperty)PropertyHolder.TOP) != false ? topSlab : bottomSlab).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramedInnerThreewayCorner$6(ModelFile innerCornerTop, ModelFile innerCornerBottom, BlockState state) {
        boolean top = (Boolean)state.func_177229_b((IProperty)PropertyHolder.TOP);
        Direction dir = (Direction)state.func_177229_b((IProperty)PropertyHolder.FACING_HOR);
        ModelFile model = top ? innerCornerTop : innerCornerBottom;
        return ConfiguredModel.builder().modelFile(model).rotationY(dir.func_176736_b() * 90).uvLock(true).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramedThreewayCorner$5(ModelFile cornerTop, ModelFile cornerBottom, BlockState state) {
        boolean top = (Boolean)state.func_177229_b((IProperty)PropertyHolder.TOP);
        ModelFile model = top ? cornerTop : cornerBottom;
        Direction dir = (Direction)state.func_177229_b((IProperty)PropertyHolder.FACING_HOR);
        return ConfiguredModel.builder().modelFile(model).rotationY(dir.func_176736_b() * 90).uvLock(true).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramedInnerPrismCorner$4(ModelFile innerPrism, BlockState state) {
        Direction dir = (Direction)state.func_177229_b((IProperty)PropertyHolder.FACING_HOR);
        return ConfiguredModel.builder().modelFile(innerPrism).rotationY(dir.func_176736_b() * 90).uvLock(true).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramedPrismCorner$3(ModelFile prismTop, ModelFile prismBottom, BlockState state) {
        boolean top = (Boolean)state.func_177229_b((IProperty)PropertyHolder.TOP);
        ModelFile model = top ? prismTop : prismBottom;
        Direction dir = (Direction)state.func_177229_b((IProperty)PropertyHolder.FACING_HOR);
        return ConfiguredModel.builder().modelFile(model).rotationY(dir.func_176736_b() * 90).uvLock(true).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramedInnerCornerSlope$2(ModelFile innerCornerBottom, ModelFile innerCornerTop, BlockState state) {
        CornerType type = (CornerType)((Object)state.func_177229_b(PropertyHolder.CORNER_TYPE));
        Direction dir = (Direction)state.func_177229_b((IProperty)PropertyHolder.FACING_HOR);
        if (type.isHorizontal()) {
            int rotX;
            ModelFile model = type == CornerType.HORIZONTAL_TOP_RIGHT || type == CornerType.HORIZONTAL_BOTTOM_LEFT ? innerCornerBottom : innerCornerTop;
            int n = rotX = type.isTop() ? 90 : -90;
            if (!type.isRight()) {
                dir = dir.func_176734_d();
            }
            return ConfiguredModel.builder().modelFile(model).rotationX(rotX).rotationY(dir.func_176736_b() * 90).uvLock(true).build();
        }
        ModelFile model = type.isTop() ? innerCornerTop : innerCornerBottom;
        return ConfiguredModel.builder().modelFile(model).rotationY(dir.func_176736_b() * 90).uvLock(true).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramedCornerSlope$1(ModelFile cornerBottom, ModelFile cornerTop, BlockState state) {
        CornerType type = (CornerType)((Object)state.func_177229_b(PropertyHolder.CORNER_TYPE));
        Direction dir = (Direction)state.func_177229_b((IProperty)PropertyHolder.FACING_HOR);
        if (type.isHorizontal()) {
            int rotX;
            ModelFile model = type == CornerType.HORIZONTAL_BOTTOM_RIGHT || type == CornerType.HORIZONTAL_TOP_LEFT ? cornerBottom : cornerTop;
            int n = rotX = type.isTop() ? 90 : -90;
            if (type.isRight()) {
                dir = dir.func_176734_d();
            }
            return ConfiguredModel.builder().modelFile(model).rotationX(rotX).rotationY(dir.func_176736_b() * 90).uvLock(true).build();
        }
        ModelFile model = type.isTop() ? cornerTop : cornerBottom;
        return ConfiguredModel.builder().modelFile(model).rotationY(dir.func_176736_b() * 90).uvLock(true).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramedSlope$0(ModelFile slopeTop, ModelFile slopeBottom, ModelFile slopeHorizontal, BlockState state) {
        SlopeType type = (SlopeType)((Object)state.func_177229_b(PropertyHolder.SLOPE_TYPE));
        ModelFile model = type == SlopeType.TOP ? slopeTop : (type == SlopeType.BOTTOM ? slopeBottom : slopeHorizontal);
        Direction dir = (Direction)state.func_177229_b((IProperty)PropertyHolder.FACING_HOR);
        return ConfiguredModel.builder().modelFile(model).rotationY(dir.func_176736_b() * 90).uvLock(true).build();
    }
}

