/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.tileentity;

import com.google.common.collect.ImmutableList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.Tags;
import xfacthd.framedblocks.client.util.FramedBlockData;
import xfacthd.framedblocks.common.FBContent;

public class FramedTileEntity
extends TileEntity {
    private static final ImmutableList<Block> TILE_ENTITY_WHITELIST = FramedTileEntity.buildTileEntityWhitelist();
    private static final ImmutableList<Block> BLOCK_BLACKLIST = FramedTileEntity.buildBlockBlacklist();
    private final IModelData modelData = new FramedBlockData();
    private ItemStack camoStack = ItemStack.field_190927_a;
    private BlockState camoState = Blocks.field_150350_a.func_176223_P();
    private boolean glowing = false;

    public FramedTileEntity() {
        this(FBContent.tileTypeFramedBlock);
    }

    protected FramedTileEntity(TileEntityType<?> type) {
        super(type);
    }

    public ActionResultType handleInteraction(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.camoState.func_196958_f() && stack.func_77973_b() == FBContent.itemFramedHammer) {
            if (!this.field_145850_b.func_201670_d()) {
                if (!player.field_71071_by.func_70441_a(this.camoStack)) {
                    player.func_71019_a(this.camoStack, false);
                }
                boolean lightUpdate = this.getLightValue() != 0;
                this.camoStack = ItemStack.field_190927_a;
                this.camoState = Blocks.field_150350_a.func_176223_P();
                this.func_70296_d();
                if (lightUpdate) {
                    this.doLightUpdate();
                }
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
            return this.field_145850_b.func_201670_d() ? ActionResultType.SUCCESS : ActionResultType.CONSUME;
        }
        if (this.camoState.func_196958_f() && stack.func_77973_b() instanceof BlockItem) {
            BlockState state = ((BlockItem)stack.func_77973_b()).func_179223_d().func_176223_P();
            if (this.isValidBlock(state)) {
                if (!this.field_145850_b.func_201670_d()) {
                    this.camoStack = stack.func_77979_a(1);
                    if (player.func_184812_l_()) {
                        stack.func_190917_f(1);
                    }
                    this.camoState = state;
                    this.func_70296_d();
                    if (this.getLightValue() != 0) {
                        this.doLightUpdate();
                    }
                    this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
                }
                return this.field_145850_b.func_201670_d() ? ActionResultType.SUCCESS : ActionResultType.CONSUME;
            }
        } else if (stack.func_77973_b().func_206844_a(Tags.Items.DUSTS_GLOWSTONE) && !this.glowing) {
            if (!this.field_145850_b.func_201670_d()) {
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                this.glowing = true;
                this.func_70296_d();
                this.doLightUpdate();
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
            return this.field_145850_b.func_201670_d() ? ActionResultType.SUCCESS : ActionResultType.CONSUME;
        }
        return ActionResultType.FAIL;
    }

    private boolean isValidBlock(BlockState state) {
        Block block = state.func_177230_c();
        if (BLOCK_BLACKLIST.contains((Object)block)) {
            return false;
        }
        if (block.hasTileEntity(state) && !TILE_ENTITY_WHITELIST.contains((Object)block)) {
            return false;
        }
        return block.func_200012_i(state, (IBlockReader)this.field_145850_b, this.field_174879_c);
    }

    public BlockState getCamoState() {
        return this.camoState;
    }

    public ItemStack getCamoStack() {
        return this.camoStack;
    }

    public int getLightValue() {
        if (this.glowing) {
            return 15;
        }
        return this.camoState.func_185906_d();
    }

    private void doLightUpdate() {
        this.field_145850_b.func_72863_F().func_212863_j_().func_215568_a(this.field_174879_c);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.writeToDataPacket(nbt);
        return new SUpdateTileEntityPacket(this.field_174879_c, -1, nbt);
    }

    protected void writeToDataPacket(CompoundNBT nbt) {
        nbt.func_218657_a("camo_stack", (INBT)this.camoStack.func_77955_b(new CompoundNBT()));
        nbt.func_218657_a("camo_state", (INBT)NBTUtil.func_190009_a((BlockState)this.camoState));
        nbt.func_74757_a("glowing", this.glowing);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        boolean newGlow;
        CompoundNBT nbt = pkt.func_148857_g();
        this.camoStack = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("camo_stack"));
        boolean needUpdate = false;
        BlockState newState = NBTUtil.func_190008_d((CompoundNBT)nbt.func_74775_l("camo_state"));
        if (newState != this.camoState) {
            int oldLight = this.getLightValue();
            this.camoState = newState;
            if (oldLight != this.getLightValue()) {
                this.doLightUpdate();
            }
            this.modelData.setData(FramedBlockData.WORLD, (Object)this.field_145850_b);
            this.modelData.setData(FramedBlockData.POS, (Object)this.field_174879_c);
            this.modelData.setData(FramedBlockData.CAMO, (Object)this.camoState);
            this.requestModelDataUpdate();
            needUpdate = true;
        }
        if ((newGlow = nbt.func_74767_n("glowing")) != this.glowing) {
            this.glowing = newGlow;
            needUpdate = true;
            this.doLightUpdate();
        }
        if (needUpdate) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        nbt.func_218657_a("camo_stack", (INBT)this.camoStack.func_77955_b(new CompoundNBT()));
        nbt.func_218657_a("camo_state", (INBT)NBTUtil.func_190009_a((BlockState)this.camoState));
        nbt.func_74757_a("glowing", this.glowing);
        return nbt;
    }

    public void handleUpdateTag(CompoundNBT nbt) {
        this.camoStack = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("camo_stack"));
        BlockState newState = NBTUtil.func_190008_d((CompoundNBT)nbt.func_74775_l("camo_state"));
        if (newState != this.camoState) {
            this.camoState = newState;
            this.modelData.setData(FramedBlockData.WORLD, (Object)this.field_145850_b);
            this.modelData.setData(FramedBlockData.POS, (Object)this.field_174879_c);
            this.modelData.setData(FramedBlockData.CAMO, (Object)this.camoState);
            this.requestModelDataUpdate();
        }
        this.glowing = nbt.func_74767_n("glowing");
    }

    public IModelData getModelData() {
        return this.modelData;
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_218657_a("camo_stack", (INBT)this.camoStack.func_77955_b(new CompoundNBT()));
        nbt.func_218657_a("camo_state", (INBT)NBTUtil.func_190009_a((BlockState)this.camoState));
        nbt.func_74757_a("glowing", this.glowing);
        return super.func_189515_b(nbt);
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.camoStack = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("camo_stack"));
        this.camoState = NBTUtil.func_190008_d((CompoundNBT)nbt.func_74775_l("camo_state"));
        this.glowing = nbt.func_74767_n("glowing");
    }

    private static ImmutableList<Block> buildTileEntityWhitelist() {
        return ImmutableList.builder().add((Object)Blocks.field_150421_aI).build();
    }

    private static ImmutableList<Block> buildBlockBlacklist() {
        return ImmutableList.builder().add((Object)Blocks.field_150331_J).add((Object)Blocks.field_150320_F).add((Object)Blocks.field_222436_lZ).build();
    }
}

