/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.geode.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import java.util.Map;
import net.mcreator.geode.GeodeModElements;
import net.mcreator.geode.procedures.EmeraldgeodeEntityDiesProcedure;
import net.mcreator.geode.procedures.QuartzspawnProcedure;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.RestrictSunGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

@GeodeModElements.ModElement.Tag
public class QuartzgeodeEntity
extends GeodeModElements.ModElement {
    public static EntityType entity = null;

    public QuartzgeodeEntity(GeodeModElements instance) {
        super(instance, 31);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new ModelRegisterHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void initElements() {
        entity = (EntityType)EntityType.Builder.func_220322_a(CustomEntity::new, (EntityClassification)EntityClassification.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(CustomEntity::new).func_220320_c().func_220321_a(0.6f, 1.8f).func_206830_a("quartzgeode").setRegistryName("quartzgeode");
        this.elements.entities.add(() -> entity);
        this.elements.items.add(() -> (Item)new SpawnEggItem(entity, -10468582, -1, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)).setRegistryName("quartzgeode_spawn_egg"));
    }

    @SubscribeEvent
    public void addFeatureToBiomes(BiomeLoadingEvent event) {
        event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners(entity, 45, 1, 1));
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(this::setupAttributes);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)entity, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            return QuartzspawnProcedure.executeProcedure((Map<String, Object>)ImmutableMap.of((Object)"x", (Object)x, (Object)"y", (Object)y, (Object)"z", (Object)z, (Object)"world", (Object)world));
        });
    }

    private void setupAttributes() {
        AttributeModifierMap.MutableAttribute ammma = MobEntity.func_233666_p_();
        ammma = ammma.func_233815_a_(Attributes.field_233821_d_, 0.25);
        ammma = ammma.func_233815_a_(Attributes.field_233818_a_, 26.0);
        ammma = ammma.func_233815_a_(Attributes.field_233826_i_, 5.0);
        ammma = ammma.func_233815_a_(Attributes.field_233823_f_, 4.0);
        ammma = ammma.func_233815_a_(Attributes.field_233820_c_, 0.5);
        ammma = ammma.func_233815_a_(Attributes.field_233824_g_, 1.0);
        GlobalEntityTypeAttributes.put((EntityType)entity, (AttributeModifierMap)ammma.func_233813_a_());
    }

    public static class ModelGeode
    extends EntityModel<Entity> {
        private final ModelRenderer head;
        private final ModelRenderer head_r1;
        private final ModelRenderer crystal;
        private final ModelRenderer crystal2;
        private final ModelRenderer body;
        private final ModelRenderer crystal3;
        private final ModelRenderer crystal4;
        private final ModelRenderer crystal5;
        private final ModelRenderer crystal6;
        private final ModelRenderer crystal7;
        private final ModelRenderer left_arm;
        private final ModelRenderer right_arm;
        private final ModelRenderer left_leg;
        private final ModelRenderer right_leg;

        public ModelGeode() {
            this.field_78090_t = 64;
            this.field_78089_u = 64;
            this.head = new ModelRenderer((Model)this);
            this.head.func_78793_a(1.0f, 1.0f, 0.0f);
            this.setRotationAngle(this.head, 0.0f, 0.0f, 0.1745f);
            this.head_r1 = new ModelRenderer((Model)this);
            this.head_r1.func_78793_a(0.0f, 24.0f, 0.0f);
            this.head.func_78792_a(this.head_r1);
            this.setRotationAngle(this.head_r1, 0.0f, 0.0436f, 0.0f);
            this.head_r1.func_78784_a(0, 0).func_228303_a_(-4.0f, -32.0f, -5.0f, 8.0f, 8.0f, 8.0f, 0.0f, true);
            this.crystal = new ModelRenderer((Model)this);
            this.crystal.func_78793_a(-3.5f, -6.0f, -5.5f);
            this.head.func_78792_a(this.crystal);
            this.setRotationAngle(this.crystal, 1.309f, 0.6109f, 0.0f);
            this.crystal.func_78784_a(48, 54).func_228303_a_(-1.3f, -3.0f, -2.0f, 4.0f, 6.0f, 4.0f, 0.0f, true);
            this.crystal2 = new ModelRenderer((Model)this);
            this.crystal2.func_78793_a(2.5f, -10.0f, -0.5f);
            this.head.func_78792_a(this.crystal2);
            this.setRotationAngle(this.crystal2, -0.7418f, 0.6109f, 0.0f);
            this.crystal2.func_78784_a(48, 54).func_228303_a_(-3.3f, -3.0f, 1.0f, 4.0f, 6.0f, 4.0f, 0.0f, false);
            this.body = new ModelRenderer((Model)this);
            this.body.func_78793_a(0.0f, 0.0f, -1.0f);
            this.setRotationAngle(this.body, 0.0873f, 0.0f, 0.0f);
            this.body.func_78784_a(16, 16).func_228303_a_(-4.5f, 0.0f, -2.0f, 9.0f, 12.0f, 4.0f, 0.0f, false);
            this.body.func_78784_a(30, 3).func_228303_a_(-5.0f, 0.0f, -3.0f, 10.0f, 6.0f, 7.0f, 0.005f, true);
            this.crystal3 = new ModelRenderer((Model)this);
            this.crystal3.func_78793_a(3.2f, 0.0f, 4.5f);
            this.body.func_78792_a(this.crystal3);
            this.setRotationAngle(this.crystal3, -1.5708f, 0.48f, -0.6545f);
            this.crystal3.func_78784_a(48, 54).func_228303_a_(-2.0f, -3.0f, -2.0f, 4.0f, 6.0f, 4.0f, 0.0f, true);
            this.crystal4 = new ModelRenderer((Model)this);
            this.crystal4.func_78793_a(-0.8f, 3.0f, 4.5f);
            this.body.func_78792_a(this.crystal4);
            this.setRotationAngle(this.crystal4, -1.5708f, -0.2182f, -1.4835f);
            this.crystal4.func_78784_a(48, 54).func_228303_a_(-2.0f, -3.0f, -2.0f, 4.0f, 6.0f, 4.0f, 0.0f, false);
            this.crystal5 = new ModelRenderer((Model)this);
            this.crystal5.func_78793_a(-6.8f, 1.0f, 3.5f);
            this.body.func_78792_a(this.crystal5);
            this.setRotationAngle(this.crystal5, -0.7418f, 1.0472f, -1.3963f);
            this.crystal5.func_78784_a(48, 54).func_228303_a_(0.0f, -2.0f, -1.0f, 4.0f, 6.0f, 4.0f, 0.0f, true);
            this.crystal6 = new ModelRenderer((Model)this);
            this.crystal6.func_78793_a(-5.8f, 6.0f, 2.5f);
            this.body.func_78792_a(this.crystal6);
            this.setRotationAngle(this.crystal6, 0.4363f, 1.5272f, -1.3963f);
            this.crystal6.func_78784_a(48, 54).func_228303_a_(1.0f, -2.0f, 1.0f, 4.0f, 6.0f, 4.0f, 0.0f, false);
            this.crystal7 = new ModelRenderer((Model)this);
            this.crystal7.func_78793_a(-7.8f, 0.0f, -0.5f);
            this.body.func_78792_a(this.crystal7);
            this.setRotationAngle(this.crystal7, -0.7854f, 2.5307f, -1.5272f);
            this.crystal7.func_78784_a(48, 54).func_228303_a_(-1.5f, -3.0f, 1.0f, 4.0f, 6.0f, 4.0f, 0.0f, false);
            this.left_arm = new ModelRenderer((Model)this);
            this.left_arm.func_78793_a(-5.0f, 2.0f, 0.0f);
            this.setRotationAngle(this.left_arm, -1.2654f, 0.0f, 0.0f);
            this.left_arm.func_78784_a(40, 16).func_228303_a_(9.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, 0.0f, true);
            this.right_arm = new ModelRenderer((Model)this);
            this.right_arm.func_78793_a(5.0f, 2.0f, 0.0f);
            this.left_leg = new ModelRenderer((Model)this);
            this.left_leg.func_78793_a(-1.9f, 12.0f, 0.0f);
            this.left_leg.func_78784_a(0, 16).func_228303_a_(1.9f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, 0.0f, true);
            this.right_leg = new ModelRenderer((Model)this);
            this.right_leg.func_78793_a(1.9f, 12.0f, 0.0f);
            this.right_leg.func_78784_a(0, 16).func_228303_a_(-5.9f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, 0.0f, false);
        }

        public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            this.head.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
            this.body.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
            this.left_arm.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
            this.right_arm.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
            this.left_leg.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
            this.right_leg.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        }

        public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }

        public void func_225597_a_(Entity e, float f, float f1, float f2, float f3, float f4) {
            this.left_leg.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * -1.0f * f1;
            this.head.field_78796_g = f3 / 57.295776f;
            this.head.field_78795_f = f4 / 57.295776f;
            this.right_leg.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * 1.0f * f1;
        }
    }

    public static class CustomEntity
    extends MonsterEntity {
        public CustomEntity(FMLPlayMessages.SpawnEntity packet, World world) {
            this((EntityType<CustomEntity>)entity, world);
        }

        public CustomEntity(EntityType<CustomEntity> type, World world) {
            super(type, world);
            this.field_70728_aV = 10;
            this.func_94061_f(false);
        }

        public IPacket<?> func_213297_N() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.2, false));
            this.field_70714_bg.func_75776_a(2, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
            this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
            this.field_70714_bg.func_75776_a(4, (Goal)new RestrictSunGoal((CreatureEntity)this));
            this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
            this.field_70715_bh.func_75776_a(6, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, false, false));
            this.field_70715_bh.func_75776_a(7, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[]{((Object)((Object)this)).getClass()}));
        }

        public CreatureAttribute func_70668_bt() {
            return CreatureAttribute.field_223223_b_;
        }

        public SoundEvent func_184639_G() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.husk.ambient"));
        }

        public void func_180429_a(BlockPos pos, BlockState blockIn) {
            this.func_184185_a((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.husk.step")), 0.15f, 1.0f);
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.husk.hurt"));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.husk.death"));
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (source.func_76364_f() instanceof ArrowEntity) {
                return false;
            }
            if (source.func_76364_f() instanceof PotionEntity) {
                return false;
            }
            if (source == DamageSource.field_76379_h) {
                return false;
            }
            if (source == DamageSource.field_76367_g) {
                return false;
            }
            if (source == DamageSource.field_76369_e) {
                return false;
            }
            if (source.func_94541_c()) {
                return false;
            }
            if (source == DamageSource.field_82728_o) {
                return false;
            }
            return super.func_70097_a(source, amount);
        }

        public void func_70645_a(DamageSource source) {
            super.func_70645_a(source);
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_();
            double z = this.func_226281_cx_();
            Entity sourceentity = source.func_76346_g();
            CustomEntity entity = this;
            HashMap<String, Object> $_dependencies = new HashMap<String, Object>();
            $_dependencies.put("x", x);
            $_dependencies.put("y", y);
            $_dependencies.put("z", z);
            $_dependencies.put("world", this.field_70170_p);
            EmeraldgeodeEntityDiesProcedure.executeProcedure($_dependencies);
        }
    }

    private static class ModelRegisterHandler {
        private ModelRegisterHandler() {
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public void registerModels(ModelRegistryEvent event) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)entity, renderManager -> new MobRenderer(renderManager, new ModelGeode(), 0.5f){

                public ResourceLocation func_110775_a(Entity entity) {
                    return new ResourceLocation("geode:textures/zombie_quartz2.png");
                }
            });
        }
    }
}

