/*
 * Decompiled with CFR 0.152.
 */
package net.emirikol.golemancy;

import java.util.UUID;
import net.emirikol.golemancy.Golemancy;
import net.emirikol.golemancy.client.render.ClayEffigyEntityRenderer;
import net.emirikol.golemancy.client.render.ClayGolemEntityRenderer;
import net.emirikol.golemancy.entity.Golems;
import net.emirikol.golemancy.network.Particles;
import net.emirikol.golemancy.network.SpawnPacket;
import net.emirikol.golemancy.screen.SoulGrafterScreen;
import net.emirikol.golemancy.screen.SoulMirrorScreen;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendereregistry.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.screenhandler.v1.ScreenRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_953;

public class GolemancyClient
implements ClientModInitializer {
    public void onInitializeClient() {
        this.registerEntities();
        this.registerParticles();
        this.registerSpawnPacket();
    }

    public void registerEntities() {
        ScreenRegistry.register(Golemancy.SOUL_MIRROR_SCREEN_HANDLER, SoulMirrorScreen::new);
        ScreenRegistry.register(Golemancy.SOUL_GRAFTER_SCREEN_HANDLER, SoulGrafterScreen::new);
        EntityRendererRegistry.INSTANCE.register(Golemancy.CLAY_EFFIGY_ENTITY, (dispatcher, context) -> new ClayEffigyEntityRenderer(dispatcher));
        for (class_1299 type : Golems.getTypes()) {
            EntityRendererRegistry.INSTANCE.register(type, (dispatcher, context) -> new ClayGolemEntityRenderer(dispatcher));
        }
        EntityRendererRegistry.INSTANCE.register(Golemancy.CLAYBALL, (dispatcher, context) -> new class_953(dispatcher, context.getItemRenderer()));
    }

    public void registerParticles() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)Particles.HEAL_PARTICLE_ID, (client, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            client.execute(() -> Particles.spawnHealParticle(pos));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)Particles.FOOD_PARTICLE_ID, (client, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            int entityId = buf.method_10816();
            client.execute(() -> {
                class_1297 e = class_310.method_1551().field_1687.method_8469(entityId);
                Particles.spawnFoodParticle(pos, e);
            });
        });
    }

    public void registerSpawnPacket() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SpawnPacket.SPAWN_PACKET_ID, (client, handler, buf, responseSender) -> {
            class_1299 et = (class_1299)class_2378.field_11145.method_10200(buf.method_10816());
            UUID uuid = buf.method_10790();
            int entityId = buf.method_10816();
            class_243 pos = SpawnPacket.readVec3d(buf);
            float pitch = SpawnPacket.readAngle(buf);
            float yaw = SpawnPacket.readAngle(buf);
            client.execute(() -> {
                if (class_310.method_1551().field_1687 == null) {
                    throw new IllegalStateException("Tried to spawn entity in a null world!");
                }
                class_1297 e = et.method_5883((class_1937)class_310.method_1551().field_1687);
                if (e == null) {
                    throw new IllegalStateException("Failed to create instance of entity \"" + class_2378.field_11145.method_10221((Object)et) + "\"!");
                }
                e.method_30228(pos);
                e.method_23327(pos.field_1352, pos.field_1351, pos.field_1350);
                e.field_5965 = pitch;
                e.field_6031 = yaw;
                e.method_5838(entityId);
                e.method_5826(uuid);
                class_310.method_1551().field_1687.method_2942(entityId, e);
            });
        });
    }
}

