/*
 * Decompiled with CFR 0.152.
 */
package net.emirikol.golemancy.block.entity;

import java.util.Random;
import net.emirikol.golemancy.Golemancy;
import net.emirikol.golemancy.block.SoulGrafterBlock;
import net.emirikol.golemancy.genetics.Gene;
import net.emirikol.golemancy.genetics.Genome;
import net.emirikol.golemancy.inventory.ImplementedSidedInventory;
import net.emirikol.golemancy.item.SoulstoneFilled;
import net.emirikol.golemancy.screen.SoulGrafterScreenHandler;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3000;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import org.jetbrains.annotations.Nullable;

public class SoulGrafterBlockEntity
extends class_2586
implements ImplementedSidedInventory,
class_3908,
class_3000 {
    private final class_2371<class_1799> items = class_2371.method_10213((int)10, (Object)class_1799.field_8037);
    public static final int[] PARENT_SLOTS = new int[]{0, 1};
    public static final int[] EMPTYSTONE_SLOTS = new int[]{2};
    public static final int[] FUEL_SLOTS = new int[]{3};
    public static final int[] OUTPUT_SLOTS = new int[]{4, 5, 6, 7, 8, 9};
    public static final int[] ALL_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    public static final int FUEL_VALUE = 600;
    public static final int GRAFT_DURATION = 2400;
    private int graft_time;
    private int fuel_time;
    private final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            switch (index) {
                case 0: {
                    return SoulGrafterBlockEntity.this.graft_time;
                }
                case 1: {
                    return SoulGrafterBlockEntity.this.fuel_time;
                }
            }
            return 0;
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    SoulGrafterBlockEntity.this.graft_time = value;
                    break;
                }
                case 1: {
                    SoulGrafterBlockEntity.this.fuel_time = value;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };

    public SoulGrafterBlockEntity() {
        super(Golemancy.SOUL_GRAFTER_ENTITY);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.items;
    }

    public class_2487 method_11007(class_2487 tag) {
        super.method_11007(tag);
        class_1262.method_5426((class_2487)tag, this.items);
        tag.method_10569("graft_time", this.graft_time);
        tag.method_10569("fuel_time", this.fuel_time);
        return tag;
    }

    public void method_11014(class_2680 state, class_2487 tag) {
        super.method_11014(state, tag);
        class_1262.method_5429((class_2487)tag, this.items);
        this.graft_time = tag.method_10550("graft_time");
        this.fuel_time = tag.method_10550("fuel_time");
    }

    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new SoulGrafterScreenHandler(syncId, playerInventory, (class_1263)this, this.propertyDelegate);
    }

    public class_2561 method_5476() {
        return new class_2588(this.method_11010().method_26204().method_9539());
    }

    public int[] method_5494(class_2350 side) {
        return ALL_SLOTS;
    }

    public boolean method_5437(int slot, class_1799 stack) {
        for (int i : PARENT_SLOTS) {
            if (slot != i || !stack.method_7929(new class_1799((class_1935)Golemancy.SOULSTONE_FILLED))) continue;
            return true;
        }
        for (int i : EMPTYSTONE_SLOTS) {
            if (slot != i || !stack.method_7929(new class_1799((class_1935)Golemancy.SOULSTONE_EMPTY))) continue;
            return true;
        }
        for (int i : FUEL_SLOTS) {
            if (slot != i || !stack.method_7929(new class_1799((class_1935)class_1802.field_8324))) continue;
            return true;
        }
        return false;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return this.method_5437(slot, stack);
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        for (int i : OUTPUT_SLOTS) {
            if (slot != i) continue;
            return true;
        }
        return false;
    }

    public boolean graftOutput(class_1799 stack) {
        for (int i : OUTPUT_SLOTS) {
            class_1799 outputStack = (class_1799)this.items.get(i);
            if (outputStack.method_7960()) {
                this.method_5447(i, stack);
                this.method_5431();
                return true;
            }
            if (!class_1799.method_7975((class_1799)outputStack, (class_1799)stack) || !class_1799.method_7987((class_1799)outputStack, (class_1799)stack) || outputStack.method_7947() >= outputStack.method_7914()) continue;
            outputStack.method_7933(1);
            this.method_5447(i, outputStack);
            this.method_5431();
            return true;
        }
        return false;
    }

    public boolean checkGraft() {
        for (int i : PARENT_SLOTS) {
            class_1792 item = ((class_1799)this.items.get(i)).method_7909();
            if (item instanceof SoulstoneFilled) continue;
            return false;
        }
        class_1792 item = ((class_1799)this.items.get(EMPTYSTONE_SLOTS[0])).method_7909();
        if (item != Golemancy.SOULSTONE_EMPTY) {
            return false;
        }
        boolean empty_slot = false;
        for (int i : OUTPUT_SLOTS) {
            class_1799 outputStack = (class_1799)this.items.get(i);
            if (!outputStack.method_7960()) continue;
            empty_slot = true;
            break;
        }
        return empty_slot;
    }

    public boolean isGrafting() {
        return this.graft_time > 0;
    }

    public boolean isBurning() {
        return this.fuel_time > 0;
    }

    public void method_16896() {
        boolean dirty = false;
        boolean grafting = this.isGrafting();
        if (this.isBurning()) {
            --this.fuel_time;
            dirty = true;
        }
        if (this.checkGraft()) {
            class_1799 stack;
            class_1792 item;
            if (this.fuel_time == 0 && (item = (stack = (class_1799)this.items.get(FUEL_SLOTS[0])).method_7909()) == class_1802.field_8324) {
                stack.method_7934(1);
                this.fuel_time = 600;
                dirty = true;
            }
            if (this.isBurning()) {
                if (this.isGrafting()) {
                    --this.graft_time;
                    dirty = true;
                    if (this.graft_time == 0) {
                        this.graft();
                    }
                } else {
                    this.graft_time = 2400;
                    dirty = true;
                }
            } else if (this.graft_time > 0) {
                this.graft_time = 0;
                dirty = true;
            }
        } else if (this.graft_time > 0) {
            this.graft_time = 0;
            dirty = true;
        }
        if (this.isGrafting() != grafting) {
            this.field_11863.method_8652(this.field_11867, (class_2680)this.field_11863.method_8320(this.field_11867).method_11657((class_2769)SoulGrafterBlock.GRAFTING, (Comparable)Boolean.valueOf(this.isGrafting())), 3);
            dirty = true;
        }
        if (dirty) {
            this.method_5431();
        }
    }

    public void graft() {
        Random rand = new Random();
        class_1799[] parents = new class_1799[]{null, null};
        for (int i = 0; i < PARENT_SLOTS.length; ++i) {
            parents[i] = (class_1799)this.items.get(PARENT_SLOTS[i]);
        }
        class_1799 emptySoulstones = (class_1799)this.items.get(EMPTYSTONE_SLOTS[0]);
        int x = rand.nextInt(2);
        Genome potencyGenome = new Genome(parents[x]);
        Gene potencyGene = potencyGenome.get("potency");
        int potency = (Integer)potencyGene.getActive();
        for (int i = 0; i < potency; ++i) {
            if (emptySoulstones.method_7947() <= 0) continue;
            Genome childGenome = Genome.breed(new Genome(parents[0]), new Genome(parents[1]));
            class_1799 child = new class_1799((class_1935)Golemancy.SOULSTONE_FILLED);
            childGenome.toItemStack(child);
            this.graftOutput(child);
            emptySoulstones.method_7934(1);
        }
        for (class_1799 parent : parents) {
            parent.method_7934(1);
        }
    }
}

