/*
 * Decompiled with CFR 0.152.
 */
package net.emirikol.golemancy.entity;

import net.emirikol.golemancy.Golemancy;
import net.emirikol.golemancy.GolemancyComponents;
import net.emirikol.golemancy.component.GolemComponent;
import net.emirikol.golemancy.entity.goal.GolemFollowWandGoal;
import net.emirikol.golemancy.entity.goal.GolemReturnHomeGoal;
import net.emirikol.golemancy.network.Particles;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1324;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_5132;
import net.minecraft.class_5134;

public abstract class AbstractGolemEntity
extends class_1321 {
    private int strength;
    private int agility;
    private int vigor;
    private int smarts;
    private class_2338 linkedBlockPos;
    private boolean golemWandFollow;
    private int attackTicksLeft;

    public AbstractGolemEntity(class_1299<? extends AbstractGolemEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.method_6173(false);
        this.field_6013 = 1.0f;
        this.golemWandFollow = false;
    }

    public static class_5132.class_5133 createGolemAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23719, 0.25).method_26868(class_5134.field_23716, 6.0).method_26868(class_5134.field_23721, 2.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(10, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(15, (class_1352)new GolemReturnHomeGoal(this, 1.0));
        this.field_6201.method_6277(16, (class_1352)new GolemFollowWandGoal(this, 1.0, 6.0f, 500.0f));
    }

    protected int method_6110(class_1657 player) {
        return 0;
    }

    public boolean method_6094() {
        return true;
    }

    protected float method_6107() {
        return 0.4f;
    }

    public void toComponent() {
        GolemComponent component = (GolemComponent)GolemancyComponents.GOLEM.get((Object)this);
        component.setAttribute("strength", this.strength);
        component.setAttribute("agility", this.agility);
        component.setAttribute("vigor", this.vigor);
        component.setAttribute("smarts", this.smarts);
        component.setLinkedBlockPos(this.linkedBlockPos);
    }

    public void fromComponent() {
        GolemComponent component = (GolemComponent)GolemancyComponents.GOLEM.get((Object)this);
        this.strength = component.getAttribute("strength");
        this.agility = component.getAttribute("agility");
        this.vigor = component.getAttribute("vigor");
        this.smarts = component.getAttribute("smarts");
        this.linkedBlockPos = component.getLinkedBlockPos();
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (this.field_6002.method_8608()) {
            return super.method_5992(player, hand);
        }
        if (hand == class_1268.field_5810) {
            return super.method_5992(player, hand);
        }
        if (player.method_5998(hand).method_7909() == Golemancy.GOLEM_WAND) {
            return super.method_5992(player, hand);
        }
        if (this.method_6171((class_1309)player)) {
            if (player.method_5998(hand).method_7909() == class_1802.field_8696) {
                return this.tryHealGolem(player, hand);
            }
            if (!this.method_6118(class_1304.field_6173).method_7960()) {
                return this.tryTakeFromGolem(player);
            }
            if (this.method_6118(class_1304.field_6173).method_7960() && !player.method_5998(hand).method_7960()) {
                return this.tryGiveToGolem(player, hand);
            }
        }
        return super.method_5992(player, hand);
    }

    private class_1269 tryHealGolem(class_1657 player, class_1268 hand) {
        if (this.method_6032() >= this.method_6063()) {
            return class_1269.field_5811;
        }
        class_1799 stack = player.method_5998(hand);
        stack.method_7934(1);
        this.method_6025(2.0f);
        Particles.healParticle((class_1309)this);
        return class_1269.field_21466;
    }

    private class_1269 tryTakeFromGolem(class_1657 player) {
        class_1799 stack = this.method_6118(class_1304.field_6173);
        class_3218 world = (class_3218)this.field_6002;
        player.field_7514.method_7398((class_1937)world, stack);
        this.method_5673(class_1304.field_6173, class_1799.field_8037);
        return class_1269.field_5812;
    }

    protected class_1269 tryGiveToGolem(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        this.method_5673(class_1304.field_6173, stack.method_7971(1));
        return class_1269.field_5812;
    }

    public void updateAttributes() {
        this.fromComponent();
        class_1324 entityAttributeInstance = this.method_5996(class_5134.field_23721);
        entityAttributeInstance.method_6192(this.getAttackDamageFromStrength(this.strength));
        entityAttributeInstance = this.method_5996(class_5134.field_23719);
        entityAttributeInstance.method_6192(this.getMovementSpeedFromAgility(this.agility));
        entityAttributeInstance = this.method_5996(class_5134.field_23716);
        entityAttributeInstance.method_6192(this.getHealthFromVigor(this.vigor));
        this.method_6033(this.method_6063());
        entityAttributeInstance = this.method_5996(class_5134.field_23717);
        entityAttributeInstance.method_6192(this.getFollowRangeFromSmarts(this.smarts));
    }

    public void setGolemStats(int str, int agi, int vig, int sma) {
        this.strength = str;
        this.agility = agi;
        this.vigor = vig;
        this.smarts = sma;
        this.toComponent();
    }

    public Integer getGolemStrength() {
        this.fromComponent();
        return this.strength;
    }

    public Integer getGolemSmarts() {
        this.fromComponent();
        return this.smarts;
    }

    public class_2338 getLinkedBlockPos() {
        this.fromComponent();
        return this.linkedBlockPos;
    }

    public void linkToBlockPos(class_2338 pos) {
        this.linkedBlockPos = pos;
        this.toComponent();
    }

    public boolean isFollowingWand() {
        return this.golemWandFollow;
    }

    public void toggleFollowingWand() {
        this.golemWandFollow = !this.golemWandFollow;
    }

    public double getAttackDamageFromStrength(int strength) {
        switch (strength) {
            case 0: {
                return 2.0;
            }
            case 1: {
                return 3.0;
            }
            case 2: {
                return 4.0;
            }
            case 3: {
                return 5.0;
            }
        }
        return 0.0;
    }

    public double getMovementSpeedFromAgility(int agility) {
        switch (agility) {
            case 0: {
                return 0.2;
            }
            case 1: {
                return 0.25;
            }
            case 2: {
                return 0.3;
            }
            case 3: {
                return 0.5;
            }
        }
        return 0.0;
    }

    public double getHealthFromVigor(int vigor) {
        switch (vigor) {
            case 0: {
                return 8.0;
            }
            case 1: {
                return 10.0;
            }
            case 2: {
                return 12.0;
            }
            case 3: {
                return 16.0;
            }
        }
        return 0.0;
    }

    public double getFollowRangeFromSmarts(int smarts) {
        switch (smarts) {
            case 0: {
                return 16.0;
            }
            case 1: {
                return 24.0;
            }
            case 2: {
                return 32.0;
            }
            case 3: {
                return 48.0;
            }
        }
        return 0.0;
    }

    public boolean method_6121(class_1297 target) {
        this.attackTicksLeft = 5;
        this.field_6002.method_8421((class_1297)this, (byte)4);
        return super.method_6121(target);
    }

    public void method_6007() {
        super.method_6007();
        if (this.attackTicksLeft > 0) {
            --this.attackTicksLeft;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void method_5711(byte status) {
        if (status == 4) {
            this.attackTicksLeft = 5;
        } else {
            super.method_5711(status);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public int getAttackTicksLeft() {
        return this.attackTicksLeft;
    }
}

