/*
 * Decompiled with CFR 0.152.
 */
package net.emirikol.golemancy.entity.goal;

import net.emirikol.golemancy.entity.AbstractGolemEntity;
import net.minecraft.class_1352;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class GolemBreakBlockGoal
extends class_1352 {
    private final AbstractGolemEntity entity;
    protected int breakProgress;
    protected int prevBreakProgress;
    protected int maxProgress;
    private class_2338 breakPos;

    public GolemBreakBlockGoal(AbstractGolemEntity entity) {
        this.entity = entity;
    }

    public boolean method_6264() {
        return this.isBlockNearby();
    }

    public void method_6269() {
        this.breakProgress = 0;
    }

    public boolean method_6266() {
        return this.breakProgress <= this.getMaxProgress() && this.method_6264();
    }

    public void method_6270() {
        super.method_6270();
        this.entity.field_6002.method_8517(this.entity.method_5628(), this.breakPos, -1);
    }

    public void method_6268() {
        if (this.entity.method_6051().nextInt(20) == 0 && !this.entity.field_6252) {
            this.entity.method_6104(this.entity.method_6058());
        }
        ++this.breakProgress;
        int i = (int)((float)this.breakProgress / (float)this.getMaxProgress() * 10.0f);
        if (i != this.prevBreakProgress) {
            this.entity.field_6002.method_8517(this.entity.method_5628(), this.breakPos, i);
            this.prevBreakProgress = i;
        }
        if (this.breakProgress == this.getMaxProgress()) {
            this.entity.field_6002.method_22352(this.breakPos, true);
            this.entity.field_6002.method_20290(2001, this.breakPos, class_2248.method_9507((class_2680)this.entity.field_6002.method_8320(this.breakPos)));
        }
    }

    public boolean isBlockNearby() {
        class_2338 pos = this.entity.method_24515();
        class_3218 world = (class_3218)this.entity.field_6002;
        for (class_2338 curPos : class_2338.method_25996((class_2338)pos, (int)2, (int)2, (int)2)) {
            if (!this.isBlockBreakable(curPos)) continue;
            this.breakPos = curPos;
            return true;
        }
        return false;
    }

    public boolean isBlockBreakable(class_2338 pos) {
        class_2680 state = this.entity.field_6002.method_8320(pos);
        if (state == null) {
            return false;
        }
        class_2338 linkedPos = this.entity.getLinkedBlockPos();
        if (linkedPos == null) {
            return false;
        }
        class_2680 linkedState = this.entity.field_6002.method_8320(linkedPos);
        if (linkedState == null) {
            return false;
        }
        float hardness = state.method_26214((class_1922)this.entity.field_6002, pos);
        return hardness >= 0.0f && hardness <= this.getBreakingStrength() && state.method_26204() == linkedState.method_26204() && !pos.equals((Object)linkedPos);
    }

    public float getBreakingStrength() {
        switch (this.entity.getGolemStrength()) {
            case 0: {
                return 2.0f;
            }
            case 1: {
                return 4.0f;
            }
            case 2: {
                return 5.0f;
            }
            case 3: {
                return 50.0f;
            }
        }
        return 0.0f;
    }

    protected int getMaxProgress() {
        return Math.max(120, this.maxProgress);
    }

    public double getDesiredSquaredDistanceToTarget() {
        return 2.0;
    }
}

