/*
 * Decompiled with CFR 0.152.
 */
package net.emirikol.golemancy.entity.goal;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.emirikol.golemancy.entity.AbstractGolemEntity;
import net.minecraft.class_1352;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class GolemMoveToBlockGoal
extends class_1352 {
    protected final AbstractGolemEntity entity;
    private final float searchRadius;
    private List<class_2248> filter;
    protected class_2338 targetPos;
    protected int tryingTime;
    protected int safeWaitingTime;

    public GolemMoveToBlockGoal(AbstractGolemEntity entity, float searchRadius) {
        this.entity = entity;
        this.searchRadius = searchRadius;
        this.filter = new ArrayList<class_2248>();
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
    }

    public boolean method_6264() {
        return this.findTargetPos();
    }

    public boolean method_6266() {
        return this.tryingTime >= -this.safeWaitingTime && this.tryingTime <= 1200 && this.method_6264();
    }

    public void method_6269() {
        this.entity.method_5942().method_6337((double)this.targetPos.method_10263() + 0.5, (double)(this.targetPos.method_10264() + 1), (double)this.targetPos.method_10260() + 0.5, 1.0);
        this.tryingTime = 0;
        this.safeWaitingTime = this.entity.method_6051().nextInt(this.entity.method_6051().nextInt(1200) + 1200) + 1200;
    }

    public void method_6268() {
        if (!this.targetPos.method_19769((class_2374)this.entity.method_19538(), this.getDesiredSquaredDistanceToTarget())) {
            ++this.tryingTime;
            if (this.shouldResetPath()) {
                this.entity.method_5942().method_6337((double)this.targetPos.method_10263() + 0.5, (double)(this.targetPos.method_10264() + 1), (double)this.targetPos.method_10260() + 0.5, 1.0);
            }
        } else {
            --this.tryingTime;
        }
    }

    public void add(class_2248 ... blocks) {
        for (class_2248 block : blocks) {
            this.filter.add(block);
        }
    }

    public double getDesiredSquaredDistanceToTarget() {
        return 0.5;
    }

    public boolean shouldResetPath() {
        return this.tryingTime % 40 == 0;
    }

    public boolean findTargetPos() {
        class_2338 pos = this.entity.getLinkedBlockPos();
        if (pos == null) {
            pos = this.entity.method_24515();
        }
        float r = this.searchRadius + 10.0f * (float)this.entity.getGolemSmarts().intValue();
        for (class_2338 curPos : class_2338.method_25996((class_2338)pos, (int)((int)r), (int)2, (int)((int)r))) {
            if (!this.isValidPos(curPos)) continue;
            this.targetPos = curPos;
            return true;
        }
        return false;
    }

    public boolean isValidPos(class_2338 pos) {
        class_3218 world = (class_3218)this.entity.field_6002;
        class_2680 state = world.method_8320(pos);
        return this.filter.isEmpty() || this.filter.contains(state.method_26204());
    }
}

