/*
 * Decompiled with CFR 0.152.
 */
package net.emirikol.golemancy.genetics;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class Gene<T> {
    private T active;
    private T dormant;

    public Gene(T active, T dormant) {
        this.active = active;
        this.dormant = dormant;
    }

    public Gene(T value) {
        this.active = value;
        this.dormant = value;
    }

    public List<T> toList() {
        return new ArrayList<T>(){
            {
                this.add(Gene.this.active);
                this.add(Gene.this.dormant);
            }
        };
    }

    public T getActive() {
        return this.active;
    }

    public T getDormant() {
        return this.dormant;
    }

    public T getRandom() {
        Random rand = new Random();
        Boolean bool = rand.nextBoolean();
        if (bool.booleanValue()) {
            return this.active;
        }
        return this.dormant;
    }

    public void setActive(T value) {
        this.active = value;
    }

    public void setDormant(T value) {
        this.dormant = value;
    }

    public void setBoth(T value) {
        this.active = value;
        this.dormant = value;
    }

    public Gene<T> breed(Gene<T> gene) {
        Random rand = new Random();
        T a = rand.nextBoolean() ? this.getRandom() : gene.getRandom();
        T d = rand.nextBoolean() ? this.getRandom() : gene.getRandom();
        return new Gene<T>(a, d);
    }
}

