/*
 * Decompiled with CFR 0.152.
 */
package net.emirikol.golemancy.genetics;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.emirikol.golemancy.genetics.Gene;
import net.emirikol.golemancy.genetics.Genomes;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public class Genome {
    private Map<String, Gene> genes = new HashMap<String, Gene>();

    public Genome() {
        this.genes.put("type", null);
        this.genes.put("potency", null);
        this.genes.put("strength", null);
        this.genes.put("agility", null);
        this.genes.put("vigor", null);
        this.genes.put("smarts", null);
    }

    public Genome(class_1799 stack) {
        this();
        this.fromItemStack(stack);
    }

    public Gene get(String key) {
        return this.genes.get(key);
    }

    public void put(String key, Gene gene) {
        this.genes.put(key, gene);
    }

    public Set<String> getKeys() {
        return this.genes.keySet();
    }

    public boolean validTag(class_2487 tag) {
        String[] keys;
        for (String key : keys = new String[]{"type_active", "type_dormant", "potency_active", "potency_dormant", "strength_active", "strength_dormant", "agility_active", "agility_dormant", "vigor_active", "vigor_dormant", "smarts_active", "smarts_dormant"}) {
            if (tag.method_10545(key)) continue;
            return false;
        }
        return true;
    }

    public void toItemStack(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        Gene type = this.genes.get("type");
        tag.method_10582("type_active", (String)type.getActive());
        tag.method_10582("type_dormant", (String)type.getDormant());
        Gene potency = this.genes.get("potency");
        tag.method_10569("potency_active", ((Integer)potency.getActive()).intValue());
        tag.method_10569("potency_dormant", ((Integer)potency.getDormant()).intValue());
        Gene strength = this.genes.get("strength");
        tag.method_10569("strength_active", ((Integer)strength.getActive()).intValue());
        tag.method_10569("strength_dormant", ((Integer)strength.getDormant()).intValue());
        Gene agility = this.genes.get("agility");
        tag.method_10569("agility_active", ((Integer)agility.getActive()).intValue());
        tag.method_10569("agility_dormant", ((Integer)agility.getDormant()).intValue());
        Gene vigor = this.genes.get("vigor");
        tag.method_10569("vigor_active", ((Integer)vigor.getActive()).intValue());
        tag.method_10569("vigor_dormant", ((Integer)vigor.getDormant()).intValue());
        Gene smarts = this.genes.get("smarts");
        tag.method_10569("smarts_active", ((Integer)smarts.getActive()).intValue());
        tag.method_10569("smarts_dormant", ((Integer)smarts.getDormant()).intValue());
        Integer textureId = Genomes.TEXTURE_VARIANTS.get(type.getActive());
        if (textureId != null) {
            tag.method_10569("CustomModelData", textureId.intValue());
        }
    }

    public void fromItemStack(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        if (this.validTag(tag)) {
            this.genes.put("type", new Gene<String>(tag.method_10558("type_active"), tag.method_10558("type_dormant")));
            this.genes.put("potency", new Gene<Integer>(tag.method_10550("potency_active"), tag.method_10550("potency_dormant")));
            this.genes.put("strength", new Gene<Integer>(tag.method_10550("strength_active"), tag.method_10550("strength_dormant")));
            this.genes.put("agility", new Gene<Integer>(tag.method_10550("agility_active"), tag.method_10550("agility_dormant")));
            this.genes.put("vigor", new Gene<Integer>(tag.method_10550("vigor_active"), tag.method_10550("vigor_dormant")));
            this.genes.put("smarts", new Gene<Integer>(tag.method_10550("smarts_active"), tag.method_10550("smarts_dormant")));
        } else {
            this.genes.put("type", Genomes.GENERIC.get("type"));
            this.genes.put("potency", Genomes.GENERIC.get("potency"));
            this.genes.put("strength", Genomes.GENERIC.get("strength"));
            this.genes.put("agility", Genomes.GENERIC.get("agility"));
            this.genes.put("vigor", Genomes.GENERIC.get("vigor"));
            this.genes.put("smarts", Genomes.GENERIC.get("smarts"));
        }
    }

    public static Genome breed(Genome left, Genome right) {
        Random rand = new Random();
        Genome newGenome = new Genome();
        Genome[] genomes = new Genome[]{left, right};
        for (String key : newGenome.getKeys()) {
            Gene leftGene = genomes[0].get(key);
            Gene rightGene = genomes[1].get(key);
            Gene newGene = leftGene.breed(rightGene);
            newGenome.put(key, newGene);
        }
        return newGenome;
    }
}

