/*
 * Decompiled with CFR 0.152.
 */
package net.emirikol.golemancy.genetics;

import java.util.HashMap;
import net.emirikol.golemancy.genetics.Genome;

public class SerializedGenome {
    public HashMap<String, String> activeAlleles;
    public HashMap<String, String> dormantAlleles;

    public SerializedGenome(Genome genome) {
        this.activeAlleles = new HashMap();
        for (String key : genome.getKeys()) {
            this.activeAlleles.put(key, genome.get(key).getActive().toString());
        }
        this.dormantAlleles = new HashMap();
        for (String key : genome.getKeys()) {
            this.dormantAlleles.put(key, genome.get(key).getDormant().toString());
        }
    }

    public SerializedGenome(String genomeString) {
        String[] keyval;
        String[] entries = genomeString.split("\\|");
        if (entries.length != 2) {
            return;
        }
        this.activeAlleles = new HashMap();
        for (String part : entries[0].split(";")) {
            keyval = part.split(",");
            if (keyval.length != 2) continue;
            this.activeAlleles.put(keyval[0], keyval[1]);
        }
        this.dormantAlleles = new HashMap();
        for (String part : entries[1].split(";")) {
            keyval = part.split(",");
            if (keyval.length != 2) continue;
            this.dormantAlleles.put(keyval[0], keyval[1]);
        }
    }

    public String toString() {
        CharSequence[] entries = new String[]{"", ""};
        int i = 0;
        CharSequence[] active = new String[this.activeAlleles.size()];
        for (String key : this.activeAlleles.keySet()) {
            active[i] = key + "," + this.activeAlleles.get(key);
            ++i;
        }
        entries[0] = String.join((CharSequence)";", active);
        i = 0;
        CharSequence[] dormant = new String[this.dormantAlleles.size()];
        for (String key : this.dormantAlleles.keySet()) {
            dormant[i] = key + "," + this.dormantAlleles.get(key);
            ++i;
        }
        entries[1] = String.join((CharSequence)";", dormant);
        return String.join((CharSequence)"|", entries);
    }
}

