/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.items;

import de.maxhenkel.gravestone.Main;
import de.maxhenkel.gravestone.corelib.death.Death;
import de.maxhenkel.gravestone.corelib.death.DeathManager;
import de.maxhenkel.gravestone.corelib.net.NetUtils;
import de.maxhenkel.gravestone.net.MessageOpenObituary;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ObituaryItem
extends Item {
    public ObituaryItem() {
        super(new Item.Properties().m_41487_(1));
        this.setRegistryName("obituary");
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player p, InteractionHand hand) {
        if (!(p instanceof ServerPlayer)) {
            return InteractionResultHolder.m_19090_((Object)p.m_21120_(hand));
        }
        ServerPlayer player = (ServerPlayer)p;
        Death death = this.fromStack(player, player.m_21120_(hand));
        if (death == null) {
            player.m_5661_((Component)new TranslatableComponent("message.gravestone.death_not_found"), true);
        } else if (player.m_6144_()) {
            if (player.m_20310_(player.f_8924_.m_7022_())) {
                MutableComponent replace = ComponentUtils.m_130748_((Component)new TranslatableComponent("message.gravestone.restore.replace")).m_130938_(style -> style.m_131157_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/restore @s " + death.getId().toString() + " replace")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("message.gravestone.restore.replace.description"))));
                MutableComponent add = ComponentUtils.m_130748_((Component)new TranslatableComponent("message.gravestone.restore.add")).m_130938_(style -> style.m_131157_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/restore @s " + death.getId().toString() + " add")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("message.gravestone.restore.add.description"))));
                player.m_6352_((Component)new TranslatableComponent("message.gravestone.restore").m_130946_(" ").m_7220_((Component)replace).m_130946_(" ").m_7220_((Component)add), Util.f_137441_);
            }
        } else {
            NetUtils.sendTo(Main.SIMPLE_CHANNEL, player, new MessageOpenObituary(death));
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    @Nullable
    public Death fromStack(ServerPlayer player, ItemStack stack) {
        CompoundTag compound = stack.m_41783_();
        if (compound == null || !compound.m_128441_("Death")) {
            return null;
        }
        CompoundTag death = compound.m_128469_("Death");
        return DeathManager.getDeath(player.m_9236_(), death.m_128342_("PlayerUUID"), death.m_128342_("DeathID"));
    }

    public ItemStack toStack(Death death) {
        ItemStack stack = new ItemStack((ItemLike)this);
        CompoundTag d = stack.m_41698_("Death");
        d.m_128362_("PlayerUUID", death.getPlayerUUID());
        d.m_128362_("DeathID", death.getId());
        return stack;
    }
}

