/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.tileentity;

import de.maxhenkel.gravestone.GraveUtils;
import de.maxhenkel.gravestone.Main;
import de.maxhenkel.gravestone.corelib.death.Death;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Nameable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class GraveStoneTileEntity
extends BlockEntity
implements Nameable {
    protected Death death = new Death.Builder(GraveUtils.EMPTY_UUID, GraveUtils.EMPTY_UUID).build();
    protected Component customName;

    public GraveStoneTileEntity(BlockPos pos, BlockState state) {
        super(Main.GRAVESTONE_TILEENTITY, pos, state);
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        compound.m_128365_("Death", (Tag)this.death.toNBT());
        if (this.customName != null) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        return super.m_6945_(compound);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("Death")) {
            this.death = Death.fromNBT(compound.m_128469_("Death"));
        } else {
            UUID playerUUID = GraveUtils.EMPTY_UUID;
            try {
                playerUUID = UUID.fromString(compound.m_128461_("PlayerUUID"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            Death.Builder builder = new Death.Builder(playerUUID, UUID.randomUUID());
            NonNullList items = NonNullList.m_122779_();
            ListTag list = compound.m_128437_("ItemStacks", 10);
            for (int i = 0; i < list.size(); ++i) {
                items.add((Object)ItemStack.m_41712_((CompoundTag)list.m_128728_(i)));
            }
            builder.additionalItems((NonNullList<ItemStack>)items);
            builder.playerName(compound.m_128461_("PlayerName"));
            builder.timestamp(compound.m_128454_("DeathTime"));
            this.death = builder.build();
        }
        if (compound.m_128441_("CustomName")) {
            this.customName = Component.Serializer.m_130701_((String)compound.m_128461_("CustomName"));
        }
    }

    public ClientboundBlockEntityDataPacket m_7033_() {
        return new ClientboundBlockEntityDataPacket(this.f_58858_, 1, this.m_5995_());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public CompoundTag m_5995_() {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("Death", (Tag)this.death.toNBT(false));
        compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        return super.m_6945_(compound);
    }

    public Death getDeath() {
        return this.death;
    }

    public void setDeath(Death death) {
        this.death = death;
        this.m_6596_();
    }

    public void setCustomName(Component name) {
        this.customName = name;
        this.m_6596_();
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    @Nullable
    public Component m_7770_() {
        return this.customName;
    }

    protected Component getDefaultName() {
        String name = this.death.getPlayerName();
        if (name == null || name.isEmpty()) {
            return new TranslatableComponent(Main.GRAVESTONE.m_7705_());
        }
        return new TranslatableComponent("message.gravestone.grave_of", new Object[]{name});
    }

    @Nullable
    public Component getGraveName() {
        if (!this.death.getPlayerName().isEmpty()) {
            return new TextComponent(this.death.getPlayerName());
        }
        if (this.customName != null) {
            return this.customName;
        }
        return null;
    }
}

