/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone;

import com.mojang.brigadier.CommandDispatcher;
import de.maxhenkel.gravestone.ClientConfig;
import de.maxhenkel.gravestone.ServerConfig;
import de.maxhenkel.gravestone.blocks.GraveStoneBlock;
import de.maxhenkel.gravestone.commands.RestoreCommand;
import de.maxhenkel.gravestone.corelib.CommonRegistry;
import de.maxhenkel.gravestone.entity.GhostPlayerEntity;
import de.maxhenkel.gravestone.entity.PlayerGhostRenderer;
import de.maxhenkel.gravestone.events.CreativeTabEvents;
import de.maxhenkel.gravestone.events.DeathEvents;
import de.maxhenkel.gravestone.items.ObituaryItem;
import de.maxhenkel.gravestone.net.MessageOpenObituary;
import de.maxhenkel.gravestone.tileentity.GraveStoneTileEntity;
import de.maxhenkel.gravestone.tileentity.render.GravestoneRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="gravestone")
@Mod(value="gravestone")
public class Main {
    public static final String MODID = "gravestone";
    public static final Logger LOGGER = LogManager.getLogger((String)"gravestone");
    public static SimpleChannel SIMPLE_CHANNEL;
    private static final DeferredRegister<Block> BLOCK_REGISTER;
    public static final RegistryObject<GraveStoneBlock> GRAVESTONE;
    private static final DeferredRegister<Item> ITEM_REGISTER;
    public static final RegistryObject<Item> GRAVESTONE_ITEM;
    public static final RegistryObject<ObituaryItem> OBITUARY;
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_REGISTER;
    public static final RegistryObject<BlockEntityType<GraveStoneTileEntity>> GRAVESTONE_TILEENTITY;
    private static final DeferredRegister<EntityType<?>> ENTITY_REGISTER;
    public static final RegistryObject<EntityType<GhostPlayerEntity>> GHOST;
    public static ServerConfig SERVER_CONFIG;
    public static ClientConfig CLIENT_CONFIG;

    public Main() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerAttributes);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(CreativeTabEvents::onCreativeModeTabBuildContents);
        SERVER_CONFIG = CommonRegistry.registerConfig(ModConfig.Type.SERVER, ServerConfig.class, true);
        CLIENT_CONFIG = CommonRegistry.registerConfig(ModConfig.Type.CLIENT, ClientConfig.class, true);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup));
        BLOCK_REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
        ITEM_REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
        BLOCK_ENTITY_REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
        ENTITY_REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new DeathEvents());
        MinecraftForge.EVENT_BUS.register((Object)this);
        SIMPLE_CHANNEL = CommonRegistry.registerChannel(MODID, "default");
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 0, MessageOpenObituary.class);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent event) {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)GRAVESTONE_TILEENTITY.get()), GravestoneRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)GHOST.get()), PlayerGhostRenderer::new);
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        RestoreCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)GHOST.get(), GhostPlayerEntity.getGhostAttributes());
    }

    static {
        BLOCK_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)MODID);
        GRAVESTONE = BLOCK_REGISTER.register(MODID, GraveStoneBlock::new);
        ITEM_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)MODID);
        GRAVESTONE_ITEM = ITEM_REGISTER.register(MODID, () -> ((GraveStoneBlock)GRAVESTONE.get()).toItem());
        OBITUARY = ITEM_REGISTER.register("obituary", ObituaryItem::new);
        BLOCK_ENTITY_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)MODID);
        GRAVESTONE_TILEENTITY = BLOCK_ENTITY_REGISTER.register(MODID, () -> BlockEntityType.Builder.m_155273_(GraveStoneTileEntity::new, (Block[])new Block[]{(Block)GRAVESTONE.get()}).m_58966_(null));
        ENTITY_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)MODID);
        GHOST = ENTITY_REGISTER.register("player_ghost", () -> CommonRegistry.registerEntity(MODID, "player_ghost", MobCategory.MONSTER, GhostPlayerEntity.class, builder -> builder.m_20699_(0.6f, 1.95f)));
    }
}

