/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.corelib.client;

import com.mojang.authlib.GameProfile;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.SkullBlockEntity;

public class PlayerSkins {
    @Nullable
    private static final Field gameProfileCacheField;
    private static HashMap<UUID, GameProfile> PLAYERS;

    public static ResourceLocation getSkin(UUID uuid, String name) {
        return PlayerSkins.getSkin(PlayerSkins.getGameProfile(uuid, name));
    }

    public static ResourceLocation getSkin(Player player) {
        return PlayerSkins.getSkin(player.m_36316_());
    }

    public static ResourceLocation getSkin(GameProfile gameProfile) {
        return Minecraft.m_91087_().m_91109_().m_293307_(gameProfile).f_290339_();
    }

    public static GameProfile getGameProfile(UUID uuid, String name) {
        if (PLAYERS.containsKey(uuid)) {
            return PLAYERS.get(uuid);
        }
        GameProfile gameProfile = new GameProfile(uuid, name);
        if (gameProfileCacheField == null) {
            return gameProfile;
        }
        try {
            GameProfileCache cache = (GameProfileCache)gameProfileCacheField.get(null);
            cache.m_143967_(name).thenAccept(p -> p.ifPresent(value -> PLAYERS.put(uuid, (GameProfile)value)));
        }
        catch (Exception e) {
            PLAYERS.put(uuid, gameProfile);
            return gameProfile;
        }
        return gameProfile;
    }

    public static boolean isSlim(UUID uuid) {
        PlayerInfo networkplayerinfo = Minecraft.m_91087_().m_91403_().m_104949_(uuid);
        return networkplayerinfo == null ? (uuid.hashCode() & 1) == 1 : networkplayerinfo.m_293823_().f_290793_().equals((Object)PlayerSkin.Model.SLIM);
    }

    public static boolean isSlim(Player player) {
        return PlayerSkins.isSlim(player.m_20148_());
    }

    static {
        Field[] fields;
        Field gameProfileCache = null;
        for (Field field : fields = SkullBlockEntity.class.getDeclaredFields()) {
            if (!field.getType().equals(GameProfileCache.class)) continue;
            field.setAccessible(true);
            gameProfileCache = field;
            break;
        }
        gameProfileCacheField = gameProfileCache;
        PLAYERS = new HashMap();
    }
}

