/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy;

import greekfantasy.util.BiomeWhitelistConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.Dimension;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;

public class GFConfig {
    public final ForgeConfigSpec.DoubleValue SANDALS_SPEED_BONUS;
    public final ForgeConfigSpec.BooleanValue NERF_AMBROSIA;
    public final ForgeConfigSpec.BooleanValue UNICORN_HORN_CURES_EFFECTS;
    public final ForgeConfigSpec.IntValue UNICORN_HORN_DURABILITY;
    public final ForgeConfigSpec.IntValue HEALING_ROD_DURABILITY;
    public final ForgeConfigSpec.IntValue THUNDERBOLT_DURABILITY;
    public final ForgeConfigSpec.IntValue BAG_OF_WIND_DURABILITY;
    public final ForgeConfigSpec.IntValue SWINE_WAND_DURABILITY;
    private final ForgeConfigSpec.BooleanValue HELM_HIDES_ARMOR;
    private final ForgeConfigSpec.BooleanValue DRAGON_TOOTH_SPAWNS_SPARTI;
    private final ForgeConfigSpec.BooleanValue SWORD_OF_HUNT_BYPASSES_ARMOR;
    private final ForgeConfigSpec.IntValue HEALING_ROD_COOLDOWN;
    private final ForgeConfigSpec.BooleanValue THUNDERBOLT_STORMS_ONLY;
    private final ForgeConfigSpec.IntValue THUNDERBOLT_COOLDOWN;
    private final ForgeConfigSpec.BooleanValue CONCH_ENABLED;
    private final ForgeConfigSpec.IntValue CONCH_COOLDOWN;
    private final ForgeConfigSpec.IntValue BAG_OF_WIND_COOLDOWN;
    private final ForgeConfigSpec.IntValue BAG_OF_WIND_DURATION;
    private final ForgeConfigSpec.IntValue SWINE_WAND_COOLDOWN;
    private final ForgeConfigSpec.IntValue SWINE_WAND_DURATION;
    private final ForgeConfigSpec.BooleanValue WINGED_SANDALS_DEPLETE;
    private boolean helmHidesArmor;
    private boolean dragonToothSpawnsSparti;
    private boolean swordOfHuntBypassesArmor;
    private int healingRodCooldown;
    private boolean thunderboltStormsOnly;
    private int thunderboltCooldown;
    private boolean conchEnabled;
    private int conchCooldown;
    private int bagOfWindCooldown;
    private int bagOfWindDuration;
    private int swineWandCooldown;
    private int swineWandDuration;
    private boolean wingedSandalsDeplete;
    private final ForgeConfigSpec.BooleanValue FORCE_FOV_RESET;
    private final ForgeConfigSpec.BooleanValue STUN_PREVENTS_JUMP;
    private final ForgeConfigSpec.BooleanValue STUN_PREVENTS_USE;
    private final ForgeConfigSpec.BooleanValue OVERSTEP_ENABLED;
    private final ForgeConfigSpec.BooleanValue SILKWALKER_ENABLED;
    private final ForgeConfigSpec.BooleanValue SMASHING_ENABLED;
    private final ForgeConfigSpec.BooleanValue HUNTING_ENABLED;
    private final ForgeConfigSpec.BooleanValue POISON_ENABLED;
    private final ForgeConfigSpec.BooleanValue MIRROR_ENABLED;
    private final ForgeConfigSpec.BooleanValue FLYING_ENABLED;
    private final ForgeConfigSpec.BooleanValue LORD_OF_THE_SEA_ENABLED;
    private final ForgeConfigSpec.BooleanValue FIREFLASH_ENABLED;
    private final ForgeConfigSpec.BooleanValue FIREFLASH_DESTROYS_BLOCKS;
    private final ForgeConfigSpec.BooleanValue DAYBREAK_ENABLED;
    private final ForgeConfigSpec.BooleanValue RAISING_ENABLED;
    private final ForgeConfigSpec.BooleanValue PRISONER_ENABLED;
    private final ForgeConfigSpec.IntValue PRISONER_DURATION;
    private final ForgeConfigSpec.BooleanValue SWINE_ENABLED;
    private final ForgeConfigSpec.BooleanValue SWINE_DROPS_ARMOR;
    private final ForgeConfigSpec.BooleanValue SWINE_PREVENTS_TARGET;
    private final ForgeConfigSpec.BooleanValue IS_SWINE_ENTITY_WHITELIST;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> SWINE_ENTITY_WHITELIST;
    private boolean forceFOVReset;
    private boolean stunPreventsJump;
    private boolean stunPreventsUse;
    private boolean overstepEnabled;
    private boolean silkwalkerEnabled;
    private boolean smashingEnabled;
    private boolean huntingEnabled;
    private boolean poisonEnabled;
    private boolean mirrorEnabled;
    private boolean flyingEnabled;
    private boolean daybreakEnabled;
    private boolean raisingEnabled;
    private boolean lordOfTheSeaEnabled;
    private boolean fireflashEnabled;
    private boolean fireflashDestroysBlocks;
    private boolean prisonerEnabled;
    private int prisonerDuration;
    private boolean swineEnabled;
    private boolean swineDropsArmor;
    private boolean swinePreventsTarget;
    private final ForgeConfigSpec.BooleanValue MIRROR_POTION;
    private final ForgeConfigSpec.BooleanValue SWINE_POTION;
    private boolean mirrorPotion;
    private boolean swinePotion;
    public final ForgeConfigSpec.BooleanValue DRAKAINA_ATTACK;
    public final ForgeConfigSpec.BooleanValue EMPUSA_ATTACK;
    public final ForgeConfigSpec.BooleanValue FURY_ATTACK;
    public final ForgeConfigSpec.BooleanValue GORGON_ATTACK;
    public final ForgeConfigSpec.BooleanValue MINOTAUR_ATTACK;
    public final ForgeConfigSpec.BooleanValue ORTHUS_ATTACK;
    public final ForgeConfigSpec.BooleanValue SHADE_ATTACK;
    public final ForgeConfigSpec.BooleanValue SATYR_ATTACK;
    public final ForgeConfigSpec.BooleanValue SIREN_ATTACK;
    public final ForgeConfigSpec.BooleanValue SATYR_LIGHTS_CAMPFIRES;
    private final ForgeConfigSpec.ConfigValue<? extends String> SATYR_SONG;
    public final ForgeConfigSpec.BooleanValue SHADE_PLAYER_ONLY;
    private final ForgeConfigSpec.BooleanValue WHIRL_INVULNERABLE;
    private final ForgeConfigSpec.BooleanValue DRYAD_ANGRY_ON_HARVEST;
    private final ForgeConfigSpec.IntValue DRYAD_ANGRY_RANGE;
    private final ForgeConfigSpec.IntValue SPARTI_LIFESPAN;
    private final ForgeConfigSpec.IntValue WHIRL_LIFESPAN;
    private final ForgeConfigSpec.BooleanValue NERF_STUNNING;
    private final ForgeConfigSpec.BooleanValue NERF_PARALYSIS;
    private boolean whirlInvulnerable;
    private boolean dryadAngryOnHarvest;
    private int dryadAngryRange;
    private int spartiLifespan;
    private int whirlLifespan;
    private ResourceLocation satyrSong;
    private boolean nerfStunning;
    private boolean nerfParalysis;
    public final Map<String, BiomeWhitelistConfig> MOB_SPAWNS = new HashMap<String, BiomeWhitelistConfig>();
    private final ForgeConfigSpec.BooleanValue SHADE_SPAWN_ON_DEATH;
    private final ForgeConfigSpec.IntValue SATYR_SHAMAN_CHANCE;
    private final ForgeConfigSpec.DoubleValue GORGON_MEDUSA_CHANCE;
    private final ForgeConfigSpec.DoubleValue LIGHTNING_MEDUSA_CHANCE;
    private final ForgeConfigSpec.DoubleValue LIGHTNING_LION_CHANCE;
    private final ForgeConfigSpec.DoubleValue CIRCE_CHANCE;
    private final ForgeConfigSpec.DoubleValue GOLDEN_RAM_CHANCE;
    private final ForgeConfigSpec.BooleanValue MEDUSA_BOSS_BAR;
    private final ForgeConfigSpec.BooleanValue CIRCE_BOSS_BAR;
    private final ForgeConfigSpec.BooleanValue ARACHNE_BOSS_BAR;
    private final ForgeConfigSpec.BooleanValue CRETAN_BOSS_BAR;
    private final ForgeConfigSpec.BooleanValue NEMEAN_LION_BOSS_BAR;
    private final ForgeConfigSpec.IntValue ELPIS_SPAWN_CHANCE;
    public final ForgeConfigSpec.IntValue NUM_SPARTI_SPAWNED;
    private final ForgeConfigSpec.BooleanValue GIANT_BOAR_NON_NETHER;
    private boolean shadeSpawnOnDeath;
    private int satyrShamanChance;
    private double gorgonMedusaChance;
    private double lightningMedusaChance;
    private double lightningLionChance;
    private double circeChance;
    private double goldenRamChance;
    private boolean medusaBossBar;
    private boolean circeBossBar;
    private boolean arachneBossBar;
    private boolean cretanBossBar;
    private boolean nemeanLionBossBar;
    private int elpisSpawnChance;
    private int numSpartiSpawned;
    private boolean giantBoarNonNether;
    public final ForgeConfigSpec.IntValue OLIVE_FOREST_BIOME_WEIGHT;
    public final Map<String, BiomeWhitelistConfig> FEATURES = new HashMap<String, BiomeWhitelistConfig>();
    public final ForgeConfigSpec.BooleanValue IS_SPAWNS_WHITELIST;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> SPAWNS_DIMENSION_WHITELIST;
    public final ForgeConfigSpec.BooleanValue IS_FEATURES_WHITELIST;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> FEATURES_DIMENSION_WHITELIST;
    private final ForgeConfigSpec.BooleanValue PALLADIUM_ENABLED;
    private final ForgeConfigSpec.IntValue PALLADIUM_REFRESH_INTERVAL;
    private final ForgeConfigSpec.IntValue PALLADIUM_CHUNK_RANGE;
    private final ForgeConfigSpec.IntValue PALLADIUM_Y_RANGE;
    private boolean palladiumEnabled;
    private int palladiumRefreshInterval;
    private int palladiumChunkRange;
    private int palladiumYRange;
    private final ForgeConfigSpec.BooleanValue FAVOR_ENABLED;
    private final ForgeConfigSpec.BooleanValue FAVOR_DECREASES;
    private final ForgeConfigSpec.BooleanValue FAVOR_NOTIFY;
    private final ForgeConfigSpec.BooleanValue FAVOR_NOTIFY_CHAT;
    private final ForgeConfigSpec.LongValue FAVOR_DECREASE_INTERVAL;
    private boolean favorEnabled;
    private boolean favorNotify;
    private boolean favorNotifyChat;
    private boolean favorDecreases;
    private long favorDecreaseInterval;

    public GFConfig(ForgeConfigSpec.Builder builder) {
        builder.push("items");
        this.SANDALS_SPEED_BONUS = builder.comment("Winged Sandals speed bonus (1.0 = +100%)").worldRestart().defineInRange("sandals_speed_bonus", 1.5, 0.0, 2.0);
        this.NERF_AMBROSIA = builder.comment("When true, ambrosia gives effects of Golden Apple instead of Enchanted Golden Apple").define("nerf_ambrosia", false);
        this.UNICORN_HORN_CURES_EFFECTS = builder.comment("Whether using the unicorn horn can cure potion effects").define("unicorn_horn_cures_effects", true);
        this.UNICORN_HORN_DURABILITY = builder.defineInRange("unicorn_horn_durability", 44, 1, 4000);
        this.HELM_HIDES_ARMOR = builder.comment("Whether the helm of darkness hides armor").define("helm_hides_armor", true);
        this.DRAGON_TOOTH_SPAWNS_SPARTI = builder.comment("Whether throwing a hydra tooth can spawn Sparti").define("dragon_tooth_spawns_sparti", true);
        this.SWORD_OF_HUNT_BYPASSES_ARMOR = builder.comment("Whether the Sword of the Hunt deals absolute damage to animals").define("sword_of_hunt_bypasses_armor", true);
        this.CONCH_ENABLED = builder.comment("Whether the Conch can place/remove water").define("conch_enabled", true);
        this.CONCH_COOLDOWN = builder.defineInRange("conch_cooldown", 10, 0, 100);
        this.WINGED_SANDALS_DEPLETE = builder.comment("Whether the Winged Sandals slowly lose durability").define("winged_sandals_deplete", false);
        this.HEALING_ROD_COOLDOWN = builder.defineInRange("healing_rod_cooldown", 35, 0, 100);
        this.HEALING_ROD_DURABILITY = builder.defineInRange("healing_rod_durability", 384, 1, 4000);
        this.THUNDERBOLT_STORMS_ONLY = builder.comment("Whether the Thunderbolt can only be used during storms").define("thunderbolt_storms_only", false);
        this.THUNDERBOLT_COOLDOWN = builder.defineInRange("thunderbolt_cooldown", 100, 0, 100);
        this.THUNDERBOLT_DURABILITY = builder.defineInRange("thunderbolt_durability", 170, 1, 4000);
        this.BAG_OF_WIND_DURATION = builder.defineInRange("bag_of_wind_duration", 400, 1, 24000);
        this.BAG_OF_WIND_COOLDOWN = builder.defineInRange("bag_of_wind_cooldown", 700, 0, 100);
        this.BAG_OF_WIND_DURABILITY = builder.defineInRange("bag_of_wind_durability", 24, 1, 4000);
        this.SWINE_WAND_DURATION = builder.defineInRange("swine_wand_duration", 2450, 1, 24000);
        this.SWINE_WAND_COOLDOWN = builder.defineInRange("swine_wand_cooldown", 50, 0, 100);
        this.SWINE_WAND_DURABILITY = builder.defineInRange("swine_wand_durability", 104, 1, 4000);
        builder.pop();
        builder.push("effects");
        this.FORCE_FOV_RESET = builder.comment("When true, prevents FOV modifiers when stunned or wearing winged sandals").define("force_fov_reset", true);
        this.STUN_PREVENTS_JUMP = builder.comment("When stunned, players are prevented from jumping").define("stun_prevents_jump", true);
        this.STUN_PREVENTS_USE = builder.comment("When stunned, players are prevented from using items").define("stun_prevents_use", true);
        this.OVERSTEP_ENABLED = builder.define("enable_overstep_enchantment", true);
        this.SILKWALKER_ENABLED = builder.define("enable_silkwalker_enchantment", true);
        this.SMASHING_ENABLED = builder.define("enable_smashing_enchantment", true);
        this.HUNTING_ENABLED = builder.define("enable_hunting_enchantment", true);
        this.POISON_ENABLED = builder.define("enable_poison_enchantment", true);
        this.MIRROR_ENABLED = builder.define("enable_mirror_enchantment", true);
        this.FLYING_ENABLED = builder.define("enable_flying_enchantment", true);
        this.LORD_OF_THE_SEA_ENABLED = builder.define("enable_lord_of_the_sea_enchantment", true);
        this.FIREFLASH_ENABLED = builder.define("enable_fireflash_enchantment", true);
        this.FIREFLASH_DESTROYS_BLOCKS = builder.define("fireflash_destroys_blocks", true);
        this.DAYBREAK_ENABLED = builder.define("enable_daybreak_enchantment", true);
        this.RAISING_ENABLED = builder.define("enable_raising_enchantment", true);
        this.PRISONER_ENABLED = builder.define("enable_prisoner_effect", true);
        this.PRISONER_DURATION = builder.defineInRange("prisoner_effect_duration", 1200, 0, 24000);
        this.SWINE_ENABLED = builder.define("enable_swine_effect", true);
        this.SWINE_DROPS_ARMOR = builder.comment("Whether players under the swine effect drop their armor").define("swine_drops_armor", true);
        this.SWINE_PREVENTS_TARGET = builder.comment("Whether some monsters ignore players under the swine effect").define("swine_prevents_target", true);
        this.IS_SWINE_ENTITY_WHITELIST = builder.define("is_swine_entity_whitelist", true);
        List<String> swineWhitelist = GFConfig.entitiesAsList(EntityType.field_200729_aH, EntityType.field_200756_av, EntityType.field_200725_aD, EntityType.field_200727_aF, EntityType.field_200763_C, EntityType.field_200758_ax, EntityType.field_220351_aK, EntityType.field_200764_D, EntityType.field_220350_aJ);
        Collections.addAll(swineWhitelist, "greekfantasy:ara", "greekfantasy:dryad", "greekfantasy:naiad", "greekfantasy:satyr");
        this.SWINE_ENTITY_WHITELIST = builder.defineList("swine_entity_whitelist", swineWhitelist, o -> o instanceof String);
        this.NERF_STUNNING = builder.comment("When true, replaces stunning with Slowness I and Weakness I").define("nerf_stunning", false);
        this.NERF_PARALYSIS = builder.comment("When true, replaces paralysis with Slowness II and Weakness II").define("nerf_paralysis", false);
        builder.pop();
        builder.push("potions");
        this.MIRROR_POTION = builder.comment("Whether the Potion of Mirroring can prevent paralysis").define("enable_mirror_potion", true);
        this.SWINE_POTION = builder.comment("Whether the Potion of Swine can turn players into pigs").define("enable_swine_potion", true);
        builder.pop();
        builder.push("mob_abilities");
        this.DRAKAINA_ATTACK = builder.comment("Whether the Drakaina can use special attacks based on variant").define("drakaina_attack", true);
        this.EMPUSA_ATTACK = builder.comment("Whether the Empusa can drain health").define("empusa_attack", true);
        this.FURY_ATTACK = builder.comment("Whether the Fury can throw curses").define("fury_attack", true);
        this.GORGON_ATTACK = builder.comment("Whether the Gorgon can stun players by staring").define("gorgon_attack", true);
        this.MINOTAUR_ATTACK = builder.comment("Whether the Minotaur can charge and stun players").define("minotaur_attack", true);
        this.ORTHUS_ATTACK = builder.comment("Whether the Orthus can shoot fire").define("orthus_attack", true);
        this.SATYR_ATTACK = builder.comment("Whether the Satyr Shaman can summon wolves").define("satyr_attack", true);
        this.SHADE_ATTACK = builder.comment("Whether the Shade can steal player XP").define("shade_attack", true);
        this.SIREN_ATTACK = builder.comment("Whether the Siren can charm players").define("siren_attack", true);
        this.WHIRL_INVULNERABLE = builder.comment("Whether the Whirl is invulnerable to damage").define("whirl_invulnerable", false);
        this.DRYAD_ANGRY_ON_HARVEST = builder.comment("Whether harvesting log blocks angers nearby dryads").define("dryad_angry_on_harvest", true);
        this.DRYAD_ANGRY_RANGE = builder.comment("The distance at which dryads become angry when players harvest logs").defineInRange("dryad_angry_range", 6, 0, 32);
        this.SATYR_LIGHTS_CAMPFIRES = builder.comment("Whether the Satyr can light unlit campfires").define("satyr_lights_campfires", true);
        this.SATYR_SONG = builder.comment("The song played by the Satyr while dancing").define("satyr_song", (Object)"greekfantasy:greensleeves");
        this.SHADE_PLAYER_ONLY = builder.comment("Whether shades that spawn when a player dies can only be killed by that player").define("shade_player_only", true);
        this.SPARTI_LIFESPAN = builder.comment("Number of seconds until the Sparti begins taking damage").defineInRange("sparti_lifespan", 300, 1, 8000);
        this.WHIRL_LIFESPAN = builder.comment("Number of seconds until a summoned Whirl begins taking damage").defineInRange("whirl_lifespan", 60, 1, 8000);
        builder.pop();
        builder.push("mob_spawn_specials");
        this.SHADE_SPAWN_ON_DEATH = builder.comment("Whether a shade can spawn when players die").define("shade_spawn_on_death", true);
        this.SATYR_SHAMAN_CHANCE = builder.comment("Percent chance that a satyr will be a shaman").defineInRange("satyr_shaman_chance", 24, 0, 100);
        this.GORGON_MEDUSA_CHANCE = builder.comment("Percent chance that a gorgon will be a medusa").defineInRange("gorgon_medusa_chance", 0.8, 0.0, 100.0);
        this.LIGHTNING_MEDUSA_CHANCE = builder.comment("Percent chance that lightning striking a gorgon will turn it into a medusa").defineInRange("lightning_medusa_chance", 95.0, 0.0, 100.0);
        this.LIGHTNING_LION_CHANCE = builder.comment("Percent chance that lightning striking an ocelot will turn it into a nemean lion").defineInRange("lightning_lion_chance", 90.0, 0.0, 100.0);
        this.CIRCE_CHANCE = builder.comment("Percent chance that a witch will be a Circe").defineInRange("circe_chance", 2.0, 0.0, 100.0);
        this.GOLDEN_RAM_CHANCE = builder.comment("Percent chance that a yellow sheep will be a Golden Ram").defineInRange("golden_ram_chance", 5.0, 0.0, 100.0);
        this.MEDUSA_BOSS_BAR = builder.comment("Whether to show the Medusa boss bar").define("medusa_boss_bar", true);
        this.CIRCE_BOSS_BAR = builder.comment("Whether to show the Circe boss bar").define("circe_boss_bar", true);
        this.ARACHNE_BOSS_BAR = builder.comment("Whether to show the Arachne boss bar").define("arachne_boss_bar", false);
        this.CRETAN_BOSS_BAR = builder.comment("Whether to show the Cretan Minotaur boss bar").define("cretan_boss_bar", true);
        this.NEMEAN_LION_BOSS_BAR = builder.comment("Whether to show the Nemean Lion boss bar").define("nemean_lion_boss_bar", true);
        this.ELPIS_SPAWN_CHANCE = builder.comment("Percent chance that opening a mysterious box spawns an Elpis").defineInRange("elpis_spawn_chance", 60, 0, 100);
        this.NUM_SPARTI_SPAWNED = builder.comment("Number of Sparti spawned by using a hydra tooth").defineInRange("num_sparti_spawned", 1, 1, 8);
        this.GIANT_BOAR_NON_NETHER = builder.comment("Whether a hoglin must be outside of the nether to be turned to a Giant Boar").define("giant_boar_non_nether", true);
        builder.pop();
        builder.push("palladium");
        this.PALLADIUM_ENABLED = builder.comment("Whether the Palladium can prevent monster spawns").define("palladium_enabled", true);
        this.PALLADIUM_REFRESH_INTERVAL = builder.comment("The number of server ticks between Palladium updates (increase to reduce lag)").defineInRange("palladium_refresh_interval", 110, 2, 1000);
        this.PALLADIUM_CHUNK_RANGE = builder.comment("The radius (in chunks) of the area protected by Palladium blocks (0=same chunk only)").defineInRange("palladium_chunk_range", 2, 0, 3);
        this.PALLADIUM_Y_RANGE = builder.comment("The vertical area (in blocks) protected by Palladium blocks").defineInRange("palladium_y_range", 128, 0, 255);
        builder.pop();
        builder.push("favor");
        this.FAVOR_ENABLED = builder.comment("Set to false to disable all favor and gods").define("favor_enabled", true);
        this.FAVOR_NOTIFY = builder.comment("Set to false to disable favor notification messages").define("favor_notify", true);
        this.FAVOR_NOTIFY_CHAT = builder.comment("Set to false to display favor notification messages in HUD instead of chat").define("favor_notify_chat", true);
        this.FAVOR_DECREASES = builder.comment("Whether favor tends toward zero over time").define("favor_decreases", true);
        this.FAVOR_DECREASE_INTERVAL = builder.comment("Number of ticks between decreasing favor, if enabled").defineInRange("favor_decrease_interval", 4000L, 1L, 96000L);
        builder.pop();
        builder.comment("mob spawn weights (higher number = more spawns)").push("mob_spawns");
        ArrayList<String> dimensions = new ArrayList<String>();
        dimensions.add(Dimension.field_236053_b_.func_240901_a_().toString());
        dimensions.add(Dimension.field_236054_c_.func_240901_a_().toString());
        this.IS_SPAWNS_WHITELIST = builder.worldRestart().define("whitelist_dimensions", true);
        this.SPAWNS_DIMENSION_WHITELIST = builder.worldRestart().define("dimensions", dimensions);
        String[] forest = new String[]{BiomeDictionary.Type.FOREST.toString(), BiomeDictionary.Type.CONIFEROUS.toString(), BiomeDictionary.Type.JUNGLE.toString()};
        String[] hostileBlacklist = new String[]{BiomeDictionary.Type.END.toString(), BiomeDictionary.Type.WATER.toString(), BiomeDictionary.Type.COLD.toString(), BiomeDictionary.Type.SNOWY.toString(), BiomeDictionary.Type.MUSHROOM.toString()};
        String[] nonNetherHostileBlacklist = new String[]{BiomeDictionary.Type.NETHER.toString(), BiomeDictionary.Type.END.toString(), BiomeDictionary.Type.WATER.toString(), BiomeDictionary.Type.COLD.toString(), BiomeDictionary.Type.SNOWY.toString(), BiomeDictionary.Type.MUSHROOM.toString()};
        this.MOB_SPAWNS.put("ara", new BiomeWhitelistConfig(builder, "ara_spawn", 10, false, nonNetherHostileBlacklist));
        this.MOB_SPAWNS.put("centaur", new BiomeWhitelistConfig(builder, "centaur_spawn", 15, true, BiomeDictionary.Type.PLAINS.toString(), BiomeDictionary.Type.CONIFEROUS.toString()));
        this.MOB_SPAWNS.put("cerastes", new BiomeWhitelistConfig(builder, "cerastes_spawn", 30, true, Biomes.field_76769_d.func_240901_a_().toString(), Biomes.field_185442_R.func_240901_a_().toString(), Biomes.field_76786_s.func_240901_a_().toString()));
        this.MOB_SPAWNS.put("cyclopes", new BiomeWhitelistConfig(builder, "cyclopes_spawn", 20, true, BiomeDictionary.Type.MOUNTAIN.toString(), BiomeDictionary.Type.PLATEAU.toString()));
        this.MOB_SPAWNS.put("cyprian", new BiomeWhitelistConfig(builder, "cyprian_spawn", 15, true, BiomeDictionary.Type.PLAINS.toString(), BiomeDictionary.Type.CONIFEROUS.toString()));
        this.MOB_SPAWNS.put("drakaina", new BiomeWhitelistConfig(builder, "drakaina_spawn", 45, false, hostileBlacklist));
        this.MOB_SPAWNS.put("dryad", new BiomeWhitelistConfig(builder, "dryad_spawn", 24, true, forest));
        this.MOB_SPAWNS.put("empusa", new BiomeWhitelistConfig(builder, "empusa_spawn", 30, false, nonNetherHostileBlacklist));
        this.MOB_SPAWNS.put("fury", new BiomeWhitelistConfig(builder, "fury_spawn", 9, true, Biomes.field_235254_j_.func_240901_a_().toString()));
        this.MOB_SPAWNS.put("gigante", new BiomeWhitelistConfig(builder, "gigante_spawn", 10, true, BiomeDictionary.Type.MOUNTAIN.toString(), Biomes.field_76774_n.func_240901_a_().toString()));
        this.MOB_SPAWNS.put("gorgon", new BiomeWhitelistConfig(builder, "gorgon_spawn", 30, false, nonNetherHostileBlacklist));
        this.MOB_SPAWNS.put("harpy", new BiomeWhitelistConfig(builder, "harpy_spawn", 24, true, Biomes.field_76769_d.func_240901_a_().toString(), Biomes.field_150580_W.func_240901_a_().toString()));
        this.MOB_SPAWNS.put("hydra", new BiomeWhitelistConfig(builder, "hydra_spawn", 8, true, BiomeDictionary.Type.SAVANNA.toString(), BiomeDictionary.Type.SWAMP.toString()));
        this.MOB_SPAWNS.put("lampad", new BiomeWhitelistConfig(builder, "lampad_spawn", 40, true, Biomes.field_235253_az_.func_240901_a_().toString(), Biomes.field_235250_aA_.func_240901_a_().toString()));
        this.MOB_SPAWNS.put("mad_cow", new BiomeWhitelistConfig(builder, "mad_cow_spawn", 2, false, nonNetherHostileBlacklist));
        this.MOB_SPAWNS.put("makhai", new BiomeWhitelistConfig(builder, "makhai_spawn", 25, false, new String[0]));
        this.MOB_SPAWNS.put("minotaur", new BiomeWhitelistConfig(builder, "minotaur_spawn", 60, false, nonNetherHostileBlacklist));
        this.MOB_SPAWNS.put("naiad", new BiomeWhitelistConfig(builder, "naiad_spawn", 12, true, BiomeDictionary.Type.WATER.toString()));
        this.MOB_SPAWNS.put("orthus", new BiomeWhitelistConfig(builder, "orthus_spawn", 20, true, BiomeDictionary.Type.NETHER.toString()));
        this.MOB_SPAWNS.put("pegasus", new BiomeWhitelistConfig(builder, "pegasus_spawn", 11, true, BiomeDictionary.Type.MOUNTAIN.toString(), Biomes.field_185441_Q.func_240901_a_().toString(), Biomes.field_185444_T.func_240901_a_().toString()));
        this.MOB_SPAWNS.put("satyr", new BiomeWhitelistConfig(builder, "satyr_spawn", 22, true, forest));
        this.MOB_SPAWNS.put("shade", new BiomeWhitelistConfig(builder, "shade_spawn", 10, false, new String[0]));
        this.MOB_SPAWNS.put("siren", new BiomeWhitelistConfig(builder, "siren_spawn", 10, true, Biomes.field_203615_U.func_240901_a_().toString(), Biomes.field_203614_T.func_240901_a_().toString()));
        this.MOB_SPAWNS.put("unicorn", new BiomeWhitelistConfig(builder, "unicorn_spawn", 11, true, Biomes.field_185441_Q.func_240901_a_().toString(), Biomes.field_185444_T.func_240901_a_().toString()));
        this.MOB_SPAWNS.put("whirl", new BiomeWhitelistConfig(builder, "whirl_spawn", 6, true, BiomeDictionary.Type.OCEAN.toString()));
        builder.pop();
        builder.comment("feature generation chances (higher number = more features)").push("features");
        this.IS_FEATURES_WHITELIST = builder.worldRestart().define("whitelist_dimensions", true);
        this.FEATURES_DIMENSION_WHITELIST = builder.worldRestart().define("dimensions", dimensions);
        this.OLIVE_FOREST_BIOME_WEIGHT = builder.defineInRange("olive_forest_weight", 9, 0, 1000);
        this.FEATURES.put("limestone", new BiomeWhitelistConfig(builder, "limestone", 1000, true, BiomeDictionary.Type.OVERWORLD.toString()));
        this.FEATURES.put("marble", new BiomeWhitelistConfig(builder, "marble", 1000, true, BiomeDictionary.Type.OVERWORLD.toString()));
        this.FEATURES.put("harpy_nest", new BiomeWhitelistConfig(builder, "harpy_nest", 12, false, nonNetherHostileBlacklist));
        this.FEATURES.put("small_shrine", new BiomeWhitelistConfig(builder, "small_shrine", 17, false, nonNetherHostileBlacklist));
        this.FEATURES.put("small_nether_shrine", new BiomeWhitelistConfig(builder, "small_nether_shrine", 30, true, Biomes.field_235252_ay_.func_240901_a_().toString(), Biomes.field_235254_j_.func_240901_a_().toString()));
        this.FEATURES.put("cyclopes_cave", new BiomeWhitelistConfig(builder, "cyclopes_cave", 8, true, BiomeDictionary.Type.PLAINS.toString()));
        this.FEATURES.put("ara_camp", new BiomeWhitelistConfig(builder, "ara_camp", 10, false, nonNetherHostileBlacklist));
        this.FEATURES.put("satyr_camp", new BiomeWhitelistConfig(builder, "satyr_camp", 15, false, nonNetherHostileBlacklist));
        this.FEATURES.put("python_pit", new BiomeWhitelistConfig(builder, "python_pit", 6, true, BiomeDictionary.Type.JUNGLE.toString()));
        this.FEATURES.put("reeds", new BiomeWhitelistConfig(builder, "reeds", 250, false, nonNetherHostileBlacklist));
        this.FEATURES.put("reeds_swamp", new BiomeWhitelistConfig(builder, "reeds_swamp", 900, true, BiomeDictionary.Type.SWAMP.toString()));
        this.FEATURES.put("olive_tree_single", new BiomeWhitelistConfig(builder, "olive_tree_single", 22, true, BiomeDictionary.Type.FOREST.toString()));
        this.FEATURES.put("pomegranate_tree", new BiomeWhitelistConfig(builder, "pomegranate_tree", 40, true, Biomes.field_235253_az_.func_240901_a_().toString(), Biomes.field_235250_aA_.func_240901_a_().toString()));
        this.FEATURES.put("lion_den", new BiomeWhitelistConfig(builder, "lion_den", 9, true, Biomes.field_76769_d.func_240901_a_().toString(), Biomes.field_76786_s.func_240901_a_().toString()));
        this.FEATURES.put("arachne_pit", new BiomeWhitelistConfig(builder, "arachne_pit", 82, false, nonNetherHostileBlacklist));
        builder.pop();
    }

    public void bake() {
        this.helmHidesArmor = (Boolean)this.HELM_HIDES_ARMOR.get();
        this.dragonToothSpawnsSparti = (Boolean)this.DRAGON_TOOTH_SPAWNS_SPARTI.get();
        this.swordOfHuntBypassesArmor = (Boolean)this.SWORD_OF_HUNT_BYPASSES_ARMOR.get();
        this.healingRodCooldown = (Integer)this.HEALING_ROD_COOLDOWN.get();
        this.thunderboltStormsOnly = (Boolean)this.THUNDERBOLT_STORMS_ONLY.get();
        this.thunderboltCooldown = (Integer)this.THUNDERBOLT_COOLDOWN.get();
        this.conchEnabled = (Boolean)this.CONCH_ENABLED.get();
        this.conchCooldown = (Integer)this.CONCH_COOLDOWN.get();
        this.bagOfWindDuration = (Integer)this.BAG_OF_WIND_DURATION.get();
        this.bagOfWindCooldown = (Integer)this.BAG_OF_WIND_COOLDOWN.get();
        this.swineWandDuration = (Integer)this.SWINE_WAND_DURATION.get();
        this.swineWandCooldown = (Integer)this.SWINE_WAND_COOLDOWN.get();
        this.wingedSandalsDeplete = (Boolean)this.WINGED_SANDALS_DEPLETE.get();
        this.forceFOVReset = (Boolean)this.FORCE_FOV_RESET.get();
        this.stunPreventsJump = (Boolean)this.STUN_PREVENTS_JUMP.get();
        this.stunPreventsUse = (Boolean)this.STUN_PREVENTS_USE.get();
        this.overstepEnabled = (Boolean)this.OVERSTEP_ENABLED.get();
        this.silkwalkerEnabled = (Boolean)this.SILKWALKER_ENABLED.get();
        this.smashingEnabled = (Boolean)this.SMASHING_ENABLED.get();
        this.huntingEnabled = (Boolean)this.HUNTING_ENABLED.get();
        this.poisonEnabled = (Boolean)this.POISON_ENABLED.get();
        this.mirrorEnabled = (Boolean)this.MIRROR_ENABLED.get();
        this.flyingEnabled = (Boolean)this.FLYING_ENABLED.get();
        this.lordOfTheSeaEnabled = (Boolean)this.LORD_OF_THE_SEA_ENABLED.get();
        this.fireflashEnabled = (Boolean)this.FIREFLASH_ENABLED.get();
        this.fireflashDestroysBlocks = (Boolean)this.FIREFLASH_DESTROYS_BLOCKS.get();
        this.daybreakEnabled = (Boolean)this.DAYBREAK_ENABLED.get();
        this.raisingEnabled = (Boolean)this.RAISING_ENABLED.get();
        this.prisonerEnabled = (Boolean)this.PRISONER_ENABLED.get();
        this.prisonerDuration = (Integer)this.PRISONER_DURATION.get();
        this.swineEnabled = (Boolean)this.SWINE_ENABLED.get();
        this.swineDropsArmor = (Boolean)this.SWINE_DROPS_ARMOR.get();
        this.swinePreventsTarget = (Boolean)this.SWINE_PREVENTS_TARGET.get();
        this.mirrorPotion = (Boolean)this.MIRROR_POTION.get();
        this.swinePotion = (Boolean)this.SWINE_POTION.get();
        this.shadeSpawnOnDeath = (Boolean)this.SHADE_SPAWN_ON_DEATH.get();
        this.satyrShamanChance = (Integer)this.SATYR_SHAMAN_CHANCE.get();
        this.gorgonMedusaChance = (Double)this.GORGON_MEDUSA_CHANCE.get();
        this.lightningMedusaChance = (Double)this.LIGHTNING_MEDUSA_CHANCE.get();
        this.lightningLionChance = (Double)this.LIGHTNING_LION_CHANCE.get();
        this.circeChance = (Double)this.CIRCE_CHANCE.get();
        this.goldenRamChance = (Double)this.GOLDEN_RAM_CHANCE.get();
        this.elpisSpawnChance = (Integer)this.ELPIS_SPAWN_CHANCE.get();
        this.numSpartiSpawned = (Integer)this.NUM_SPARTI_SPAWNED.get();
        this.medusaBossBar = (Boolean)this.MEDUSA_BOSS_BAR.get();
        this.circeBossBar = (Boolean)this.CIRCE_BOSS_BAR.get();
        this.arachneBossBar = (Boolean)this.ARACHNE_BOSS_BAR.get();
        this.cretanBossBar = (Boolean)this.CRETAN_BOSS_BAR.get();
        this.nemeanLionBossBar = (Boolean)this.NEMEAN_LION_BOSS_BAR.get();
        this.giantBoarNonNether = (Boolean)this.GIANT_BOAR_NON_NETHER.get();
        this.dryadAngryOnHarvest = (Boolean)this.DRYAD_ANGRY_ON_HARVEST.get();
        this.dryadAngryRange = (Integer)this.DRYAD_ANGRY_RANGE.get();
        this.whirlInvulnerable = (Boolean)this.WHIRL_INVULNERABLE.get();
        this.spartiLifespan = (Integer)this.SPARTI_LIFESPAN.get();
        this.whirlLifespan = (Integer)this.WHIRL_LIFESPAN.get();
        this.satyrSong = new ResourceLocation((String)this.SATYR_SONG.get());
        this.nerfStunning = (Boolean)this.NERF_STUNNING.get();
        this.nerfParalysis = (Boolean)this.NERF_PARALYSIS.get();
        this.palladiumEnabled = (Boolean)this.PALLADIUM_ENABLED.get();
        this.palladiumRefreshInterval = (Integer)this.PALLADIUM_REFRESH_INTERVAL.get();
        this.palladiumChunkRange = (Integer)this.PALLADIUM_CHUNK_RANGE.get();
        this.palladiumYRange = (Integer)this.PALLADIUM_Y_RANGE.get();
        this.favorEnabled = (Boolean)this.FAVOR_ENABLED.get();
        this.favorNotify = (Boolean)this.FAVOR_NOTIFY.get();
        this.favorNotifyChat = (Boolean)this.FAVOR_NOTIFY_CHAT.get();
        this.favorDecreases = (Boolean)this.FAVOR_DECREASES.get();
        this.favorDecreaseInterval = (Long)this.FAVOR_DECREASE_INTERVAL.get();
    }

    public boolean doesHelmHideArmor() {
        return this.helmHidesArmor;
    }

    public boolean doesDragonToothSpawnSparti() {
        return this.dragonToothSpawnsSparti;
    }

    public boolean doesSwordOfHuntBypassArmor() {
        return this.swordOfHuntBypassesArmor;
    }

    public boolean doesWingedSandalsDeplete() {
        return this.wingedSandalsDeplete;
    }

    public int getHealingRodCooldown() {
        return this.healingRodCooldown;
    }

    public boolean isThunderboltStormsOnly() {
        return this.thunderboltStormsOnly;
    }

    public int getThunderboltCooldown() {
        return this.thunderboltCooldown;
    }

    public boolean isConchEnabled() {
        return this.conchEnabled;
    }

    public int getConchCooldown() {
        return this.conchCooldown;
    }

    public int getBagOfWindDuration() {
        return this.bagOfWindDuration;
    }

    public int getBagOfWindCooldown() {
        return this.bagOfWindCooldown;
    }

    public int getSwineWandDuration() {
        return this.swineWandDuration;
    }

    public int getSwineWandCooldown() {
        return this.swineWandCooldown;
    }

    public boolean doesStunPreventJump() {
        return this.stunPreventsJump;
    }

    public boolean doesStunPreventUse() {
        return this.stunPreventsUse;
    }

    public boolean isForceFOVReset() {
        return this.forceFOVReset;
    }

    public boolean isOverstepEnabled() {
        return this.overstepEnabled;
    }

    public boolean isSilkwalkerEnabled() {
        return this.silkwalkerEnabled;
    }

    public boolean isSmashingEnabled() {
        return this.smashingEnabled;
    }

    public boolean isHuntingEnabled() {
        return this.huntingEnabled;
    }

    public boolean isPoisonEnabled() {
        return this.poisonEnabled;
    }

    public boolean isMirrorEnabled() {
        return this.mirrorEnabled;
    }

    public boolean isPrisonerEnabled() {
        return this.prisonerEnabled;
    }

    public int getPrisonerDuration() {
        return this.prisonerDuration;
    }

    public boolean isSwineEnabled() {
        return this.swineEnabled;
    }

    public boolean doesSwineDropArmor() {
        return this.swineDropsArmor;
    }

    public boolean doesSwinePreventTarget() {
        return this.swinePreventsTarget;
    }

    public boolean isFlyingEnabled() {
        return this.flyingEnabled;
    }

    public boolean isLordOfTheSeaEnabled() {
        return this.lordOfTheSeaEnabled;
    }

    public boolean isFireflashEnabled() {
        return this.fireflashEnabled;
    }

    public boolean isRaisingEnabled() {
        return this.raisingEnabled;
    }

    public boolean doesFireflashDestroyBlocks() {
        return this.fireflashDestroysBlocks;
    }

    public boolean isDaybreakEnabled() {
        return this.daybreakEnabled;
    }

    public boolean isMirrorPotionEnabled() {
        return this.mirrorPotion;
    }

    public boolean isSwinePotionEnabled() {
        return this.swinePotion;
    }

    public boolean doesShadeSpawnOnDeath() {
        return this.shadeSpawnOnDeath;
    }

    public int getSatyrShamanChance() {
        return this.satyrShamanChance;
    }

    public ResourceLocation getSatyrSong() {
        return this.satyrSong;
    }

    public double getGorgonMedusaChance() {
        return this.gorgonMedusaChance;
    }

    public double getLightningMedusaChance() {
        return this.lightningMedusaChance;
    }

    public double getLightningLionChance() {
        return this.lightningLionChance;
    }

    public double getCirceChance() {
        return this.circeChance;
    }

    public double getGoldenRamChance() {
        return this.goldenRamChance;
    }

    public int getElpisSpawnChance() {
        return this.elpisSpawnChance;
    }

    public int getNumSpartiSpawned() {
        return this.numSpartiSpawned;
    }

    public boolean showMedusaBossBar() {
        return this.medusaBossBar;
    }

    public boolean showCirceBossBar() {
        return this.circeBossBar;
    }

    public boolean showArachneBossBar() {
        return this.arachneBossBar;
    }

    public boolean showCretanBossBar() {
        return this.cretanBossBar;
    }

    public boolean showNemeanLionBossBar() {
        return this.nemeanLionBossBar;
    }

    public boolean getGiantBoarNonNether() {
        return this.giantBoarNonNether;
    }

    public boolean isWhirlInvulnerable() {
        return this.whirlInvulnerable;
    }

    public boolean isDryadAngryOnHarvest() {
        return this.dryadAngryOnHarvest;
    }

    public int getDryadAngryRange() {
        return this.dryadAngryRange;
    }

    public int getSpartiLifespan() {
        return this.spartiLifespan;
    }

    public int getWhirlLifespan() {
        return this.whirlLifespan;
    }

    public boolean isStunningNerf() {
        return this.nerfStunning;
    }

    public boolean isParalysisNerf() {
        return this.nerfParalysis;
    }

    public boolean isPalladiumEnabled() {
        return this.palladiumEnabled;
    }

    public int getPalladiumRefreshInterval() {
        return this.palladiumRefreshInterval;
    }

    public int getPalladiumChunkRange() {
        return this.palladiumChunkRange;
    }

    public int getPalladiumYRange() {
        return this.palladiumYRange;
    }

    public boolean isFavorEnabled() {
        return this.favorEnabled;
    }

    public boolean isFavorNotifyEnabled() {
        return this.favorNotify;
    }

    public boolean isFavorNotifyChat() {
        return this.favorNotifyChat;
    }

    public boolean doesFavorDecrease() {
        return this.favorDecreases;
    }

    public long getFavorDecreaseInterval() {
        return this.favorDecreaseInterval;
    }

    public boolean canSwineApply(String entityName) {
        return ((Boolean)this.IS_SWINE_ENTITY_WHITELIST.get()).booleanValue() == ((List)this.SWINE_ENTITY_WHITELIST.get()).contains(entityName);
    }

    private static List<String> entitiesAsList(EntityType<?> ... types) {
        ArrayList<String> list = new ArrayList<String>();
        for (EntityType<?> t : types) {
            list.add(t.getRegistryName().toString());
        }
        return list;
    }
}

