/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy;

import com.mojang.serialization.Codec;
import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.feature.AraCampFeature;
import greekfantasy.feature.ArachnePitFeature;
import greekfantasy.feature.CyclopesCaveFeature;
import greekfantasy.feature.GoldenAppleTree;
import greekfantasy.feature.HarpyNestFeature;
import greekfantasy.feature.LionDenFeature;
import greekfantasy.feature.OliveTree;
import greekfantasy.feature.OliveTreeFeature;
import greekfantasy.feature.PomegranateTree;
import greekfantasy.feature.PomegranateTreeFeature;
import greekfantasy.feature.PythonPitFeature;
import greekfantasy.feature.ReedsFeature;
import greekfantasy.feature.SatyrCampFeature;
import greekfantasy.feature.SmallNetherShrineFeature;
import greekfantasy.feature.SmallShrineFeature;
import greekfantasy.util.BiomeWhitelistConfig;
import net.minecraft.entity.EntityType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.DoublePlantBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.TagMatchRuleTest;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilders;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

public final class GFWorldGen {
    private static final String MODID = "greekfantasy";
    @ObjectHolder(value="greekfantasy:harpy_nest")
    public static final Feature<NoFeatureConfig> HARPY_NEST_FEATURE = null;
    @ObjectHolder(value="greekfantasy:small_shrine")
    public static final Feature<NoFeatureConfig> SMALL_SHRINE_FEATURE = null;
    @ObjectHolder(value="greekfantasy:small_nether_shrine")
    public static final Feature<NoFeatureConfig> SMALL_NETHER_SHRINE_FEATURE = null;
    @ObjectHolder(value="greekfantasy:cyclopes_cave")
    public static final Feature<NoFeatureConfig> CYCLOPES_CAVE_FEATURE = null;
    @ObjectHolder(value="greekfantasy:ara_camp")
    public static final Feature<NoFeatureConfig> ARA_CAMP_FEATURE = null;
    @ObjectHolder(value="greekfantasy:satyr_camp")
    public static final Feature<NoFeatureConfig> SATYR_CAMP_FEATURE = null;
    @ObjectHolder(value="greekfantasy:python_pit")
    public static final Feature<NoFeatureConfig> PYTHON_PIT_FEATURE = null;
    @ObjectHolder(value="greekfantasy:lion_den")
    public static final Feature<NoFeatureConfig> LION_DEN_FEATURE = null;
    @ObjectHolder(value="greekfantasy:arachne_pit")
    public static final Feature<NoFeatureConfig> ARACHNE_PIT_FEATURE = null;
    @ObjectHolder(value="greekfantasy:olive_tree")
    public static final Feature<BaseTreeFeatureConfig> OLIVE_TREE_FEATURE = null;
    @ObjectHolder(value="greekfantasy:pomegranate_tree")
    public static final Feature<BaseTreeFeatureConfig> POMEGRANATE_TREE_FEATURE = null;
    @ObjectHolder(value="greekfantasy:golden_apple_tree")
    public static final Feature<BaseTreeFeatureConfig> GOLDEN_APPLE_TREE_FEATURE = null;
    @ObjectHolder(value="greekfantasy:reeds")
    public static final Feature<BlockClusterFeatureConfig> REEDS_FEATURE = null;
    @ObjectHolder(value="greekfantasy:olive_forest")
    public static final Biome OLIVE_FOREST_BIOME = null;
    public static RegistryKey<Biome> OLIVE_FOREST = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("greekfantasy", "olive_forest"));
    private static ConfiguredFeature<?, ?> MARBLE;
    private static ConfiguredFeature<?, ?> LIMESTONE;
    private static ConfiguredFeature<?, ?> HARPY_NEST;
    private static ConfiguredFeature<?, ?> SMALL_SHRINE;
    private static ConfiguredFeature<?, ?> SMALL_NETHER_SHRINE;
    private static ConfiguredFeature<?, ?> CYCLOPES_CAVE;
    private static ConfiguredFeature<?, ?> ARA_CAMP;
    private static ConfiguredFeature<?, ?> SATYR_CAMP;
    private static ConfiguredFeature<?, ?> LION_DEN;
    private static ConfiguredFeature<?, ?> ARACHNE_PIT;
    private static ConfiguredFeature<?, ?> PYTHON_PIT;
    private static ConfiguredFeature<?, ?> OLIVE_TREE_SINGLE;
    private static ConfiguredFeature<?, ?> OLIVE_TREE_FOREST;
    private static ConfiguredFeature<?, ?> POMEGRANATE_TREE;
    private static ConfiguredFeature<?, ?> GOLDEN_APPLE_TREE;
    private static ConfiguredFeature<?, ?> REEDS;
    private static ConfiguredFeature<?, ?> SWAMP_REEDS;
    private static final RuleTest ruleTestStone;

    private GFWorldGen() {
    }

    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        Biome oliveForestBiome = (Biome)GFWorldGen.makeOliveForest(0.1f, 0.16f).setRegistryName(new ResourceLocation(MODID, "olive_forest"));
        event.getRegistry().register((IForgeRegistryEntry)oliveForestBiome);
    }

    @SubscribeEvent
    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        GreekFantasy.LOGGER.debug("registerFeatures");
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Feature[]{(Feature)new HarpyNestFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_).setRegistryName(MODID, "harpy_nest"), (Feature)new SmallShrineFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_).setRegistryName(MODID, "small_shrine"), (Feature)new SmallNetherShrineFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_).setRegistryName(MODID, "small_nether_shrine"), (Feature)new CyclopesCaveFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_).setRegistryName(MODID, "cyclopes_cave"), (Feature)new AraCampFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_).setRegistryName(MODID, "ara_camp"), (Feature)new SatyrCampFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_).setRegistryName(MODID, "satyr_camp"), (Feature)new PythonPitFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_).setRegistryName(MODID, "python_pit"), (Feature)new LionDenFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_).setRegistryName(MODID, "lion_den"), (Feature)new ArachnePitFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_).setRegistryName(MODID, "arachne_pit"), (Feature)new OliveTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_).setRegistryName(MODID, "olive_tree"), (Feature)new PomegranateTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_).setRegistryName(MODID, "pomegranate_tree"), (Feature)new TreeFeature(BaseTreeFeatureConfig.field_236676_a_).setRegistryName(MODID, "golden_apple_tree"), (Feature)new ReedsFeature((Codec<BlockClusterFeatureConfig>)BlockClusterFeatureConfig.field_236587_a_).setRegistryName(MODID, "reeds")});
    }

    public static void finishBiomeSetup() {
        int biomeWeight = (Integer)GreekFantasy.CONFIG.OLIVE_FOREST_BIOME_WEIGHT.get();
        if (biomeWeight > 0) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(OLIVE_FOREST, biomeWeight));
            BiomeDictionary.addTypes(OLIVE_FOREST, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD});
        }
    }

    public static void registerConfiguredFeatures() {
        GreekFantasy.LOGGER.debug("registerConfiguredFeatures");
        MARBLE = GFWorldGen.registerFeature("marble", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(ruleTestStone, GFRegistry.MARBLE.func_176223_P(), 33)).func_242733_d(80)).func_242728_a()).func_242731_b(10));
        LIMESTONE = GFWorldGen.registerFeature("limestone", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(ruleTestStone, GFRegistry.LIMESTONE.func_176223_P(), 33)).func_242733_d(80)).func_242728_a()).func_242731_b(10));
        HARPY_NEST = GFWorldGen.registerFeature("harpy_nest", HARPY_NEST_FEATURE.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244001_l));
        SMALL_SHRINE = GFWorldGen.registerFeature("small_shrine", SMALL_SHRINE_FEATURE.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244001_l));
        SMALL_NETHER_SHRINE = GFWorldGen.registerFeature("small_nether_shrine", SMALL_NETHER_SHRINE_FEATURE.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_202429_e));
        CYCLOPES_CAVE = GFWorldGen.registerFeature("cyclopes_cave", ((ConfiguredFeature)CYCLOPES_CAVE_FEATURE.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_202429_e).func_242729_a(3)).func_227228_a_(Features.Placements.field_244001_l));
        ARA_CAMP = GFWorldGen.registerFeature("ara_camp", ((ConfiguredFeature)ARA_CAMP_FEATURE.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_202429_e).func_242729_a(2)).func_227228_a_(Features.Placements.field_244001_l));
        SATYR_CAMP = GFWorldGen.registerFeature("satyr_camp", SATYR_CAMP_FEATURE.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244001_l));
        LION_DEN = GFWorldGen.registerFeature("lion_den", ((ConfiguredFeature)LION_DEN_FEATURE.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_202429_e).func_242729_a(2)).func_227228_a_(Features.Placements.field_244001_l));
        PYTHON_PIT = GFWorldGen.registerFeature("python_pit", PYTHON_PIT_FEATURE.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244001_l));
        ARACHNE_PIT = GFWorldGen.registerFeature("arachne_pit", ((ConfiguredFeature)ARACHNE_PIT_FEATURE.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_202429_e).func_242729_a(3)).func_227228_a_(Features.Placements.field_244001_l));
        OLIVE_TREE_SINGLE = GFWorldGen.registerFeature("olive_tree_single", (ConfiguredFeature)OliveTree.getConfiguredTree().func_227228_a_(Features.Placements.field_244000_k).func_242731_b(20));
        OLIVE_TREE_FOREST = (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation(MODID, "olive_tree"), (Object)OliveTree.getConfiguredTree().func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(10, 0.1f, 1))));
        POMEGRANATE_TREE = GFWorldGen.registerFeature("pomegranate_tree", (ConfiguredFeature)PomegranateTree.getConfiguredTree().func_227228_a_(Features.Placements.field_244000_k).func_242731_b(20));
        REEDS = GFWorldGen.registerFeature("reeds", (ConfiguredFeature)REEDS_FEATURE.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(GFRegistry.REEDS.func_176223_P()), (BlockPlacer)new DoublePlantBlockPlacer()).func_227315_a_(48).func_227314_a_().func_227318_b_(4).func_227323_d_(4).func_227322_d_()).func_242731_b(2));
        SWAMP_REEDS = GFWorldGen.registerFeature("reeds_swamp", (ConfiguredFeature)REEDS_FEATURE.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(GFRegistry.REEDS.func_176223_P()), (BlockPlacer)new DoublePlantBlockPlacer()).func_227315_a_(32).func_227314_a_().func_227318_b_(3).func_227321_c_(3).func_227323_d_(3).func_227322_d_()).func_242731_b(2));
        GOLDEN_APPLE_TREE = (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation(MODID, "golden_apple_tree"), (Object)GoldenAppleTree.getConfiguredTree().func_227228_a_(Features.Placements.field_244000_k));
    }

    private static ConfiguredFeature<?, ?> registerFeature(String name, ConfiguredFeature<?, ?> feature) {
        BiomeWhitelistConfig config = GreekFantasy.CONFIG.FEATURES.get(name);
        if (null == config) {
            GreekFantasy.LOGGER.error("Error registering features: config for '" + name + "' not found!");
        } else if (config.chance() > 0) {
            feature = (ConfiguredFeature)feature.func_242729_a(1000 / config.chance());
        }
        return (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation(MODID, name), (Object)feature);
    }

    public static void addBiomeFeatures(BiomeLoadingEvent event) {
        if (event.getCategory() == Biome.Category.NETHER) {
            GFWorldGen.addFeature(event, "small_nether_shrine", GenerationStage.Decoration.SURFACE_STRUCTURES, SMALL_NETHER_SHRINE);
            GFWorldGen.addFeature(event, "pomegranate_tree", GenerationStage.Decoration.VEGETAL_DECORATION, POMEGRANATE_TREE);
        } else if (event.getCategory() != Biome.Category.THEEND) {
            GFWorldGen.addFeature(event, "marble", GenerationStage.Decoration.UNDERGROUND_DECORATION, MARBLE);
            GFWorldGen.addFeature(event, "limestone", GenerationStage.Decoration.UNDERGROUND_DECORATION, LIMESTONE);
            GFWorldGen.addFeature(event, "harpy_nest", GenerationStage.Decoration.VEGETAL_DECORATION, HARPY_NEST);
            GFWorldGen.addFeature(event, "small_shrine", GenerationStage.Decoration.SURFACE_STRUCTURES, SMALL_SHRINE);
            GFWorldGen.addFeature(event, "cyclopes_cave", GenerationStage.Decoration.SURFACE_STRUCTURES, CYCLOPES_CAVE);
            GFWorldGen.addFeature(event, "ara_camp", GenerationStage.Decoration.SURFACE_STRUCTURES, ARA_CAMP);
            GFWorldGen.addFeature(event, "satyr_camp", GenerationStage.Decoration.SURFACE_STRUCTURES, SATYR_CAMP);
            GFWorldGen.addFeature(event, "lion_den", GenerationStage.Decoration.SURFACE_STRUCTURES, LION_DEN);
            GFWorldGen.addFeature(event, "python_pit", GenerationStage.Decoration.UNDERGROUND_STRUCTURES, PYTHON_PIT);
            GFWorldGen.addFeature(event, "arachne_pit", GenerationStage.Decoration.UNDERGROUND_STRUCTURES, ARACHNE_PIT);
            GFWorldGen.addFeature(event, "reeds", GenerationStage.Decoration.VEGETAL_DECORATION, REEDS);
            GFWorldGen.addFeature(event, "olive_tree_single", GenerationStage.Decoration.VEGETAL_DECORATION, OLIVE_TREE_SINGLE);
            GFWorldGen.addFeature(event, "reeds_swamp", GenerationStage.Decoration.VEGETAL_DECORATION, SWAMP_REEDS);
            if (OLIVE_FOREST.func_240901_a_().equals((Object)event.getName())) {
                event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, OLIVE_TREE_FOREST);
            }
        }
    }

    private static void addFeature(BiomeLoadingEvent event, String featureName, GenerationStage.Decoration stage, ConfiguredFeature<?, ?> feature) {
        BiomeWhitelistConfig config = GreekFantasy.CONFIG.FEATURES.get(featureName);
        if (null == config) {
            GreekFantasy.LOGGER.error("Error registering features: config for '" + featureName + "' not found!");
        } else if (config.chance() > 0 && config.canSpawnInBiome((RegistryKey<Biome>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)event.getName()))) {
            event.getGeneration().func_242513_a(stage, feature);
        }
    }

    public static void addBiomeSpawns(BiomeLoadingEvent event) {
        GFWorldGen.addSpawns(event, GFRegistry.FURY_ENTITY, 3, 3);
        GFWorldGen.addSpawns(event, GFRegistry.LAMPAD_ENTITY, 3, 6);
        GFWorldGen.addSpawns(event, GFRegistry.ORTHUS_ENTITY, 1, 4);
        GFWorldGen.addSpawns(event, GFRegistry.ARA_ENTITY, 2, 5);
        GFWorldGen.addSpawns(event, GFRegistry.CENTAUR_ENTITY, 2, 4);
        GFWorldGen.addSpawns(event, GFRegistry.CERASTES_ENTITY, 1, 2);
        GFWorldGen.addSpawns(event, GFRegistry.CYCLOPES_ENTITY, 1, 3);
        GFWorldGen.addSpawns(event, GFRegistry.CYPRIAN_ENTITY, 1, 3);
        GFWorldGen.addSpawns(event, GFRegistry.DRAKAINA_ENTITY, 1, 2);
        GFWorldGen.addSpawns(event, GFRegistry.DRYAD_ENTITY, 1, 3);
        GFWorldGen.addSpawns(event, GFRegistry.EMPUSA_ENTITY, 1, 2);
        GFWorldGen.addSpawns(event, GFRegistry.GIGANTE_ENTITY, 1, 4);
        GFWorldGen.addSpawns(event, GFRegistry.GORGON_ENTITY, 1, 2);
        GFWorldGen.addSpawns(event, GFRegistry.HARPY_ENTITY, 1, 3);
        GFWorldGen.addSpawns(event, GFRegistry.HYDRA_ENTITY, 1, 1);
        GFWorldGen.addSpawns(event, GFRegistry.MAD_COW_ENTITY, 1, 1);
        GFWorldGen.addSpawns(event, GFRegistry.MINOTAUR_ENTITY, 3, 5);
        GFWorldGen.addSpawns(event, GFRegistry.NAIAD_ENTITY, 2, 5);
        GFWorldGen.addSpawns(event, GFRegistry.PEGASUS_ENTITY, 2, 5);
        GFWorldGen.addSpawns(event, GFRegistry.SATYR_ENTITY, 2, 5);
        GFWorldGen.addSpawns(event, GFRegistry.SHADE_ENTITY, 1, 1);
        GFWorldGen.addSpawns(event, GFRegistry.SIREN_ENTITY, 2, 4);
        GFWorldGen.addSpawns(event, GFRegistry.UNICORN_ENTITY, 2, 5);
        GFWorldGen.addSpawns(event, GFRegistry.WHIRL_ENTITY, 1, 1);
    }

    private static void addSpawns(BiomeLoadingEvent event, EntityType<?> entity, int min, int max) {
        String name = entity.getRegistryName().func_110623_a();
        BiomeWhitelistConfig config = GreekFantasy.CONFIG.MOB_SPAWNS.get(name);
        RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)event.getName());
        if (null == config) {
            GreekFantasy.LOGGER.error("Error registering spawns: config for '" + name + "' not found!");
        } else if (config.chance() > 0 && config.canSpawnInBiome((RegistryKey<Biome>)key)) {
            event.getSpawns().func_242575_a(entity.func_220339_d(), new MobSpawnInfo.Spawners(entity, config.chance(), min, max));
        }
    }

    private static Biome makeOliveForest(float depth, float scale) {
        MobSpawnInfo.Builder builder = new MobSpawnInfo.Builder();
        DefaultBiomeFeatures.func_243714_a((MobSpawnInfo.Builder)builder);
        DefaultBiomeFeatures.func_243737_c((MobSpawnInfo.Builder)builder);
        BiomeGenerationSettings.Builder biomeGenBuilder = new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.field_244178_j);
        DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)biomeGenBuilder);
        biomeGenBuilder.func_242516_a(StructureFeatures.field_244159_y);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)biomeGenBuilder);
        DefaultBiomeFeatures.func_243742_f((BiomeGenerationSettings.Builder)biomeGenBuilder);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)biomeGenBuilder);
        DefaultBiomeFeatures.func_243700_N((BiomeGenerationSettings.Builder)biomeGenBuilder);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)biomeGenBuilder);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)biomeGenBuilder);
        DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)biomeGenBuilder);
        DefaultBiomeFeatures.func_243707_U((BiomeGenerationSettings.Builder)biomeGenBuilder);
        DefaultBiomeFeatures.func_243701_O((BiomeGenerationSettings.Builder)biomeGenBuilder);
        DefaultBiomeFeatures.func_243712_Z((BiomeGenerationSettings.Builder)biomeGenBuilder);
        DefaultBiomeFeatures.func_243717_aa((BiomeGenerationSettings.Builder)biomeGenBuilder);
        DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)biomeGenBuilder);
        DefaultBiomeFeatures.func_243730_an((BiomeGenerationSettings.Builder)biomeGenBuilder);
        return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.FOREST).func_205421_a(depth).func_205420_b(scale).func_205414_c(0.6f).func_205417_d(0.6f).func_235097_a_(new BiomeAmbience.Builder().func_242540_e(10729111).func_242541_f(8955507).func_235246_b_(4159204).func_235248_c_(329011).func_235239_a_(12638463).func_242539_d(GFWorldGen.getSkyColorWithTemperatureModifier(0.6f)).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242458_a(builder.func_242577_b()).func_242457_a(biomeGenBuilder.func_242508_a()).func_242455_a();
    }

    private static int getSkyColorWithTemperatureModifier(float t) {
        float f1 = t;
        f1 /= 3.0f;
        f1 = MathHelper.func_76131_a((float)f1, (float)-1.0f, (float)1.0f);
        return MathHelper.func_181758_c((float)(0.62222224f - f1 * 0.05f), (float)(0.5f + f1 * 0.1f), (float)1.0f);
    }

    static {
        ruleTestStone = new TagMatchRuleTest((ITag)BlockTags.field_242172_aH);
    }
}

