/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy;

import com.google.common.collect.ImmutableSet;
import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.block.StatueBlock;
import greekfantasy.deity.favor.IFavor;
import greekfantasy.tileentity.StatueTileEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;

public class GFWorldSavedData
extends WorldSavedData {
    private Map<ChunkPos, Set<BlockPos>> palladiumMap = new HashMap<ChunkPos, Set<BlockPos>>();
    private static final String KEY_MAP = "PalladiumMap";
    private static final String KEY_SET = "Positions";
    private static final String KEY_CHUNK_X = "ChunkX";
    private static final String KEY_CHUNK_Z = "ChunkZ";
    private static final String KEY_X = "X";
    private static final String KEY_Y = "Y";
    private static final String KEY_Z = "Z";
    private List<UUID> flyingPlayers = new ArrayList<UUID>();
    private static final String KEY_PLAYERS = "FlyingPlayers";

    public GFWorldSavedData(String name) {
        super(name);
    }

    public static GFWorldSavedData getOrCreate(ServerWorld server) {
        return (GFWorldSavedData)server.func_217481_x().func_215752_a(() -> new GFWorldSavedData("greekfantasy"), "greekfantasy");
    }

    public Set<BlockPos> getPalladium(World world, ChunkPos chunk) {
        if (!this.palladiumMap.containsKey(chunk)) {
            this.addAllPalladium(chunk, GFWorldSavedData.fillPalladiumList(world, chunk));
        }
        return ImmutableSet.copyOf((Collection)this.palladiumMap.get(chunk));
    }

    public void addPalladium(ChunkPos chunk, BlockPos pos) {
        if (!this.palladiumMap.containsKey(chunk)) {
            this.palladiumMap.put(chunk, new HashSet());
        }
        this.palladiumMap.get(chunk).add(pos);
        this.func_76185_a();
    }

    public void addAllPalladium(ChunkPos chunk, Set<BlockPos> pos) {
        if (!this.palladiumMap.containsKey(chunk)) {
            this.palladiumMap.put(chunk, new HashSet());
        }
        this.palladiumMap.get(chunk).addAll(pos);
        this.func_76185_a();
    }

    public void putAllPalladium(ChunkPos chunk, Set<BlockPos> pos) {
        this.palladiumMap.put(chunk, pos);
        this.func_76185_a();
    }

    public void removePalladium(ChunkPos chunk, BlockPos pos) {
        if (!this.palladiumMap.containsKey(chunk)) {
            this.palladiumMap.put(chunk, new HashSet());
        }
        this.palladiumMap.get(chunk).remove(pos);
        this.func_76185_a();
    }

    public void addFlyingPlayer(PlayerEntity player) {
        this.flyingPlayers.add(PlayerEntity.func_175147_b((String)player.func_200200_C_().func_150261_e()));
        player.field_71075_bZ.field_75101_c = true;
        player.func_71016_p();
    }

    public void removeFlyingPlayer(PlayerEntity player) {
        this.flyingPlayers.remove(PlayerEntity.func_175147_b((String)player.func_200200_C_().func_150261_e()));
        player.field_71075_bZ.field_75101_c = false;
        player.field_71075_bZ.field_75100_b = false;
        player.func_71016_p();
    }

    public boolean hasFlyingPlayer(PlayerEntity player) {
        return this.flyingPlayers.contains(PlayerEntity.func_175147_b((String)player.func_200200_C_().func_150261_e()));
    }

    public List<UUID> getFlyingPlayers() {
        return this.flyingPlayers;
    }

    public void forEachFlyingPlayer(World worldIn, Consumer<PlayerEntity> action) {
        this.flyingPlayers.forEach(uuid -> {
            PlayerEntity p = worldIn.func_217371_b(uuid);
            if (p != null) {
                action.accept(p);
            }
        });
    }

    public void func_76184_a(CompoundNBT nbt) {
        int i;
        int il;
        if (nbt.func_74764_b(KEY_MAP)) {
            ListNBT chunkMap = nbt.func_150295_c(KEY_MAP, 10);
            il = chunkMap.size();
            for (i = 0; i < il; ++i) {
                CompoundNBT chunk = chunkMap.func_150305_b(i);
                int chunkX = chunk.func_74762_e(KEY_CHUNK_X);
                int chunkZ = chunk.func_74762_e(KEY_CHUNK_Z);
                ListNBT posList = chunk.func_150295_c(KEY_SET, 10);
                HashSet<BlockPos> blockPosSet = new HashSet<BlockPos>();
                int jl = posList.size();
                for (int j = 0; j < jl; ++j) {
                    CompoundNBT posNBT = posList.func_150305_b(j);
                    blockPosSet.add(new BlockPos(posNBT.func_74762_e(KEY_X), posNBT.func_74762_e(KEY_Y), posNBT.func_74762_e(KEY_Z)));
                }
                this.palladiumMap.put(new ChunkPos(chunkX, chunkZ), blockPosSet);
            }
        }
        if (nbt.func_74764_b(KEY_PLAYERS)) {
            ListNBT playerList = nbt.func_150295_c(KEY_PLAYERS, 8);
            il = playerList.size();
            for (i = 0; i < il; ++i) {
                this.flyingPlayers.add(UUID.fromString(playerList.func_150307_f(i)));
            }
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT chunkMap = new ListNBT();
        for (Map.Entry<ChunkPos, Set<BlockPos>> entry : this.palladiumMap.entrySet()) {
            CompoundNBT chunk = new CompoundNBT();
            chunk.func_74768_a(KEY_CHUNK_X, entry.getKey().field_77276_a);
            chunk.func_74768_a(KEY_CHUNK_Z, entry.getKey().field_77275_b);
            ListNBT posList = new ListNBT();
            for (BlockPos p : entry.getValue()) {
                CompoundNBT posNBT = new CompoundNBT();
                posNBT.func_74768_a(KEY_X, p.func_177958_n());
                posNBT.func_74768_a(KEY_Y, p.func_177956_o());
                posNBT.func_74768_a(KEY_Z, p.func_177952_p());
            }
            chunk.func_218657_a(KEY_SET, (INBT)posList);
            chunkMap.add((Object)chunk);
        }
        compound.func_218657_a(KEY_MAP, (INBT)chunkMap);
        ListNBT flyingPlayerList = new ListNBT();
        for (UUID uuid : this.flyingPlayers) {
            flyingPlayerList.add((Object)StringNBT.func_229705_a_((String)uuid.toString()));
        }
        compound.func_218657_a(KEY_PLAYERS, (INBT)flyingPlayerList);
        return compound;
    }

    public static boolean validatePlayer(PlayerEntity player, IFavor favor) {
        ItemStack feet = player.func_184582_a(EquipmentSlotType.FEET);
        return feet.func_77973_b() == GFRegistry.WINGED_SANDALS && EnchantmentHelper.func_77506_a((Enchantment)GFRegistry.FLYING_ENCHANTMENT, (ItemStack)feet) > 0 && GreekFantasy.PROXY.getFavorConfiguration().getEnchantmentRange("flying_enchantment").isInFavorRange(player, favor);
    }

    public static boolean validatePalladium(World world, BlockPos pos) {
        return GFWorldSavedData.validatePalladium(world.func_175625_s(pos));
    }

    public static boolean validatePalladium(@Nullable TileEntity te) {
        return te instanceof StatueTileEntity && ((StatueTileEntity)te).getStatueMaterial() == StatueBlock.StatueMaterial.WOOD;
    }

    private static Set<BlockPos> fillPalladiumList(World world, ChunkPos chunkPos) {
        HashSet<BlockPos> palladiumSet = new HashSet<BlockPos>();
        try {
            Map chunkTEMap = world.func_212866_a_(chunkPos.field_77276_a, chunkPos.field_77275_b).func_177434_r();
            for (Map.Entry e : chunkTEMap.entrySet()) {
                if (!GFWorldSavedData.validatePalladium((TileEntity)e.getValue())) continue;
                palladiumSet.add((BlockPos)e.getKey());
            }
        }
        catch (Exception e) {
            GreekFantasy.LOGGER.error("Encountered an error trying to fill palladium list (GFWorldSavedData)");
        }
        return palladiumSet;
    }
}

