/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.block;

import com.google.common.collect.Maps;
import greekfantasy.GFRegistry;
import java.util.EnumMap;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class CappedPillarBlock
extends Block
implements IWaterLoggable {
    public static final DirectionProperty FACING = DirectionProperty.func_196962_a((String)"facing", (Direction[])Direction.values());
    public static final BooleanProperty HIDDEN = BooleanProperty.func_177716_a((String)"hidden");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape PILLAR_X = Block.func_208617_a((double)0.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0);
    protected static final VoxelShape PILLAR_Y = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    protected static final VoxelShape PILLAR_Z = Block.func_208617_a((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)16.0);
    protected static final EnumMap<Direction, VoxelShape> SLAB_SHAPES = Maps.newEnumMap(Direction.class);

    public CappedPillarBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)Direction.UP)).func_206870_a((Property)HIDDEN, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, HIDDEN, WATERLOGGED});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction side = context.func_196000_l().func_176734_d();
        if (context.func_195999_j().func_225608_bj_() || this.isPillarBlock(context.func_195991_k().func_180495_p(context.func_195995_a().func_177972_a(side)))) {
            side = side.func_176734_d();
        }
        FluidState fluid = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)side)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.func_206884_a((ITag)FluidTags.field_206959_a)));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        Direction capDir;
        BlockState adjacent;
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        boolean hidden = this.isPillarBlock(adjacent = worldIn.func_180495_p(currentPos.func_177972_a(capDir = (Direction)stateIn.func_177229_b((Property)FACING)))) && adjacent.func_177229_b((Property)FACING) == capDir;
        return (BlockState)stateIn.func_206870_a((Property)HIDDEN, (Comparable)Boolean.valueOf(hidden));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext cxt) {
        boolean hidden = (Boolean)state.func_177229_b((Property)HIDDEN);
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        if (!hidden) {
            return SLAB_SHAPES.get(facing);
        }
        if (facing.func_176740_k() == Direction.Axis.Y) {
            return PILLAR_Y;
        }
        if (facing.func_176740_k() == Direction.Axis.X) {
            return PILLAR_X;
        }
        return PILLAR_Z;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : Fluids.field_204541_a.func_207188_f();
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return this.func_185499_a(state, mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    private boolean isPillarBlock(BlockState state) {
        return state.func_177230_c() == GFRegistry.MARBLE_PILLAR || state.func_177230_c() == GFRegistry.LIMESTONE_PILLAR || state.func_177230_c() instanceof CappedPillarBlock;
    }

    static {
        SLAB_SHAPES.put(Direction.UP, VoxelShapes.func_197882_b((VoxelShape)PILLAR_Y, (VoxelShape)Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (IBooleanFunction)IBooleanFunction.field_223244_o_));
        SLAB_SHAPES.put(Direction.DOWN, VoxelShapes.func_197882_b((VoxelShape)PILLAR_Y, (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), (IBooleanFunction)IBooleanFunction.field_223244_o_));
        SLAB_SHAPES.put(Direction.NORTH, VoxelShapes.func_197882_b((VoxelShape)PILLAR_Z, (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (IBooleanFunction)IBooleanFunction.field_223244_o_));
        SLAB_SHAPES.put(Direction.SOUTH, VoxelShapes.func_197882_b((VoxelShape)PILLAR_Z, (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), (IBooleanFunction)IBooleanFunction.field_223244_o_));
        SLAB_SHAPES.put(Direction.EAST, VoxelShapes.func_197882_b((VoxelShape)PILLAR_X, (VoxelShape)Block.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (IBooleanFunction)IBooleanFunction.field_223244_o_));
        SLAB_SHAPES.put(Direction.WEST, VoxelShapes.func_197882_b((VoxelShape)PILLAR_X, (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0), (IBooleanFunction)IBooleanFunction.field_223244_o_));
    }
}

