/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.block;

import greekfantasy.util.MysteriousBoxManager;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MysteriousBoxBlock
extends HorizontalBlock
implements IWaterLoggable {
    public static final BooleanProperty OPEN = BooleanProperty.func_177716_a((String)"open");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape SHAPE_CLOSED_Z = VoxelShapes.func_197882_b((VoxelShape)VoxelShapes.func_197882_b((VoxelShape)Block.func_208617_a((double)1.0, (double)0.0, (double)3.0, (double)15.0, (double)8.0, (double)13.0), (VoxelShape)Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0), (IBooleanFunction)IBooleanFunction.field_223234_e_), (VoxelShape)Block.func_208617_a((double)1.0, (double)0.0, (double)5.0, (double)15.0, (double)2.0, (double)11.0), (IBooleanFunction)IBooleanFunction.field_223234_e_);
    protected static final VoxelShape SHAPE_OPEN_Z = VoxelShapes.func_197882_b((VoxelShape)SHAPE_CLOSED_Z, (VoxelShape)Block.func_208617_a((double)2.0, (double)3.0, (double)4.0, (double)14.0, (double)8.0, (double)12.0), (IBooleanFunction)IBooleanFunction.field_223234_e_);
    protected static final VoxelShape SHAPE_CLOSED_X = VoxelShapes.func_197882_b((VoxelShape)VoxelShapes.func_197882_b((VoxelShape)Block.func_208617_a((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)8.0, (double)15.0), (VoxelShape)Block.func_208617_a((double)5.0, (double)0.0, (double)1.0, (double)11.0, (double)2.0, (double)15.0), (IBooleanFunction)IBooleanFunction.field_223234_e_), (VoxelShape)Block.func_208617_a((double)1.0, (double)0.0, (double)3.0, (double)15.0, (double)2.0, (double)13.0), (IBooleanFunction)IBooleanFunction.field_223234_e_);
    protected static final VoxelShape SHAPE_OPEN_X = VoxelShapes.func_197882_b((VoxelShape)SHAPE_CLOSED_X, (VoxelShape)Block.func_208617_a((double)4.0, (double)3.0, (double)2.0, (double)12.0, (double)8.0, (double)14.0), (IBooleanFunction)IBooleanFunction.field_223234_e_);

    public MysteriousBoxBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D}).func_206894_a(new Property[]{OPEN}).func_206894_a(new Property[]{WATERLOGGED});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluid = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)super.func_196258_a(context).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.func_206884_a((ITag)FluidTags.field_206959_a)))).func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f().func_176734_d());
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return stateIn;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : Fluids.field_204541_a.func_207188_f();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand handIn, BlockRayTraceResult hit) {
        if (!((Boolean)state.func_177229_b((Property)OPEN)).booleanValue()) {
            boolean open;
            this.addSmokeParticles(worldIn, pos, worldIn.field_73012_v, 32);
            if (playerIn.func_70613_aW() && (open = MysteriousBoxManager.onBoxOpened(worldIn, playerIn, state, pos))) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(true)), 2);
            }
            return ActionResultType.CONSUME;
        }
        return ActionResultType.SUCCESS;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext cxt) {
        boolean axisX = ((Direction)state.func_177229_b((Property)field_185512_D)).func_176740_k() == Direction.Axis.X;
        boolean open = (Boolean)state.func_177229_b((Property)OPEN);
        if (axisX && open) {
            return SHAPE_OPEN_X;
        }
        if (axisX && !open) {
            return SHAPE_CLOSED_X;
        }
        if (!axisX && open) {
            return SHAPE_OPEN_Z;
        }
        return SHAPE_CLOSED_Z;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World worldIn, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)OPEN) != false ? 1 : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World world, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((Property)OPEN)).booleanValue()) {
            this.addSmokeParticles(world, pos, rand, 3);
        }
    }

    private void addSmokeParticles(World world, BlockPos pos, Random rand, int count) {
        double x = (double)pos.func_177958_n() + 0.5;
        double y = (double)pos.func_177956_o() + 0.22;
        double z = (double)pos.func_177952_p() + 0.5;
        double motion = 0.08;
        double radius = 0.25;
        for (int i = 0; i < count; ++i) {
            world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + (world.field_73012_v.nextDouble() - 0.5) * 0.25, y, z + (world.field_73012_v.nextDouble() - 0.5) * 0.25, (world.field_73012_v.nextDouble() - 0.5) * 0.08, (world.field_73012_v.nextDouble() - 0.5) * 0.08 * 0.5, (world.field_73012_v.nextDouble() - 0.5) * 0.08);
        }
    }
}

