/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.block;

import greekfantasy.GFRegistry;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.PortalSize;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class OilBlock
extends Block
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    protected final float fireDamage;
    protected static final VoxelShape shape = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    protected static final VoxelShape shapeWaterlogged = Block.func_208617_a((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);

    public OilBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.fireDamage = 2.5f;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LIT, WATERLOGGED});
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand handIn, BlockRayTraceResult hit) {
        ItemStack heldItem = playerIn.func_184586_b(handIn);
        if (!(worldIn.func_201670_d() || ((Boolean)state.func_177229_b((Property)LIT)).booleanValue() || heldItem.func_190926_b())) {
            if (heldItem.func_77973_b() == Items.field_151069_bo) {
                worldIn.func_175655_b(pos, false);
                if (!playerIn.func_184812_l_()) {
                    heldItem.func_190918_g(1);
                }
                playerIn.func_191521_c(new ItemStack((IItemProvider)GFRegistry.OLIVE_OIL));
                return ActionResultType.CONSUME;
            }
            if (heldItem.func_77973_b() == Items.field_151033_d) {
                OilBlock.setFire((IWorld)worldIn, state, pos);
                playerIn.func_184185_a(SoundEvents.field_187649_bu, 0.4f, 1.0f);
                heldItem.func_222118_a(1, (LivingEntity)playerIn, i -> i.func_213361_c(EquipmentSlotType.MAINHAND));
                return ActionResultType.CONSUME;
            }
        }
        return ActionResultType.PASS;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        boolean nextToFire;
        if (!this.func_196260_a(state, (IWorldReader)worldIn, pos)) {
            worldIn.func_175655_b(pos, false);
        }
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150355_j) {
                worldIn.func_175656_a(pos.func_177984_a(), state);
                worldIn.func_180501_a(pos, state.func_204520_s().func_206883_i(), 2);
                worldIn.func_205220_G_().func_205360_a(pos.func_177984_a(), (Object)this, 40);
                return;
            }
            if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
                worldIn.func_180501_a(pos, state.func_204520_s().func_206883_i(), 2);
                worldIn.func_205220_G_().func_205360_a(pos.func_177984_a(), (Object)this, 40);
                return;
            }
        }
        if (nextToFire = OilBlock.nextToFire((IWorld)worldIn, pos)) {
            if (worldIn.func_201674_k().nextInt(10) == 0) {
                OilBlock.setFire((IWorld)worldIn, state, pos);
            } else {
                worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 2 + rand.nextInt(5));
            }
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!this.func_196260_a(stateIn, (IWorldReader)worldIn, currentPos)) {
            return stateIn.func_204520_s().func_206883_i();
        }
        if (OilBlock.isFire(worldIn, facingState, facingPos)) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 5);
        }
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            if (((Boolean)stateIn.func_177229_b((Property)LIT)).booleanValue() && worldIn.func_180495_p(currentPos.func_177984_a()).func_177230_c() != Blocks.field_235335_bO_) {
                worldIn.func_175655_b(currentPos, false);
            } else {
                worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 2);
                worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
            }
        }
        return stateIn;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluid = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean waterlogged = fluid.func_206884_a((ITag)FluidTags.field_206959_a);
        if (waterlogged || OilBlock.nextToFire((IWorld)context.func_195991_k(), context.func_195995_a())) {
            context.func_195991_k().func_205220_G_().func_205360_a(context.func_195995_a(), (Object)this, 5);
        }
        return (BlockState)super.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) == false ? shape : shapeWaterlogged;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : Fluids.field_204541_a.func_207188_f();
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World worldIn, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)LIT) != false ? 15 : 0;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_204520_s().func_206886_c() == Fluids.field_204546_a || worldIn.func_180495_p(pos.func_177977_b()).func_200015_d((IBlockReader)worldIn, pos.func_177977_b());
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (((Boolean)state.func_177229_b((Property)LIT)).booleanValue() && !entityIn.func_230279_az_()) {
            entityIn.func_241209_g_(entityIn.func_223314_ad() + 1);
            if (entityIn.func_223314_ad() == 0) {
                entityIn.func_70015_d(9);
            }
            entityIn.func_70097_a(DamageSource.field_76372_a, this.fireDamage);
        }
        super.func_196262_a(state, worldIn, pos, entityIn);
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.func_203425_a(state.func_177230_c())) {
            if (((Boolean)state.func_177229_b((Property)LIT)).booleanValue() && OilBlock.canLightPortal(worldIn)) {
                Optional optional = PortalSize.func_242964_a((IWorld)worldIn, (BlockPos)pos, (Direction.Axis)Direction.Axis.X);
                if ((optional = ForgeEventFactory.onTrySpawnPortal((IWorld)worldIn, (BlockPos)pos, (Optional)optional)).isPresent()) {
                    ((PortalSize)optional.get()).func_150859_c();
                    return;
                }
            }
            if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
                worldIn.func_217377_a(pos, false);
            }
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        if (((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
            if (!worldIn.func_201670_d()) {
                worldIn.func_217378_a((PlayerEntity)null, 1009, pos, 0);
            }
        } else {
            super.func_176208_a(worldIn, pos, state, player);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((Property)LIT)).booleanValue()) {
            if (rand.nextInt(24) == 0) {
                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
            }
            for (int i = 0; i < 2; ++i) {
                double d0 = (double)pos.func_177958_n() + rand.nextDouble();
                double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 0.5 + 0.5;
                double d2 = (double)pos.func_177952_p() + rand.nextDouble();
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197594_E, d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    private static boolean canLightPortal(World world) {
        return world.func_234923_W_() == World.field_234918_g_ || world.func_234923_W_() == World.field_234919_h_;
    }

    private static boolean nextToFire(IWorld world, BlockPos pos) {
        for (Direction d : Direction.values()) {
            BlockPos p = pos.func_177972_a(d);
            BlockState s = world.func_180495_p(p);
            if (!OilBlock.isFire(world, s, p)) continue;
            return true;
        }
        return false;
    }

    private static boolean isFire(IWorld world, BlockState state, BlockPos pos) {
        return state.func_235714_a_((ITag)BlockTags.field_232872_am_) || state.func_177230_c() == GFRegistry.OIL && (Boolean)state.func_177229_b((Property)LIT) != false;
    }

    public static void setFire(IWorld worldIn, BlockState state, BlockPos pos) {
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(true)), 3);
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue() && worldIn.func_175623_d(pos.func_177984_a())) {
            worldIn.func_180501_a(pos.func_177984_a(), Blocks.field_235335_bO_.func_176223_P(), 3);
        }
    }
}

